/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.entity;

import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import radon.jujutsu_kaisen.VeilHandler;
import radon.jujutsu_kaisen.ability.JJKAbilities;
import radon.jujutsu_kaisen.ability.base.DomainExpansion;
import radon.jujutsu_kaisen.block.entity.VeilBlockEntity;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.capability.data.sorcerer.Trait;
import radon.jujutsu_kaisen.entity.ClosedDomainExpansionEntity;
import radon.jujutsu_kaisen.entity.base.DomainExpansionEntity;
import radon.jujutsu_kaisen.network.PacketHandler;
import radon.jujutsu_kaisen.network.packet.s2c.SyncSorcererDataS2CPacket;
import radon.jujutsu_kaisen.util.RotationUtil;

public abstract class OpenDomainExpansionEntity
extends DomainExpansionEntity {
    private static final EntityDataAccessor<Integer> DATA_WIDTH = SynchedEntityData.m_135353_(OpenDomainExpansionEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DATA_HEIGHT = SynchedEntityData.m_135353_(OpenDomainExpansionEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public OpenDomainExpansionEntity(EntityType<?> pType, Level pLevel) {
        super(pType, pLevel);
    }

    public OpenDomainExpansionEntity(EntityType<?> pType, LivingEntity owner, DomainExpansion ability, int width, int height) {
        super(pType, owner, ability);
        Vec3 pos = owner.m_20182_().m_82546_(RotationUtil.getTargetAdjustedLookAngle((Entity)owner).m_82542_((double)this.m_20205_(), 0.0, (double)this.m_20205_()));
        this.m_7678_(pos.f_82479_, pos.f_82480_, pos.f_82481_, RotationUtil.getTargetAdjustedYRot((Entity)owner), RotationUtil.getTargetAdjustedXRot((Entity)owner));
        this.f_19804_.m_135381_(DATA_WIDTH, (Object)width);
        this.f_19804_.m_135381_(DATA_HEIGHT, (Object)height);
    }

    public void m_7334_(@NotNull Entity pEntity) {
    }

    public boolean m_5829_() {
        return true;
    }

    @Override
    public boolean isAffected(BlockPos pos) {
        BlockEntity blockEntity = this.m_9236_().m_7702_(pos);
        if (blockEntity instanceof VeilBlockEntity) {
            VeilBlockEntity veilBe = (VeilBlockEntity)blockEntity;
            if (this.checkVeil(pos, this.getOwner())) {
                return false;
            }
        }
        if (VeilHandler.isProtected(this.m_9236_(), pos)) {
            return false;
        }
        Set<DomainExpansionEntity> domains = VeilHandler.getDomains((ServerLevel)this.m_9236_(), pos);
        for (DomainExpansionEntity domain : domains) {
            if (domain == this) continue;
            return false;
        }
        return super.isAffected(pos);
    }

    public int getWidth() {
        return (Integer)this.f_19804_.m_135370_(DATA_WIDTH);
    }

    public int getHeight() {
        return (Integer)this.f_19804_.m_135370_(DATA_HEIGHT);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_WIDTH, (Object)0);
        this.f_19804_.m_135372_(DATA_HEIGHT, (Object)0);
    }

    @Override
    public void m_7380_(@NotNull CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128405_("width", this.getWidth());
        pCompound.m_128405_("height", this.getHeight());
    }

    @Override
    public void m_7378_(@NotNull CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.f_19804_.m_135381_(DATA_WIDTH, (Object)pCompound.m_128451_("width"));
        this.f_19804_.m_135381_(DATA_HEIGHT, (Object)pCompound.m_128451_("height"));
    }

    protected void doSureHitEffect(@NotNull LivingEntity owner) {
        for (LivingEntity entity : this.getAffected()) {
            if (JJKAbilities.hasTrait(entity, Trait.HEAVENLY_RESTRICTION)) {
                this.ability.onHitBlock(this, owner, entity.m_20183_());
                continue;
            }
            this.ability.onHitEntity(this, owner, entity, false);
        }
    }

    @Override
    public AABB getBounds() {
        int width = this.getWidth();
        int height = this.getHeight();
        return new AABB(this.m_20185_() - (double)width, this.m_20186_() - (double)height / 2.0, this.m_20189_() - (double)width, this.m_20185_() + (double)width, this.m_20186_() + (double)height / 2.0, this.m_20189_() + (double)width);
    }

    @Override
    public boolean isInsideBarrier(BlockPos pos) {
        int width = this.getWidth();
        BlockPos center = this.m_20183_();
        BlockPos relative = pos.m_121996_((Vec3i)center);
        return relative.m_123331_(Vec3i.f_123288_) < (double)(width * width);
    }

    @Override
    public boolean shouldCollapse(float strength) {
        return strength / this.getStrength() > 2.75f;
    }

    @Override
    public boolean checkSureHitEffect() {
        for (DomainExpansionEntity domain : VeilHandler.getDomains((ServerLevel)this.m_9236_(), this.getBounds())) {
            ClosedDomainExpansionEntity closed;
            if (domain == this || domain instanceof ClosedDomainExpansionEntity && !(closed = (ClosedDomainExpansionEntity)domain).isInsideBarrier(this.m_20183_())) continue;
            if (this.shouldCollapse(domain.getStrength())) {
                this.m_146870_();
            }
            return false;
        }
        return true;
    }

    public void onRemovedFromWorld() {
        LivingEntity owner;
        if (!this.m_9236_().f_46443_ && (owner = this.getOwner()) != null) {
            owner.getCapability(SorcererDataHandler.INSTANCE).ifPresent(cap -> {
                cap.setBurnout(600);
                cap.resetSpeedStacks();
                if (owner instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)owner;
                    PacketHandler.sendToClient(new SyncSorcererDataS2CPacket(cap.serializeNBT()), player);
                }
            });
        }
        super.onRemovedFromWorld();
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        LivingEntity owner = this.getOwner();
        if (owner == null) {
            return;
        }
        if (!this.m_9236_().f_46443_ && this.checkSureHitEffect()) {
            this.doSureHitEffect(owner);
        }
    }
}

