/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.entity.curse;

import java.util.List;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import radon.jujutsu_kaisen.capability.data.sorcerer.CursedEnergyNature;
import radon.jujutsu_kaisen.capability.data.sorcerer.CursedTechnique;
import radon.jujutsu_kaisen.capability.data.sorcerer.Trait;
import radon.jujutsu_kaisen.entity.curse.base.CursedSpirit;
import radon.jujutsu_kaisen.util.RotationUtil;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class JogoatEntity
extends CursedSpirit {
    public static EntityDataAccessor<Integer> DATA_SMASH = SynchedEntityData.m_135353_(JogoatEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final RawAnimation WALK = RawAnimation.begin().thenLoop("move.walk");
    private static final RawAnimation RUN = RawAnimation.begin().thenLoop("move.run");
    private static final RawAnimation SWING = RawAnimation.begin().thenPlay("attack.swing");
    private static final RawAnimation SMASH = RawAnimation.begin().thenPlay("attack.smash");
    private static final double SMASH_LAUNCH = 5.0;
    private static final float SMASH_EXPLOSION = 2.5f;
    private static final int SMASH_DURATION = 20;

    public JogoatEntity(EntityType<? extends TamableAnimal> pType, Level pLevel) {
        super(pType, pLevel);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_SMASH, (Object)0);
    }

    @Override
    protected boolean isCustom() {
        return false;
    }

    @Override
    public boolean hasMeleeAttack() {
        return true;
    }

    @Override
    public boolean hasArms() {
        return true;
    }

    @Override
    public boolean canJump() {
        return true;
    }

    @Override
    public boolean canChant() {
        return true;
    }

    @Override
    public float getExperience() {
        return 1000000.0f;
    }

    @Override
    @Nullable
    public CursedTechnique getTechnique() {
        return null;
    }

    @Override
    @NotNull
    public List<Trait> getTraits() {
        return List.of(Trait.SIX_EYES);
    }

    @Override
    public float getMaxEnergy() {
        return Float.POSITIVE_INFINITY;
    }

    @Override
    @Nullable
    public CursedEnergyNature getNature() {
        return CursedEnergyNature.LIGHTNING;
    }

    @Override
    protected void m_8024_() {
        super.m_8024_();
        LivingEntity target = this.m_5448_();
        int slash = (Integer)this.f_19804_.m_135370_(DATA_SMASH);
        if (slash > 0) {
            this.f_19804_.m_135381_(DATA_SMASH, (Object)(--slash));
        } else if (target != null && this.m_20096_() && (double)this.m_20270_((Entity)target) < 3.0) {
            this.f_19804_.m_135381_(DATA_SMASH, (Object)20);
            target.m_20256_(RotationUtil.getTargetAdjustedLookAngle((Entity)this).m_82490_(5.0));
            target.f_19864_ = true;
            Vec3 explosionPos = new Vec3(this.m_20185_(), this.m_20188_() - 0.2, this.m_20189_()).m_82549_(RotationUtil.getTargetAdjustedLookAngle((Entity)this));
            this.m_9236_().m_255391_((Entity)this, explosionPos.f_82479_, explosionPos.f_82480_, explosionPos.f_82481_, 2.5f, false, Level.ExplosionInteraction.NONE);
        }
    }

    private PlayState walkRunPredicate(AnimationState<JogoatEntity> animationState) {
        if (animationState.isMoving()) {
            return animationState.setAndContinue(this.m_20142_() ? RUN : WALK);
        }
        return PlayState.STOP;
    }

    private PlayState swingPredicate(AnimationState<JogoatEntity> animationState) {
        if (this.f_20911_) {
            return animationState.setAndContinue(SWING);
        }
        animationState.getController().forceAnimationReset();
        return PlayState.STOP;
    }

    private PlayState smashPredicate(AnimationState<JogoatEntity> animationState) {
        int smash = (Integer)this.f_19804_.m_135370_(DATA_SMASH);
        if (smash > 0) {
            return animationState.setAndContinue(SMASH);
        }
        animationState.getController().forceAnimationReset();
        return PlayState.STOP;
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "Walk/Run", this::walkRunPredicate)});
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "Swing", this::swingPredicate)});
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "Smash", this::smashPredicate)});
    }
}

