/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.entity.effect;

import java.util.UUID;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import radon.jujutsu_kaisen.entity.JJKEntities;
import radon.jujutsu_kaisen.entity.projectile.CursedBudProjectile;
import radon.jujutsu_kaisen.entity.projectile.base.JujutsuProjectile;
import radon.jujutsu_kaisen.util.EntityUtil;
import radon.jujutsu_kaisen.util.RotationUtil;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class DisasterPlantEntity
extends JujutsuProjectile
implements GeoEntity {
    private static final EntityDataAccessor<Integer> DATA_BUD_COUNT = SynchedEntityData.m_135353_(DisasterPlantEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final int DEFAULT_BUD_COUNT = 15;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    @Nullable
    private UUID targetUUID;
    @Nullable
    private LivingEntity cachedTarget;

    public DisasterPlantEntity(EntityType<? extends Projectile> pType, Level pLevel) {
        super(pType, pLevel);
    }

    public DisasterPlantEntity(LivingEntity owner, float power, LivingEntity target) {
        super((EntityType<? extends Projectile>)((EntityType)JJKEntities.DISASTER_PLANT.get()), owner.m_9236_(), (Entity)owner, power * 0.4f);
        this.setTarget(target);
        Vec3 look = RotationUtil.getTargetAdjustedLookAngle((Entity)owner);
        EntityUtil.offset((Entity)this, look, owner.m_20182_().m_82546_(look.m_82542_((double)this.m_20205_(), 0.0, (double)this.m_20205_())));
    }

    @NotNull
    public Vec3 m_20184_() {
        return Vec3.f_82478_;
    }

    public int getBudCount() {
        return (Integer)this.f_19804_.m_135370_(DATA_BUD_COUNT);
    }

    public void setTarget(@Nullable LivingEntity target) {
        if (target != null) {
            this.targetUUID = target.m_20148_();
            this.cachedTarget = target;
        }
    }

    @Nullable
    public LivingEntity getTarget() {
        if (this.cachedTarget != null && !this.cachedTarget.m_213877_()) {
            return this.cachedTarget;
        }
        if (this.targetUUID != null && this.m_9236_() instanceof ServerLevel) {
            this.cachedTarget = (LivingEntity)((ServerLevel)this.m_9236_()).m_8791_(this.targetUUID);
            return this.cachedTarget;
        }
        return null;
    }

    @Override
    public void m_7380_(@NotNull CompoundTag pCompound) {
        super.m_7380_(pCompound);
        if (this.targetUUID != null) {
            pCompound.m_128362_("target", this.targetUUID);
        }
    }

    @Override
    public void m_7378_(@NotNull CompoundTag pCompound) {
        super.m_7378_(pCompound);
        if (pCompound.m_128403_("target")) {
            this.targetUUID = pCompound.m_128342_("target");
        }
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_BUD_COUNT, (Object)15);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().f_46443_) {
            return;
        }
        LivingEntity target = this.getTarget();
        if (target == null || !target.m_6084_() || target.m_213877_()) {
            this.m_146870_();
            return;
        }
        this.m_7618_(EntityAnchorArgument.Anchor.EYES, target.m_20182_().m_82520_(0.0, (double)(target.m_20206_() / 2.0f), 0.0));
        Entity entity = this.m_19749_();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity owner = (LivingEntity)entity;
        int buds = (Integer)this.f_19804_.m_135370_(DATA_BUD_COUNT);
        if (buds == 0) {
            this.m_146870_();
        } else if (this.getTime() % 15 == 0) {
            this.m_9236_().m_7967_((Entity)new CursedBudProjectile(owner, this.getPower(), this));
            this.f_19804_.m_135381_(DATA_BUD_COUNT, (Object)(--buds));
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

