/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.entity.effect;

import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import radon.jujutsu_kaisen.entity.JJKEntities;
import radon.jujutsu_kaisen.entity.projectile.base.JujutsuProjectile;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class ForestRootsEntity
extends JujutsuProjectile
implements GeoEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private float DURATION;
    private float chanted;
    @Nullable
    private UUID victimUUID;
    @Nullable
    private LivingEntity cachedVictim;
    private Vec3 pos;

    public ForestRootsEntity(EntityType<? extends Projectile> pType, Level pLevel) {
        super(pType, pLevel);
        this.f_19811_ = true;
    }

    public ForestRootsEntity(LivingEntity owner, float power, LivingEntity target, float chant) {
        this((EntityType<? extends Projectile>)((EntityType)JJKEntities.FOREST_ROOTS.get()), target.m_9236_());
        this.m_5602_((Entity)owner);
        this.setPower(power);
        this.setVictim(target);
        this.pos = target.m_20182_();
        this.m_7678_(target.m_20185_(), target.m_20186_(), target.m_20189_(), target.m_146908_(), 0.0f);
        this.chanted = chant;
        this.DURATION = 40.0f * this.chanted;
    }

    @Override
    public void m_8119_() {
        LivingEntity victim = this.getVictim();
        if (!(this.m_9236_().f_46443_ || victim != null && !victim.m_213877_() && victim.m_6084_())) {
            this.m_146870_();
        } else {
            super.m_8119_();
            if (this.DURATION != 0.0f && (float)this.getTime() >= this.DURATION) {
                this.m_146870_();
            } else if (victim != null && this.pos != null) {
                victim.m_6021_(this.pos.f_82479_, this.pos.f_82480_, this.pos.f_82481_);
            }
        }
    }

    public void setVictim(@Nullable LivingEntity victim) {
        if (victim != null) {
            this.victimUUID = victim.m_20148_();
            this.cachedVictim = victim;
        }
    }

    @Nullable
    public LivingEntity getVictim() {
        if (this.cachedVictim != null && !this.cachedVictim.m_213877_()) {
            return this.cachedVictim;
        }
        if (this.victimUUID != null && this.m_9236_() instanceof ServerLevel) {
            this.cachedVictim = (LivingEntity)((ServerLevel)this.m_9236_()).m_8791_(this.victimUUID);
            return this.cachedVictim;
        }
        return null;
    }

    @Override
    public void m_7380_(@NotNull CompoundTag pCompound) {
        pCompound.m_128347_("pos_x", this.pos.f_82479_);
        pCompound.m_128347_("pos_y", this.pos.f_82480_);
        pCompound.m_128347_("pos_z", this.pos.f_82481_);
        if (this.victimUUID != null) {
            pCompound.m_128362_("victim", this.victimUUID);
        }
    }

    @Override
    public void m_7378_(@NotNull CompoundTag pCompound) {
        this.pos = new Vec3(pCompound.m_128459_("pos_x"), pCompound.m_128459_("pos_y"), pCompound.m_128459_("pos_z"));
        if (pCompound.m_128403_("victim")) {
            this.victimUUID = pCompound.m_128342_("victim");
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

