/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.entity.effect;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import radon.jujutsu_kaisen.ability.JJKAbilities;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.damage.JJKDamageSources;
import radon.jujutsu_kaisen.effect.JJKEffects;
import radon.jujutsu_kaisen.entity.JJKEntities;
import radon.jujutsu_kaisen.entity.projectile.base.JujutsuProjectile;
import radon.jujutsu_kaisen.util.HelperMethods;
import radon.jujutsu_kaisen.util.RotationUtil;

public class LightningEntity
extends JujutsuProjectile {
    public static final float SCALE = 2.0f;
    public static final double RANGE = 40.0;
    public double endPosX;
    public double endPosY;
    public double endPosZ;
    public double collidePosX;
    public double collidePosY;
    public double collidePosZ;
    public int life;
    @Nullable
    public Direction side = null;
    private static final EntityDataAccessor<Float> DATA_YAW = SynchedEntityData.m_135353_(LightningEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> DATA_PITCH = SynchedEntityData.m_135353_(LightningEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public int animation;

    public LightningEntity(EntityType<? extends Projectile> pType, Level pLevel) {
        super(pType, pLevel);
        this.f_19811_ = true;
        this.life = 4;
    }

    public LightningEntity(EntityType<? extends Projectile> pType, LivingEntity owner, float power) {
        this(pType, owner.m_9236_());
        this.m_5602_((Entity)owner);
        this.setPower(power);
    }

    public LightningEntity(LivingEntity owner, float power) {
        this((EntityType<? extends Projectile>)((EntityType)JJKEntities.LIGHTNING.get()), owner, power);
        this.m_5602_((Entity)owner);
        this.setPower(power);
    }

    protected float getDamage() {
        return 18.0f;
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        Entity entity = this.m_19749_();
        if (entity instanceof LivingEntity) {
            LivingEntity owner = (LivingEntity)entity;
            this.setYaw((float)((double)(owner.m_146908_() + 90.0f) * Math.PI / 180.0));
            this.setPitch((float)((double)(-owner.m_146909_()) * Math.PI / 180.0));
            Vec3 spawn = this.calculateStartPos();
            this.m_6034_(spawn.f_82479_, spawn.f_82480_, spawn.f_82481_);
        }
        this.calculateEndPos();
        this.checkCollisions(new Vec3(this.m_20185_(), this.m_20186_(), this.m_20189_()), new Vec3(this.endPosX, this.endPosY, this.endPosZ));
    }

    @Override
    public void m_8119_() {
        Entity entity;
        super.m_8119_();
        this.f_19854_ = this.m_20185_();
        this.f_19855_ = this.m_20186_();
        this.f_19856_ = this.m_20189_();
        if (this.life == 2 && (entity = this.m_19749_()) instanceof LivingEntity) {
            LivingEntity owner = (LivingEntity)entity;
            this.calculateEndPos();
            List<Entity> entities = this.checkCollisions(new Vec3(this.m_20185_(), this.m_20186_(), this.m_20189_()), new Vec3(this.endPosX, this.endPosY, this.endPosZ));
            if (!this.m_9236_().f_46443_) {
                for (Entity entity2 : entities) {
                    this.m_5496_(SoundEvents.f_12089_, 2.0f, 0.5f + this.f_19796_.m_188501_() * 0.2f);
                    if (entity2 instanceof LivingEntity) {
                        ((LivingEntity)entity2).m_7292_(new MobEffectInstance((MobEffect)JJKEffects.STUN.get(), 20, 0, false, false, false));
                    }
                    entity2.m_6469_((DamageSource)JJKDamageSources.indirectJujutsuAttack((Entity)this, owner, (Ability)JJKAbilities.LIGHTNING.get()), this.getDamage() * this.getPower());
                }
                double radius = 1.5;
                AABB bounds = new AABB(this.collidePosX - radius, this.collidePosY - radius, this.collidePosZ - radius, this.collidePosX + radius, this.collidePosY + radius, this.collidePosZ + radius);
                double centerX = bounds.m_82399_().f_82479_;
                double centerY = bounds.m_82399_().f_82480_;
                double centerZ = bounds.m_82399_().f_82481_;
                int x = (int)bounds.f_82288_;
                while ((double)x <= bounds.f_82291_) {
                    int y = (int)bounds.f_82289_;
                    while ((double)y <= bounds.f_82292_) {
                        int z = (int)bounds.f_82290_;
                        while ((double)z <= bounds.f_82293_) {
                            BlockPos pos = new BlockPos(x, y, z);
                            double distance = Math.sqrt(Math.pow((double)x - centerX, 2.0) + Math.pow((double)y - centerY, 2.0) + Math.pow((double)z - centerZ, 2.0));
                            if (distance <= radius && HelperMethods.isDestroyable((BlockGetter)this.m_9236_(), owner, pos)) {
                                this.m_9236_().m_46961_(pos, false);
                            }
                            ++z;
                        }
                        ++y;
                    }
                    ++x;
                }
            }
        }
        if (--this.life == 0) {
            this.m_146870_();
        }
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_YAW, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(DATA_PITCH, (Object)Float.valueOf(0.0f));
    }

    public float getYaw() {
        return ((Float)this.f_19804_.m_135370_(DATA_YAW)).floatValue();
    }

    public void setYaw(float yaw) {
        this.f_19804_.m_135381_(DATA_YAW, (Object)Float.valueOf(yaw));
    }

    public float getPitch() {
        return ((Float)this.f_19804_.m_135370_(DATA_PITCH)).floatValue();
    }

    public void setPitch(float pitch) {
        this.f_19804_.m_135381_(DATA_PITCH, (Object)Float.valueOf(pitch));
    }

    protected Vec3 calculateStartPos() {
        Entity owner = this.m_19749_();
        if (owner == null) {
            return Vec3.f_82478_;
        }
        Vec3 look = RotationUtil.getTargetAdjustedLookAngle(owner);
        return new Vec3(owner.m_20185_(), owner.m_20188_() - (double)(this.m_20206_() / 2.0f), owner.m_20189_()).m_82549_(look);
    }

    protected void calculateEndPos() {
        this.endPosX = this.m_20185_() + 40.0 * Math.cos(this.getYaw()) * Math.cos(this.getPitch());
        this.endPosZ = this.m_20189_() + 40.0 * Math.sin(this.getYaw()) * Math.cos(this.getPitch());
        this.endPosY = this.m_20186_() + 40.0 * Math.sin(this.getPitch());
    }

    public List<Entity> checkCollisions(Vec3 from, Vec3 to) {
        BlockHitResult result = this.m_9236_().m_45547_(new ClipContext(from, to, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
        if (result.m_6662_() != HitResult.Type.MISS) {
            Vec3 pos = result.m_82450_();
            this.collidePosX = pos.f_82479_;
            this.collidePosY = pos.f_82480_;
            this.collidePosZ = pos.f_82481_;
            this.side = result.m_82434_();
        } else {
            this.collidePosX = this.endPosX;
            this.collidePosY = this.endPosY;
            this.collidePosZ = this.endPosZ;
            this.side = null;
        }
        ArrayList<Entity> entities = new ArrayList<Entity>();
        AABB bounds = new AABB(Math.min(this.m_20185_(), this.collidePosX), Math.min(this.m_20186_(), this.collidePosY), Math.min(this.m_20189_(), this.collidePosZ), Math.max(this.m_20185_(), this.collidePosX), Math.max(this.m_20186_(), this.collidePosY), Math.max(this.m_20189_(), this.collidePosZ)).m_82400_(2.0);
        for (Entity entity : this.m_9236_().m_45933_(this.m_19749_(), bounds)) {
            float pad = entity.m_6143_() + 2.0f;
            AABB padded = entity.m_20191_().m_82377_((double)pad, (double)pad, (double)pad);
            Optional hit = padded.m_82371_(from, to);
            if (padded.m_82390_(from)) {
                entities.add(entity);
                continue;
            }
            if (!hit.isPresent()) continue;
            entities.add(entity);
        }
        return entities;
    }

    @Override
    public boolean m_6783_(double distance) {
        return distance < 1024.0;
    }
}

