/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.entity.effect;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import radon.jujutsu_kaisen.ability.JJKAbilities;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.damage.JJKDamageSources;
import radon.jujutsu_kaisen.entity.JJKEntities;
import radon.jujutsu_kaisen.entity.projectile.base.JujutsuProjectile;
import radon.jujutsu_kaisen.util.HelperMethods;
import radon.jujutsu_kaisen.util.RotationUtil;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class VolcanoEntity
extends JujutsuProjectile
implements GeoEntity {
    public static final int DELAY = 15;
    private static final int DURATION = 70;
    private static final float DAMAGE = 8.0f;
    private static final double RANGE = 20.0;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public VolcanoEntity(EntityType<? extends Projectile> pType, Level pLevel) {
        super(pType, pLevel);
    }

    public VolcanoEntity(LivingEntity owner, float power, BlockPos pos, Direction dir) {
        super((EntityType<? extends Projectile>)((EntityType)JJKEntities.VOLCANO.get()), owner.m_9236_(), (Entity)owner, power);
        Vec3 center = pos.m_121945_(dir).m_252807_();
        center = center.m_82492_((double)dir.m_122429_() * 0.5, (double)dir.m_122430_() * 0.5, (double)dir.m_122431_() * 0.5);
        float xRot = (float)(Mth.m_14136_((double)dir.m_122430_(), (double)dir.m_122429_()) * 180.0 / 3.1415927410125732);
        switch (dir) {
            case UP: 
            case DOWN: {
                xRot = -xRot;
                break;
            }
            case WEST: {
                xRot -= 180.0f;
            }
        }
        this.m_7678_(center.f_82479_, center.f_82480_ - (double)(this.m_20206_() / 2.0f), center.f_82481_, dir.m_122435_(), xRot);
    }

    @NotNull
    public Vec3 m_20184_() {
        return Vec3.f_82478_;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.getTime() >= 70) {
            this.m_146870_();
        } else if (this.getTime() >= 15) {
            Vec3 look = RotationUtil.getTargetAdjustedLookAngle((Entity)this);
            for (int i = 0; i < 96; ++i) {
                double theta = HelperMethods.RANDOM.m_188500_() * 2.0 * Math.PI;
                double phi = HelperMethods.RANDOM.m_188500_() * Math.PI;
                double r = HelperMethods.RANDOM.m_188500_() * 0.8;
                double x = r * Math.sin(phi) * Math.cos(theta);
                double y = r * Math.sin(phi) * Math.sin(theta);
                double z = r * Math.cos(phi);
                Vec3 start = this.m_20182_().m_82520_(0.0, (double)(this.m_20206_() / 2.0f), 0.0);
                Vec3 end = start.m_82549_(look.m_82490_(20.0)).m_82520_(x, y, z);
                Vec3 speed = start.m_82546_(end).m_82490_(0.08333333333333333).m_82548_();
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123744_, start.f_82479_, start.f_82480_, start.f_82481_, speed.f_82479_, speed.f_82480_, speed.f_82481_);
            }
            Entity theta = this.m_19749_();
            if (theta instanceof LivingEntity) {
                LivingEntity owner = (LivingEntity)theta;
                AABB bounds = this.m_20191_().m_82369_(look.m_82490_(20.0)).m_82400_(3.0);
                for (Entity entity : this.m_9236_().m_45933_((Entity)owner, bounds)) {
                    LivingEntity living;
                    if (!(entity instanceof LivingEntity) || !(living = (LivingEntity)entity).m_142582_((Entity)this) || !entity.m_6469_((DamageSource)JJKDamageSources.indirectJujutsuAttack((Entity)this, owner, (Ability)JJKAbilities.VOLCANO.get()), 8.0f * this.getPower())) continue;
                    entity.m_20254_(5);
                }
            }
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

