/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.entity.projectile;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import radon.jujutsu_kaisen.ExplosionHandler;
import radon.jujutsu_kaisen.ability.JJKAbilities;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.capability.data.sorcerer.ISorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.damage.JJKDamageSources;
import radon.jujutsu_kaisen.entity.JJKEntities;
import radon.jujutsu_kaisen.entity.projectile.base.JujutsuProjectile;
import radon.jujutsu_kaisen.util.RotationUtil;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class EmberInsectProjectile
extends JujutsuProjectile
implements GeoEntity {
    private static final EntityDataAccessor<Float> DATA_OFFSET_X = SynchedEntityData.m_135353_(EmberInsectProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> DATA_OFFSET_Y = SynchedEntityData.m_135353_(EmberInsectProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final RawAnimation IDLE = RawAnimation.begin().thenLoop("misc.idle");
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final float DAMAGE = 17.5f;
    private static final float SPEED = 3.0f;
    private static final float EXPLOSIVE_POWER = 2.0f;
    private static final float MAX_EXPLOSION = 2.0f;
    private static final int DELAY = 5;

    public EmberInsectProjectile(EntityType<? extends Projectile> pType, Level pLevel) {
        super(pType, pLevel);
    }

    public EmberInsectProjectile(LivingEntity owner, float power, float xOffset, float yOffset) {
        super((EntityType<? extends Projectile>)((EntityType)JJKEntities.EMBER_INSECT.get()), owner.m_9236_(), (Entity)owner, power);
        this.f_19804_.m_135381_(DATA_OFFSET_X, (Object)Float.valueOf(xOffset));
        this.f_19804_.m_135381_(DATA_OFFSET_Y, (Object)Float.valueOf(yOffset));
        this.applyOffset();
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_OFFSET_X, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(DATA_OFFSET_Y, (Object)Float.valueOf(0.0f));
    }

    @Override
    protected void m_7380_(@NotNull CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128350_("x_offset", ((Float)this.f_19804_.m_135370_(DATA_OFFSET_X)).floatValue());
        pCompound.m_128350_("y_offset", ((Float)this.f_19804_.m_135370_(DATA_OFFSET_Y)).floatValue());
    }

    @Override
    protected void m_7378_(@NotNull CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.f_19804_.m_135381_(DATA_OFFSET_X, (Object)Float.valueOf(pCompound.m_128457_("x_offset")));
        this.f_19804_.m_135381_(DATA_OFFSET_Y, (Object)Float.valueOf(pCompound.m_128457_("y_offset")));
    }

    protected void m_5790_(@NotNull EntityHitResult pResult) {
        super.m_5790_(pResult);
        Entity entity = pResult.m_82443_();
        Entity entity2 = this.m_19749_();
        if (!(entity2 instanceof LivingEntity)) {
            return;
        }
        LivingEntity owner = (LivingEntity)entity2;
        ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        if (entity == owner && !cap.hasSelfHit()) {
            return;
        }
        entity.m_6469_((DamageSource)JJKDamageSources.indirectJujutsuAttack((Entity)this, owner, (Ability)JJKAbilities.EMBER_INSECTS.get()), 17.5f * this.getPower());
    }

    protected void m_6532_(@NotNull HitResult result) {
        Entity yaw;
        super.m_6532_(result);
        if (this.m_9236_().f_46443_) {
            return;
        }
        Vec3 dir = this.m_20184_().m_82541_();
        for (int i = 0; i < 50; ++i) {
            yaw = dir.m_82524_(this.f_19796_.m_188501_() * 360.0f);
            Vec3 pitch = yaw.m_82496_(this.f_19796_.m_188501_() * 180.0f - 90.0f);
            double dx = pitch.f_82479_ + (this.f_19796_.m_188500_() - 0.5) * 0.2;
            double dy = pitch.f_82480_ + (this.f_19796_.m_188500_() - 0.5) * 0.2;
            double dz = pitch.f_82481_ + (this.f_19796_.m_188500_() - 0.5) * 0.2;
            ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123744_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0, dx, dy, dz, 1.0);
        }
        yaw = this.m_19749_();
        if (yaw instanceof LivingEntity) {
            LivingEntity owner = (LivingEntity)yaw;
            Vec3 location = result.m_82450_();
            ExplosionHandler.spawn((ResourceKey<Level>)this.m_9236_().m_46472_(), location, Math.min(2.0f, 2.0f * this.getPower()), 20, this.getPower() * 0.75f, owner, JJKDamageSources.indirectJujutsuAttack((Entity)this, owner, (Ability)JJKAbilities.EMBER_INSECTS.get()), true);
        }
        this.m_146870_();
    }

    private void applyOffset() {
        Entity entity = this.m_19749_();
        if (entity instanceof LivingEntity) {
            LivingEntity owner = (LivingEntity)entity;
            float xOffset = ((Float)this.f_19804_.m_135370_(DATA_OFFSET_X)).floatValue();
            float yOffset = ((Float)this.f_19804_.m_135370_(DATA_OFFSET_Y)).floatValue();
            Vec3 look = RotationUtil.getTargetAdjustedLookAngle((Entity)owner);
            Vec3 spawn = new Vec3(owner.m_20185_(), owner.m_20188_() - (double)(this.m_20206_() / 2.0f), owner.m_20189_()).m_82549_(RotationUtil.calculateViewVector(0.0f, owner.m_146908_() + 90.0f).m_82490_((double)xOffset)).m_82549_(RotationUtil.calculateViewVector(owner.m_146909_() - 90.0f, owner.m_146908_()).m_82490_((double)yOffset)).m_82549_(look);
            this.m_6034_(spawn.f_82479_, spawn.f_82480_, spawn.f_82481_);
            double d0 = look.m_165924_();
            this.m_146922_((float)(Mth.m_14136_((double)look.f_82479_, (double)look.f_82481_) * 57.2957763671875));
            this.m_146926_((float)(Mth.m_14136_((double)look.f_82480_, (double)d0) * 57.2957763671875));
            this.f_19859_ = this.m_146908_();
            this.f_19860_ = this.m_146909_();
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        Entity entity = this.m_19749_();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity owner = (LivingEntity)entity;
        if (this.getTime() < 5) {
            if (!owner.m_6084_()) {
                this.m_146870_();
            } else {
                if (this.getTime() % 5 == 0) {
                    owner.m_6674_(InteractionHand.MAIN_HAND);
                }
                this.applyOffset();
            }
        } else if (this.getTime() >= 5 && this.getTime() == 5) {
            this.m_20256_(RotationUtil.getTargetAdjustedLookAngle((Entity)owner).m_82490_(3.0));
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "Idle", animationState -> animationState.setAndContinue(IDLE))});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

