/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.entity.projectile;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.FluidType;
import org.jetbrains.annotations.NotNull;
import radon.jujutsu_kaisen.capability.data.sorcerer.ISorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.entity.JJKEntities;
import radon.jujutsu_kaisen.util.EntityUtil;
import radon.jujutsu_kaisen.util.RotationUtil;
import radon.jujutsu_kaisen.util.SorcererUtil;

public class TransfiguredSoulProjectile
extends Projectile {
    private static final EntityDataAccessor<Integer> DATA_TIME = SynchedEntityData.m_135353_(TransfiguredSoulProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final double SPEED = 10.0;
    private static final float DAMAGE = 17.0f;
    private static final int DURATION = 100;

    public TransfiguredSoulProjectile(EntityType<? extends Projectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public TransfiguredSoulProjectile(LivingEntity pShooter) {
        super((EntityType)JJKEntities.TRANSFIGURED_SOUL.get(), pShooter.m_9236_());
        this.m_5602_((Entity)pShooter);
        Vec3 look = RotationUtil.getTargetAdjustedLookAngle((Entity)pShooter);
        EntityUtil.offset((Entity)this, look, new Vec3(pShooter.m_20185_(), pShooter.m_20188_() - (double)(this.m_20206_() / 2.0f), pShooter.m_20189_()).m_82549_(look));
        this.m_20256_(look.m_82490_(10.0));
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DATA_TIME, (Object)0);
    }

    public int getTime() {
        return (Integer)this.f_19804_.m_135370_(DATA_TIME);
    }

    public void setTime(int time) {
        this.f_19804_.m_135381_(DATA_TIME, (Object)time);
    }

    public void m_7380_(@NotNull CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128405_("time", this.getTime());
    }

    public void m_7378_(@NotNull CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.setTime(pCompound.m_128451_("time"));
    }

    public boolean m_6128_() {
        return true;
    }

    public boolean isPushedByFluid(FluidType type) {
        return false;
    }

    public void m_8119_() {
        this.setTime(this.getTime() + 1);
        Entity owner = this.m_19749_();
        if (!(this.m_9236_().f_46443_ || owner != null && !owner.m_213877_() && owner.m_6084_())) {
            this.m_146870_();
        } else {
            super.m_8119_();
            if (this.getTime() >= 100) {
                this.m_146870_();
                return;
            }
            HitResult hit = ProjectileUtil.m_278158_((Entity)this, x$0 -> this.m_5603_((Entity)x$0));
            if (hit.m_6662_() != HitResult.Type.MISS && !ForgeEventFactory.onProjectileImpact((Projectile)this, (HitResult)hit)) {
                this.m_6532_(hit);
            }
            this.m_20101_();
            Vec3 movement = this.m_20184_();
            double d0 = this.m_20185_() + movement.f_82479_;
            double d1 = this.m_20186_() + movement.f_82480_;
            double d2 = this.m_20189_() + movement.f_82481_;
            this.m_6034_(d0, d1, d2);
        }
    }

    public boolean m_5825_() {
        return true;
    }

    public boolean m_6783_(double pDistance) {
        double d0 = this.m_20191_().m_82309_() * 10.0;
        if (Double.isNaN(d0)) {
            d0 = 1.0;
        }
        return pDistance < (d0 *= 64.0 * TransfiguredSoulProjectile.m_20150_()) * d0;
    }

    @NotNull
    public Packet<ClientGamePacketListener> m_5654_() {
        Entity entity = this.m_19749_();
        int i = entity == null ? 0 : entity.m_19879_();
        return new ClientboundAddEntityPacket(this.m_19879_(), this.m_20148_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_146909_(), this.m_146908_(), this.m_6095_(), i, this.m_20184_(), 0.0);
    }

    public void m_141965_(@NotNull ClientboundAddEntityPacket pPacket) {
        super.m_141965_(pPacket);
        this.m_7678_(pPacket.m_131500_(), pPacket.m_131501_(), pPacket.m_131502_(), pPacket.m_237567_(), pPacket.m_237566_());
        this.m_20334_(pPacket.m_131503_(), pPacket.m_131504_(), pPacket.m_131505_());
    }

    protected void m_5790_(@NotNull EntityHitResult pResult) {
        super.m_5790_(pResult);
        Entity entity = pResult.m_82443_();
        Entity entity2 = this.m_19749_();
        if (!(entity2 instanceof LivingEntity)) {
            return;
        }
        LivingEntity owner = (LivingEntity)entity2;
        if (entity == owner) {
            return;
        }
        ISorcererData ownerCap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        entity.m_6469_(this.m_269291_().m_269390_((Entity)this, (Entity)owner), 17.0f * SorcererUtil.getPower(ownerCap.getExperience()));
    }
}

