/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.entity.ten_shadows;

import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.entity.PartEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import radon.jujutsu_kaisen.ability.JJKAbilities;
import radon.jujutsu_kaisen.ability.base.Summon;
import radon.jujutsu_kaisen.entity.JJKEntities;
import radon.jujutsu_kaisen.entity.sorcerer.base.SorcererEntity;
import radon.jujutsu_kaisen.entity.ten_shadows.GreatSerpentSegmentEntity;
import radon.jujutsu_kaisen.entity.ten_shadows.base.TenShadowsSummon;
import radon.jujutsu_kaisen.util.RotationUtil;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class GreatSerpentEntity
extends TenShadowsSummon {
    private static final EntityDataAccessor<Boolean> DATA_GRABBING = SynchedEntityData.m_135353_(GreatSerpentEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final RawAnimation BITE = RawAnimation.begin().thenPlay("attack.bite");
    private static final RawAnimation GRAB = RawAnimation.begin().thenPlayAndHold("misc.grab");
    private static final int MAX_SEGMENTS = 24;
    private final GreatSerpentSegmentEntity[] segments = new GreatSerpentSegmentEntity[24];
    @Nullable
    private LivingEntity target;

    public GreatSerpentEntity(EntityType<? extends TamableAnimal> pType, Level pLevel) {
        super(pType, pLevel);
        for (int i = 0; i < this.segments.length; ++i) {
            this.segments[i] = new GreatSerpentSegmentEntity(this);
            this.segments[i].m_7678_(this.m_20185_() + 0.1 * (double)i, this.m_20186_() + 0.5, this.m_20189_() + 0.1 * (double)i, this.f_19796_.m_188501_() * 360.0f, 0.0f);
        }
        this.m_20234_(f_19843_.getAndAdd(this.segments.length + 1) + 1);
    }

    public GreatSerpentEntity(LivingEntity owner, boolean tame) {
        this((EntityType<? extends TamableAnimal>)((EntityType)JJKEntities.GREAT_SERPENT.get()), owner.m_9236_());
        this.m_7105_(tame);
        this.setOwner(owner);
        Vec3 direction = RotationUtil.calculateViewVector(0.0f, owner.m_146908_());
        Vec3 pos = owner.m_20182_().m_82546_(direction.m_82542_((double)this.m_20205_(), 0.0, (double)this.m_20205_()));
        this.m_7678_(pos.f_82479_, pos.f_82480_, pos.f_82481_, owner.m_146908_(), owner.m_146909_());
        this.f_20886_ = this.f_20885_ = this.m_146908_();
        this.m_21441_(BlockPathTypes.LEAVES, 0.0f);
        this.f_21342_ = new MoveControl((Mob)this);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_GRABBING, (Object)false);
    }

    private boolean isGrabbing() {
        return (Boolean)this.f_19804_.m_135370_(DATA_GRABBING);
    }

    private void setGrabbing(boolean grabbing) {
        this.f_19804_.m_135381_(DATA_GRABBING, (Object)grabbing);
    }

    public void grab(LivingEntity target) {
        this.target = target;
        this.setGrabbing(false);
    }

    public void m_20234_(int id) {
        super.m_20234_(id);
        for (int i = 0; i < this.segments.length; ++i) {
            this.segments[i].m_20234_(id + i + 1);
        }
    }

    @Override
    protected boolean isCustom() {
        return false;
    }

    @Override
    protected boolean canFly() {
        return false;
    }

    @Override
    public boolean canChant() {
        return false;
    }

    @Override
    public boolean hasMeleeAttack() {
        return true;
    }

    @Override
    public boolean hasArms() {
        return false;
    }

    @Override
    public boolean canJump() {
        return true;
    }

    private PlayState bitePredicate(AnimationState<GreatSerpentEntity> animationState) {
        if (this.f_20911_) {
            return animationState.setAndContinue(BITE);
        }
        animationState.getController().forceAnimationReset();
        return PlayState.STOP;
    }

    private PlayState grabPredicate(AnimationState<GreatSerpentEntity> animationState) {
        if (this.isGrabbing()) {
            return animationState.setAndContinue(GRAB);
        }
        return PlayState.STOP;
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "Bite", this::bitePredicate)});
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "Grab", this::grabPredicate)});
    }

    public float getStepHeight() {
        return 2.0f;
    }

    @Nullable
    public PartEntity<?>[] getParts() {
        return this.segments;
    }

    @Override
    public void m_142687_(@NotNull Entity.RemovalReason reason) {
        super.m_142687_(reason);
        if (!this.m_9236_().f_46443_) {
            for (GreatSerpentSegmentEntity seg : this.segments) {
                seg.m_6074_();
            }
        }
    }

    @NotNull
    protected PathNavigation m_6037_(@NotNull Level pLevel) {
        LivingEntity target = this.m_5448_();
        GroundPathNavigation navigation = new GroundPathNavigation((Mob)this, pLevel);
        navigation.m_26477_(false);
        navigation.m_7008_(false);
        navigation.m_148214_(true);
        return navigation;
    }

    @Override
    protected void m_8024_() {
        super.m_8024_();
        LivingEntity target = this.m_5448_();
        if (target != null) {
            this.f_21342_.m_6849_(target.m_20185_(), target.m_20186_(), target.m_20189_(), 0.5);
        }
    }

    private void moveSegments() {
        for (int i = 0; i < this.segments.length; ++i) {
            this.segments[i].m_8119_();
            GreatSerpentEntity leader = i == 0 ? this : this.segments[i - 1];
            Vec3 follow = leader.m_20182_();
            float angle = (leader.m_146908_() + 180.0f) * (float)Math.PI / 180.0f;
            double f = leader.m_20205_() / 2.0f + this.segments[i].m_20205_() / 2.0f;
            double force = 0.05 + 1.0 / (double)(i + 1) * 0.5;
            double idealX = (double)(-Mth.m_14031_((float)angle)) * force;
            double idealZ = (double)Mth.m_14089_((float)angle) * force;
            double groundY = this.segments[i].m_5830_() ? follow.f_82480_ + f : follow.f_82480_;
            double idealY = (groundY - follow.f_82480_) * force;
            Vec3 diff = new Vec3(this.segments[i].m_20185_() - follow.f_82479_, this.segments[i].m_20186_() - follow.f_82480_, this.segments[i].m_20189_() - follow.f_82481_).m_82541_().m_82520_(idealX, idealY, idealZ).m_82541_();
            double destX = follow.f_82479_ + f * diff.f_82479_;
            double destY = follow.f_82480_ + f * diff.f_82480_;
            double destZ = follow.f_82481_ + f * diff.f_82481_;
            this.segments[i].m_6034_(destX, destY, destZ);
            double distance = Mth.m_14116_((float)((float)(diff.f_82479_ * diff.f_82479_ + diff.f_82481_ * diff.f_82481_)));
            this.segments[i].m_19915_((float)(Math.atan2(diff.f_82481_, diff.f_82479_) * 180.0 / Math.PI) + 90.0f, -((float)(Math.atan2(diff.f_82480_, distance) * 180.0 / Math.PI)));
        }
    }

    public boolean m_6094_() {
        return !this.isGrabbing() && super.m_6094_();
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.f_20885_ = this.m_146908_();
        this.moveSegments();
        if (this.m_9236_().f_46443_) {
            return;
        }
        LivingEntity owner = this.m_269323_();
        if (owner == null) {
            return;
        }
        if (this.target == null || this.target.m_21224_() || this.target.m_213877_()) {
            this.setGrabbing(false);
            return;
        }
        if (!this.isGrabbing()) {
            this.m_7618_(EntityAnchorArgument.Anchor.EYES, this.target.m_20182_().m_82520_(0.0, (double)(this.target.m_20206_() / 2.0f), 0.0));
            this.m_20256_(this.target.m_20182_().m_82546_(this.m_20182_()).m_82541_().m_82490_(2.0));
            if ((double)this.m_20270_((Entity)this.target) < 1.0) {
                this.setGrabbing(true);
            }
        } else {
            this.m_146922_(this.target.f_20883_);
            Vec3 pos = this.m_20182_().m_82520_(0.0, (double)(this.m_20206_() / 2.0f), 0.0).m_82492_(0.0, (double)(this.target.m_20206_() / 2.0f), 0.0);
            this.target.m_6021_(pos.f_82479_, pos.f_82480_, pos.f_82481_);
        }
    }

    public boolean isMultipartEntity() {
        return this.segments != null;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return SorcererEntity.createAttributes().m_22268_(Attributes.f_22276_, 39.0).m_22268_(Attributes.f_22279_, 0.396).m_22268_(Attributes.f_22284_, 10.0).m_22268_(Attributes.f_22281_, 24.0);
    }

    @Override
    public Summon<?> getAbility() {
        return (Summon)JJKAbilities.GREAT_SERPENT.get();
    }
}

