/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.entity.ten_shadows;

import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import radon.jujutsu_kaisen.ability.JJKAbilities;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.capability.data.sorcerer.ISorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.capability.data.ten_shadows.ITenShadowsData;
import radon.jujutsu_kaisen.capability.data.ten_shadows.TenShadowsDataHandler;
import radon.jujutsu_kaisen.entity.JJKEntities;
import radon.jujutsu_kaisen.sound.JJKSounds;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class WheelEntity
extends Entity
implements GeoEntity {
    private static final EntityDataAccessor<Integer> DATA_SPIN = SynchedEntityData.m_135353_(WheelEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final RawAnimation SPIN = RawAnimation.begin().thenPlay("misc.spin");
    private static final int SPIN_DURATION = 20;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    @Nullable
    private UUID ownerUUID;
    @Nullable
    private LivingEntity cachedOwner;

    public WheelEntity(EntityType<?> pType, Level pLevel) {
        super(pType, pLevel);
    }

    public WheelEntity(LivingEntity owner) {
        this((EntityType)JJKEntities.WHEEL.get(), owner.m_9236_());
        this.setOwner(owner);
        this.m_146884_(owner.m_20182_());
        this.m_20329_((Entity)owner);
    }

    public double m_6049_() {
        return 0.5;
    }

    public void spin() {
        this.f_19804_.m_135381_(DATA_SPIN, (Object)20);
        this.m_5496_((SoundEvent)JJKSounds.WHEEL.get(), 6.0f, 1.0f);
        if (this.m_9236_().f_46443_) {
            this.triggerAnim("Spin", "misc.spin");
        }
    }

    public void setOwner(@Nullable LivingEntity pOwner) {
        if (pOwner != null) {
            this.ownerUUID = pOwner.m_20148_();
            this.cachedOwner = pOwner;
        }
    }

    @Nullable
    public LivingEntity getOwner() {
        if (this.cachedOwner != null && !this.cachedOwner.m_213877_()) {
            return this.cachedOwner;
        }
        if (this.ownerUUID != null && this.m_9236_() instanceof ServerLevel) {
            this.cachedOwner = (LivingEntity)((ServerLevel)this.m_9236_()).m_8791_(this.ownerUUID);
            return this.cachedOwner;
        }
        return null;
    }

    public void m_8119_() {
        LivingEntity owner = this.getOwner();
        if (!this.m_9236_().f_46443_ && owner != null) {
            ITenShadowsData cap = (ITenShadowsData)owner.getCapability(TenShadowsDataHandler.INSTANCE).resolve().orElseThrow();
            if (!JJKAbilities.hasToggled(owner, (Ability)JJKAbilities.WHEEL.get())) {
                this.m_146870_();
                return;
            }
        }
        if (!(this.m_9236_().f_46443_ || owner != null && !owner.m_213877_() && owner.m_6084_() && this.m_20159_())) {
            this.m_146870_();
        } else {
            int spin;
            super.m_8119_();
            if (!this.m_9236_().f_46443_ && (spin = ((Integer)this.f_19804_.m_135370_(DATA_SPIN)).intValue()) > 0) {
                this.f_19804_.m_135381_(DATA_SPIN, (Object)(--spin));
            }
        }
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DATA_SPIN, (Object)0);
    }

    protected void m_7378_(@NotNull CompoundTag pCompound) {
        if (pCompound.m_128403_("owner")) {
            this.ownerUUID = pCompound.m_128342_("owner");
        }
        this.f_19804_.m_135381_(DATA_SPIN, (Object)pCompound.m_128451_("spin"));
    }

    protected void m_7380_(@NotNull CompoundTag pCompound) {
        if (this.ownerUUID != null) {
            pCompound.m_128362_("owner", this.ownerUUID);
        }
        pCompound.m_128405_("spin", ((Integer)this.f_19804_.m_135370_(DATA_SPIN)).intValue());
    }

    public void m_142687_(@NotNull Entity.RemovalReason pReason) {
        super.m_142687_(pReason);
        LivingEntity owner = this.getOwner();
        if (owner == null) {
            return;
        }
        if (owner != null && JJKAbilities.hasToggled(owner, (Ability)JJKAbilities.WHEEL.get())) {
            ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
            cap.toggle((Ability)JJKAbilities.WHEEL.get());
        }
    }

    private PlayState spinPredicate(AnimationState<WheelEntity> animationState) {
        int spin = (Integer)this.f_19804_.m_135370_(DATA_SPIN);
        if (spin > 0) {
            return animationState.setAndContinue(SPIN);
        }
        animationState.getController().forceAnimationReset();
        return PlayState.STOP;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "Spin", this::spinPredicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @NotNull
    public Packet<ClientGamePacketListener> m_5654_() {
        LivingEntity entity = this.getOwner();
        return new ClientboundAddEntityPacket((Entity)this, entity == null ? 0 : entity.m_19879_());
    }

    public void m_141965_(@NotNull ClientboundAddEntityPacket pPacket) {
        super.m_141965_(pPacket);
        LivingEntity owner = (LivingEntity)this.m_9236_().m_6815_(pPacket.m_131509_());
        if (owner != null) {
            this.setOwner(owner);
        }
    }
}

