/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.event;

import java.util.Optional;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import radon.jujutsu_kaisen.ability.JJKAbilities;
import radon.jujutsu_kaisen.capability.data.sorcerer.Trait;
import radon.jujutsu_kaisen.util.HelperMethods;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotResult;
import top.theillusivec4.curios.api.event.CurioEquipEvent;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;

@Mod.EventBusSubscriber(modid="jujutsu_kaisen", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class CuriosEventHandler {
    @SubscribeEvent
    public static void onCuriosEquip(CurioEquipEvent event) {
        if (!JJKAbilities.hasTrait(event.getEntity(), Trait.PERFECT_BODY)) {
            return;
        }
        if (event.getSlotContext().identifier().equals("right_hand") || event.getSlotContext().identifier().equals("left_hand")) {
            event.setResult(Event.Result.ALLOW);
        }
    }

    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent event) {
        Player player;
        LivingEntity victim = event.getEntity();
        if (victim.m_9236_().f_46443_) {
            return;
        }
        DamageSource source = event.getSource();
        Entity entity = source.m_7639_();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity attacker = (LivingEntity)entity;
        if (!JJKAbilities.hasTrait(attacker, Trait.PERFECT_BODY)) {
            return;
        }
        if (!HelperMethods.isMelee(source)) {
            return;
        }
        LazyOptional optional = CuriosApi.getCuriosInventory((LivingEntity)attacker);
        if (!optional.isPresent()) {
            return;
        }
        ICuriosItemHandler inventory = (ICuriosItemHandler)optional.resolve().orElseThrow();
        Optional rightHand = inventory.findCurio("right_hand", 0);
        Optional leftHand = inventory.findCurio("left_hand", 0);
        ItemStack stack = attacker.m_5737_() == HumanoidArm.RIGHT ? (rightHand.isPresent() ? ((SlotResult)rightHand.get()).stack() : ItemStack.f_41583_) : (leftHand.isPresent() ? ((SlotResult)leftHand.get()).stack() : ItemStack.f_41583_);
        event.setAmount(event.getAmount() + EnchantmentHelper.m_44833_((ItemStack)stack, (MobType)victim.m_6336_()));
        if (attacker instanceof Player) {
            player = (Player)attacker;
            if (!attacker.m_9236_().f_46443_ && !stack.m_41619_()) {
                ItemStack copy = stack.m_41777_();
                stack.m_41640_(victim, player);
                if (stack.m_41619_()) {
                    ForgeEventFactory.onPlayerDestroyItem((Player)player, (ItemStack)copy, (InteractionHand)InteractionHand.MAIN_HAND);
                    player.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
                }
            }
        }
        if (victim instanceof Player) {
            ItemStack using;
            player = (Player)victim;
            ItemStack itemStack = using = player.m_6117_() ? player.m_21211_() : ItemStack.f_41583_;
            if (!stack.m_41619_() && !using.m_41619_() && stack.m_41720_() instanceof AxeItem && using.m_150930_(Items.f_42740_)) {
                float f = 0.25f + (float)EnchantmentHelper.m_44926_((LivingEntity)attacker) * 0.05f;
                if (HelperMethods.RANDOM.m_188501_() < f) {
                    player.m_36335_().m_41524_(Items.f_42740_, 100);
                    attacker.m_9236_().m_7605_((Entity)player, (byte)30);
                }
            }
        }
    }
}

