/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.item.armor;

import java.util.function.Consumer;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.NotNull;
import radon.jujutsu_kaisen.client.render.item.armor.WingsRenderer;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class WingsItem
extends ArmorItem
implements GeoItem {
    private static final RawAnimation FLY_VERTICAL = RawAnimation.begin().thenLoop("move.fly_vertical");
    private static final RawAnimation FLY_HORIZONTAL = RawAnimation.begin().thenLoop("move.fly_horizontal");
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public WingsItem(ArmorMaterial pMaterial, ArmorItem.Type pType, Item.Properties pProperties) {
        super(pMaterial, pType, pProperties);
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private WingsRenderer renderer;

            @NotNull
            public HumanoidModel<?> getHumanoidArmorModel(LivingEntity livingEntity, ItemStack itemStack, EquipmentSlot equipmentSlot, HumanoidModel<?> original) {
                if (this.renderer == null) {
                    this.renderer = new WingsRenderer();
                }
                this.renderer.prepForRender((Entity)livingEntity, itemStack, equipmentSlot, original);
                return this.renderer;
            }
        });
    }

    private static double getDistanceGround(LivingEntity entity) {
        Vec3 pos = entity.m_20182_();
        Vec3 down = pos.m_82520_(0.0, -256.0, 0.0);
        BlockHitResult result = entity.m_9236_().m_45547_(new ClipContext(pos, down, ClipContext.Block.COLLIDER, ClipContext.Fluid.ANY, (Entity)entity));
        if (result.m_6662_() == HitResult.Type.BLOCK) {
            return pos.f_82480_ - result.m_82450_().f_82480_;
        }
        return Double.MAX_VALUE;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canElytraFly(ItemStack stack, LivingEntity entity) {
        double dist = WingsItem.getDistanceGround(entity);
        if (!(dist > 4.0)) return false;
        if (entity.m_20096_()) return false;
        Vec3 vec3 = new Vec3((double)entity.f_20900_, 0.0, (double)entity.f_20902_);
        if (!(vec3.m_82553_() > 1.0E-7)) return false;
        return true;
    }

    public boolean elytraFlightTick(ItemStack stack, LivingEntity entity, int flightTicks) {
        return true;
    }

    private PlayState flyPredicate(AnimationState<WingsItem> animationState) {
        LivingEntity entity;
        double dist;
        Object object = animationState.getData(DataTickets.ENTITY);
        if (object instanceof LivingEntity && (dist = WingsItem.getDistanceGround(entity = (LivingEntity)object)) > 4.0 && !entity.m_20096_()) {
            return animationState.setAndContinue(new Vec3((double)entity.f_20900_, 0.0, (double)entity.f_20902_).m_82556_() > 1.0E-7 ? FLY_HORIZONTAL : FLY_VERTICAL);
        }
        return PlayState.STOP;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, 20, this::flyPredicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

