/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.item.cursed_tool;

import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import radon.jujutsu_kaisen.capability.data.sorcerer.ISorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererGrade;
import radon.jujutsu_kaisen.client.render.item.KamutokeDaggerRenderer;
import radon.jujutsu_kaisen.entity.JujutsuLightningEntity;
import radon.jujutsu_kaisen.item.base.CursedToolItem;
import radon.jujutsu_kaisen.network.PacketHandler;
import radon.jujutsu_kaisen.network.packet.s2c.SetOverlayMessageS2CPacket;
import radon.jujutsu_kaisen.util.HelperMethods;
import radon.jujutsu_kaisen.util.RotationUtil;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class KamutokeDaggerItem
extends CursedToolItem
implements GeoItem {
    public static final double RANGE = 60.0;
    private static final int COUNT = 20;
    public static final float MELEE_COST = 20.0f;
    private static final float RANGE_COST = 500.0f;
    public static final float MELEE_DAMAGE = 5.5f;
    private static final float RANGE_DAMAGE = 25.0f;
    public static final int STUN = 5;
    private static final int DURATION = 60;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public KamutokeDaggerItem(Tier pTier, int pAttackDamageModifier, float pAttackSpeedModifier, Item.Properties pProperties) {
        super(pTier, pAttackDamageModifier, pAttackSpeedModifier, pProperties);
    }

    @Override
    public SorcererGrade getGrade() {
        return SorcererGrade.SPECIAL_GRADE;
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private KamutokeDaggerRenderer renderer;

            public KamutokeDaggerRenderer getCustomRenderer() {
                if (this.renderer == null) {
                    this.renderer = new KamutokeDaggerRenderer();
                }
                return this.renderer;
            }
        });
    }

    @NotNull
    public UseAnim m_6164_(@NotNull ItemStack pStack) {
        return UseAnim.SPEAR;
    }

    public int m_8105_(@NotNull ItemStack pStack) {
        return 72000;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level pLevel, Player pPlayer, @NotNull InteractionHand pHand) {
        ItemStack itemstack = pPlayer.m_21120_(pHand);
        pPlayer.m_6672_(pHand);
        return InteractionResultHolder.m_19096_((Object)itemstack);
    }

    private float getPowerForTime(int pUseTime) {
        float f = (float)pUseTime / 60.0f;
        if (f > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    @Nullable
    private BlockHitResult getBlockHit(LivingEntity owner) {
        Vec3 look;
        Vec3 end;
        Vec3 start = owner.m_146892_();
        HitResult result = RotationUtil.getHitResult((Entity)owner, start, end = start.m_82549_((look = RotationUtil.getTargetAdjustedLookAngle((Entity)owner)).m_82490_(60.0)));
        if (result.m_6662_() == HitResult.Type.BLOCK) {
            return (BlockHitResult)result;
        }
        if (result.m_6662_() == HitResult.Type.ENTITY) {
            Entity entity = ((EntityHitResult)result).m_82443_();
            Vec3 offset = entity.m_20182_().m_82492_(0.0, 5.0, 0.0);
            return owner.m_9236_().m_45547_(new ClipContext(entity.m_20182_(), offset, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, null));
        }
        return null;
    }

    public void m_5929_(@NotNull Level pLevel, @NotNull LivingEntity pLivingEntity, @NotNull ItemStack pStack, int pRemainingUseDuration) {
        super.m_5929_(pLevel, pLivingEntity, pStack, pRemainingUseDuration);
        int i = this.m_8105_(pStack) - pRemainingUseDuration;
        float f = this.getPowerForTime(i);
        if (pLivingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)pLivingEntity;
            PacketHandler.sendToClient(new SetOverlayMessageS2CPacket((Component)Component.m_237110_((String)String.format("chat.%s.cost", "jujutsu_kaisen"), (Object[])new Object[]{Float.valueOf(500.0f * f), Float.valueOf(500.0f)}), false), player);
        }
    }

    public void onStopUsing(ItemStack stack, LivingEntity entity, int count) {
        block6: {
            float f;
            BlockHitResult hit;
            block8: {
                ISorcererData cap;
                float cost;
                block7: {
                    super.onStopUsing(stack, entity, count);
                    if (!entity.getCapability(SorcererDataHandler.INSTANCE).isPresent()) {
                        return;
                    }
                    hit = this.getBlockHit(entity);
                    if (hit == null) break block6;
                    int i = this.m_8105_(stack) - count;
                    f = this.getPowerForTime(i);
                    cost = 500.0f * f;
                    cap = (ISorcererData)entity.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
                    if (!(entity instanceof Player)) break block7;
                    Player player = (Player)entity;
                    if (player.m_150110_().f_35937_) break block8;
                }
                if (cap.getEnergy() < cost) {
                    return;
                }
                cap.useEnergy(cost);
            }
            Vec3 pos = hit.m_82425_().m_252807_();
            int j = 0;
            while ((float)j < 20.0f * f) {
                JujutsuLightningEntity lightning = new JujutsuLightningEntity(entity, 25.0f * f);
                lightning.m_146884_(pos.m_82520_((HelperMethods.RANDOM.m_188500_() - 0.5) * 5.0, 0.0, (HelperMethods.RANDOM.m_188500_() - 0.5) * 5.0));
                entity.m_9236_().m_7967_((Entity)lightning);
                ++j;
            }
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

