/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.ability.curse_manipulation;

import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.Nullable;
import radon.jujutsu_kaisen.ability.JJKAbilities;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.capability.data.sorcerer.AbsorbedCurse;
import radon.jujutsu_kaisen.capability.data.sorcerer.ISorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.JujutsuType;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.capability.data.sorcerer.Trait;
import radon.jujutsu_kaisen.item.CursedSpiritOrbItem;
import radon.jujutsu_kaisen.item.JJKItems;
import radon.jujutsu_kaisen.util.EntityUtil;
import radon.jujutsu_kaisen.util.HelperMethods;

public class CurseAbsorption
extends Ability
implements Ability.IToggled {
    @Override
    public boolean isScalable(LivingEntity owner) {
        return false;
    }

    @Override
    public boolean shouldTrigger(PathfinderMob owner, @Nullable LivingEntity target) {
        if (target == null) {
            return false;
        }
        if (!target.getCapability(SorcererDataHandler.INSTANCE).isPresent()) {
            return false;
        }
        ISorcererData cap = (ISorcererData)target.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        return cap.getType() == JujutsuType.CURSE && !cap.hasTrait(Trait.DEATH_PAINTING);
    }

    @Override
    public Ability.ActivationType getActivationType(LivingEntity owner) {
        return Ability.ActivationType.TOGGLED;
    }

    private static boolean canAbsorb(LivingEntity owner, LivingEntity target) {
        TamableAnimal tamable;
        if (!owner.getCapability(SorcererDataHandler.INSTANCE).isPresent()) {
            return false;
        }
        if (!target.getCapability(SorcererDataHandler.INSTANCE).isPresent()) {
            return false;
        }
        ISorcererData ownerCap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        ISorcererData targetCap = (ISorcererData)target.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        return !(targetCap.getType() != JujutsuType.CURSE || targetCap.hasTrait(Trait.DEATH_PAINTING) || target instanceof TamableAnimal && (tamable = (TamableAnimal)target).m_21824_() || !(ownerCap.getExperience() / targetCap.getExperience() >= 2.0f) && !target.m_21224_());
    }

    @Override
    public void run(LivingEntity owner) {
    }

    @Override
    public float getCost(LivingEntity owner) {
        return 0.0f;
    }

    @Override
    public void onEnabled(LivingEntity owner) {
    }

    @Override
    public void onDisabled(LivingEntity owner) {
    }

    @Override
    public boolean usesHands() {
        return false;
    }

    private static void check(LivingEntity victim, DamageSource source) {
        Player player;
        if (!HelperMethods.isMelee(source)) {
            return;
        }
        Entity entity = source.m_7639_();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity attacker = (LivingEntity)entity;
        if (!CurseAbsorption.canAbsorb(attacker, victim)) {
            return;
        }
        if (!JJKAbilities.hasToggled(attacker, (Ability)JJKAbilities.CURSE_ABSORPTION.get())) {
            return;
        }
        ISorcererData victimCap = (ISorcererData)victim.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        attacker.m_21011_(InteractionHand.MAIN_HAND, true);
        ItemStack stack = new ItemStack((ItemLike)JJKItems.CURSED_SPIRIT_ORB.get());
        if (victim instanceof Player) {
            player = (Player)victim;
            CursedSpiritOrbItem.setAbsorbed(stack, new AbsorbedCurse(victim.m_7755_(), victim.m_6095_(), victimCap.serializeNBT(), player.m_36316_()));
        } else {
            CursedSpiritOrbItem.setAbsorbed(stack, new AbsorbedCurse(victim.m_7755_(), victim.m_6095_(), victimCap.serializeNBT()));
        }
        if (attacker instanceof Player) {
            player = (Player)attacker;
            player.m_36356_(stack);
        } else {
            attacker.m_8061_(EquipmentSlot.MAINHAND, stack);
        }
        EntityUtil.makePoofParticles((Entity)victim);
        if (!(victim instanceof Player)) {
            victim.m_146870_();
        } else {
            victim.m_6074_();
        }
    }

    @Mod.EventBusSubscriber(modid="jujutsu_kaisen", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class CurseAbsorptionForgeEvents {
        @SubscribeEvent
        public static void onLivingDamage(LivingDamageEvent event) {
            CurseAbsorption.check(event.getEntity(), event.getSource());
        }

        @SubscribeEvent
        public static void onLivingDeath(LivingDeathEvent event) {
            CurseAbsorption.check(event.getEntity(), event.getSource());
        }
    }
}

