/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.ability.cursed_speech;

import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import radon.jujutsu_kaisen.ability.MenuType;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.ability.cursed_speech.CursedSpeech;
import radon.jujutsu_kaisen.capability.data.sorcerer.ISorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.client.particle.CursedSpeechParticle;
import radon.jujutsu_kaisen.sound.JJKSounds;
import radon.jujutsu_kaisen.util.HelperMethods;
import radon.jujutsu_kaisen.util.RotationUtil;

public class RunAway
extends CursedSpeech {
    private static final double RANGE = 25.0;
    private static final double RADIUS = 2.5;
    private static final int DURATION = 35;

    @Override
    public boolean shouldTrigger(PathfinderMob owner, @Nullable LivingEntity target) {
        return false;
    }

    @Override
    public Ability.ActivationType getActivationType(LivingEntity owner) {
        return Ability.ActivationType.INSTANT;
    }

    private static List<Entity> getEntities(LivingEntity owner) {
        Vec3 look = RotationUtil.getTargetAdjustedLookAngle((Entity)owner);
        Vec3 src = owner.m_146892_();
        AABB bounds = AABB.m_165882_((Vec3)src, (double)1.0, (double)1.0, (double)1.0).m_82369_(look.m_82490_(25.0)).m_82400_(2.5);
        return owner.m_9236_().m_6249_((Entity)owner, bounds, entity -> {
            LivingEntity living;
            return !(entity instanceof LivingEntity) || owner.m_6779_(living = (LivingEntity)entity);
        });
    }

    @Override
    public boolean usesHands() {
        return false;
    }

    @Override
    public void run(LivingEntity owner) {
        if (owner.m_9236_().f_46443_) {
            return;
        }
        Vec3 look = RotationUtil.getTargetAdjustedLookAngle((Entity)owner);
        Vec3 src = owner.m_146892_();
        int i = 1;
        while ((double)i < 32.0) {
            Vec3 dst = src.m_82549_(look.m_82490_((double)i));
            ((ServerLevel)owner.m_9236_()).m_8767_((ParticleOptions)new CursedSpeechParticle.CursedSpeechParticleOptions(new Vector3f(0.376f, 1.0f, 0.376f), (float)(src.m_82554_(dst) * 0.5)), dst.f_82479_, dst.f_82480_, dst.f_82481_, 0, 0.0, 0.0, 0.0, 1.0);
            ++i;
        }
        owner.m_9236_().m_6263_(null, src.f_82479_, src.f_82480_, src.f_82481_, (SoundEvent)JJKSounds.CURSED_SPEECH.get(), SoundSource.MASTER, 2.0f, 0.8f + HelperMethods.RANDOM.m_188501_() * 0.2f);
        for (Entity entity : RunAway.getEntities(owner)) {
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity living = (LivingEntity)entity;
            living.m_7292_(new MobEffectInstance(MobEffects.f_19603_, Mth.m_14045_((int)Math.round(35.0f * this.getPower(owner)), (int)200, (int)400), 1, false, false, false));
            living.m_7292_(new MobEffectInstance(MobEffects.f_19596_, Mth.m_14045_((int)Math.round(35.0f * this.getPower(owner)), (int)200, (int)400), 5, false, false, false));
            living.m_7292_(new MobEffectInstance(MobEffects.f_19598_, Mth.m_14045_((int)Math.round(35.0f * this.getPower(owner)), (int)200, (int)400), 0, false, false, false));
            if (living.getCapability(SorcererDataHandler.INSTANCE).isPresent()) {
                ISorcererData cap = (ISorcererData)living.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
                cap.setDisarmed(Math.round(35.0f * this.getPower(owner)));
            }
            if (!(entity instanceof Player)) continue;
            Player player = (Player)entity;
            player.m_213846_((Component)Component.m_237110_((String)String.format("chat.%s.run_away", "jujutsu_kaisen"), (Object[])new Object[]{owner.m_7755_()}));
        }
    }

    @Override
    public int getThroatDamage() {
        return 40;
    }

    @Override
    public float getCost(LivingEntity owner) {
        return 100.0f;
    }

    @Override
    public int getCooldown() {
        return 480;
    }

    @Override
    public Ability.Classification getClassification() {
        return Ability.Classification.CURSED_SPEECH;
    }

    @Override
    public MenuType getMenuType() {
        return MenuType.J2TSU;
    }
}

