/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.ability.ratio;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import radon.jujutsu_kaisen.ability.JJKAbilities;
import radon.jujutsu_kaisen.ability.MenuType;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.capability.data.sorcerer.ISorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.client.particle.CursedEnergyParticle;
import radon.jujutsu_kaisen.client.particle.ParticleColors;
import radon.jujutsu_kaisen.damage.JJKDamageSources;
import radon.jujutsu_kaisen.effect.JJKEffects;
import radon.jujutsu_kaisen.sound.JJKSounds;
import radon.jujutsu_kaisen.util.HelperMethods;
import radon.jujutsu_kaisen.util.RotationUtil;

public class Bisection
extends Ability
implements Ability.IChannelened,
Ability.IDurationable {
    private static final double RANGE = 50.0;
    private static final int DELAY = 20;
    private static final float DAMAGE = 20.0f;
    private static final int DURATION = 26;
    private static final int STUN = 21;

    @Override
    public boolean shouldTrigger(PathfinderMob owner, @Nullable LivingEntity target) {
        if (target == null || !owner.m_142582_((Entity)target)) {
            return false;
        }
        if (JJKAbilities.isChanneling((LivingEntity)owner, this)) {
            return HelperMethods.RANDOM.m_188503_(5) != 0;
        }
        return HelperMethods.RANDOM.m_188503_(3) == 0;
    }

    @Override
    public Ability.ActivationType getActivationType(LivingEntity owner) {
        return Ability.ActivationType.CHANNELED;
    }

    @Override
    public void run(LivingEntity owner) {
        Level level = owner.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        Vec3 pos = owner.m_20182_();
        int index = this.getCharge(owner);
        owner.m_7292_(new MobEffectInstance((MobEffect)JJKEffects.STUN.get(), 2, 1, false, false, false));
        float scale = 1.5f;
        int i = 0;
        while ((float)i < 12.0f * scale) {
            double x = owner.m_20185_() + (HelperMethods.RANDOM.m_188500_() - 0.5) * (double)(owner.m_20205_() * 1.5f * scale) - owner.m_20154_().m_82490_((double)0.35).f_82479_;
            double y = owner.m_20186_() + HelperMethods.RANDOM.m_188500_() * (double)owner.m_20206_();
            double z = owner.m_20189_() + (HelperMethods.RANDOM.m_188500_() - 0.5) * (double)(owner.m_20205_() * 1.5f * scale) - owner.m_20154_().m_82490_((double)0.35).f_82481_;
            double speed = (double)(owner.m_20206_() * 0.8f) * HelperMethods.RANDOM.m_188500_();
            level2.m_8767_((ParticleOptions)new CursedEnergyParticle.CursedEnergyParticleOptions(ParticleColors.DARK_BLUE, owner.m_20205_() * 1.0f, 0.2f, 16), x, y, z, 0, 0.0, speed, 0.0, 1.0);
            ++i;
        }
        if (index == 15 && owner instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)owner;
            owner.m_9236_().m_6263_(null, owner.m_20185_(), owner.m_20186_(), owner.m_20189_(), (SoundEvent)JJKSounds.COLLAPSE.get(), SoundSource.MASTER, 1.0f, 1.0f);
        }
    }

    @Override
    public void onStop(LivingEntity owner) {
        Level level = owner.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        owner.m_6674_(InteractionHand.MAIN_HAND);
        int index = this.getCharge(owner);
        LivingEntity target = RotationUtil.getExpandedLookAt((Entity)owner, 50.0);
        if (target != null && index >= 20 && index < 26) {
            Vec3 targeter = target.m_20182_();
            owner.m_6021_(targeter.f_82479_, targeter.f_82480_, targeter.f_82481_);
            target.m_6469_((DamageSource)JJKDamageSources.jujutsuAttack(owner, (Ability)JJKAbilities.BISECTION.get()), 20.0f * (this.getPower(owner) * 0.75f));
            if (target.getCapability(SorcererDataHandler.INSTANCE).isPresent()) {
                ISorcererData capHit = (ISorcererData)target.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
                if (!capHit.isChanneling((Ability)JJKAbilities.CURSED_ENERGY_SHIELD.get())) {
                    target.m_7292_(new MobEffectInstance((MobEffect)JJKEffects.STUN.get(), 21, 1, false, false, false));
                    target.m_7292_(new MobEffectInstance((MobEffect)JJKEffects.STAGGER.get(), 21, 1, false, false, false));
                }
            } else {
                target.m_7292_(new MobEffectInstance((MobEffect)JJKEffects.STUN.get(), 21, 1, false, false, false));
                target.m_7292_(new MobEffectInstance((MobEffect)JJKEffects.STAGGER.get(), 21, 1, false, false, false));
            }
            float scale = 1.5f;
            double x = owner.m_20185_() + (HelperMethods.RANDOM.m_188500_() - 0.5) * (double)(owner.m_20205_() * 1.5f * scale) - owner.m_20154_().m_82490_((double)0.35).f_82479_;
            double y = owner.m_20186_() + HelperMethods.RANDOM.m_188500_() + 0.5 * (double)owner.m_20206_();
            double z = owner.m_20189_() + (HelperMethods.RANDOM.m_188500_() - 0.5) * (double)(owner.m_20205_() * 1.5f * scale) - owner.m_20154_().m_82490_((double)0.35).f_82481_;
            level2.m_8767_((ParticleOptions)ParticleTypes.f_235902_, x, y, z, 0, 0.0, 0.0, 0.0, 1.0);
            owner.m_9236_().m_6263_(null, target.m_20185_(), target.m_20186_(), target.m_20189_(), (SoundEvent)JJKSounds.SLASH.get(), SoundSource.MASTER, 1.0f, 1.0f);
        }
    }

    @Override
    public Ability.Status isTriggerable(LivingEntity owner) {
        return super.isTriggerable(owner);
    }

    @Override
    public float getCost(LivingEntity owner) {
        return 10.0f;
    }

    @Override
    public int getCooldown() {
        return 240;
    }

    @Override
    public int getDuration() {
        return 5;
    }

    @Override
    public Ability.Classification getClassification() {
        return Ability.Classification.SLASHING;
    }

    @Override
    public MenuType getMenuType() {
        return MenuType.J2TSU;
    }
}

