/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.ability.shrine;

import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.Nullable;
import radon.jujutsu_kaisen.ability.AbilityTriggerEvent;
import radon.jujutsu_kaisen.ability.JJKAbilities;
import radon.jujutsu_kaisen.ability.MenuType;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.ability.misc.RCT1;
import radon.jujutsu_kaisen.capability.data.sorcerer.CursedTechnique;
import radon.jujutsu_kaisen.capability.data.sorcerer.ISorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.JujutsuType;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.capability.data.ten_shadows.ITenShadowsData;
import radon.jujutsu_kaisen.capability.data.ten_shadows.TenShadowsDataHandler;
import radon.jujutsu_kaisen.chant.ChantHandler;
import radon.jujutsu_kaisen.config.ConfigHolder;
import radon.jujutsu_kaisen.entity.projectile.WorldSlashProjectile;
import radon.jujutsu_kaisen.entity.ten_shadows.MahoragaEntity;
import radon.jujutsu_kaisen.network.PacketHandler;
import radon.jujutsu_kaisen.network.packet.s2c.SyncSorcererDataS2CPacket;
import radon.jujutsu_kaisen.util.HelperMethods;
import radon.jujutsu_kaisen.util.RotationUtil;

public class WorldSlash
extends Ability {
    public static final float SPEED = 5.0f;
    private static final double RANGE = 64.0;

    @Override
    public boolean isScalable(LivingEntity owner) {
        return true;
    }

    @Override
    public boolean isChantable() {
        return true;
    }

    @Override
    public boolean shouldTrigger(PathfinderMob owner, @Nullable LivingEntity target) {
        if (target == null || target.m_21224_()) {
            return false;
        }
        if (!owner.m_142582_((Entity)target)) {
            return false;
        }
        if (owner instanceof MahoragaEntity) {
            return HelperMethods.RANDOM.m_188503_(20) == 0;
        }
        ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        return cap.getType() == JujutsuType.CURSE || ((RCT1)JJKAbilities.RCT1.get()).isUnlocked((LivingEntity)owner) ? owner.m_21223_() / owner.m_21233_() < 0.9f : owner.m_21223_() / owner.m_21233_() < 0.8f || target.m_21223_() > owner.m_21223_() * 2.0f;
    }

    @Override
    public Ability.Status isTriggerable(LivingEntity owner) {
        if (((Boolean)ConfigHolder.SERVER.chantRequiredForWCS.get()).booleanValue() && owner instanceof Player && ChantHandler.getOutput(owner, this) < 1.5f) {
            return Ability.Status.CHANT;
        }
        return super.isTriggerable(owner);
    }

    @Override
    public boolean isValid(LivingEntity owner) {
        ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        if (!(owner instanceof MahoragaEntity) && !cap.hasTechnique(CursedTechnique.SHRINE)) {
            return false;
        }
        return super.isValid(owner);
    }

    @Override
    public boolean isUnlockable() {
        return true;
    }

    @Override
    public boolean isUnlocked(LivingEntity owner) {
        if (owner instanceof MahoragaEntity) {
            ITenShadowsData cap = (ITenShadowsData)owner.getCapability(TenShadowsDataHandler.INSTANCE).resolve().orElseThrow();
            if (cap.getAdaptation((Ability)JJKAbilities.INFINITY.get()) > 1) {
                return true;
            }
        } else if (owner instanceof Player) {
            Player player = (Player)owner;
            if (player.m_150110_().f_35937_) {
                return true;
            }
        }
        return super.isUnlocked(owner);
    }

    @Override
    public boolean isTechnique() {
        return false;
    }

    @Override
    public Ability.ActivationType getActivationType(LivingEntity owner) {
        return Ability.ActivationType.INSTANT;
    }

    @Override
    public void run(LivingEntity owner) {
        owner.m_6674_(InteractionHand.MAIN_HAND);
        if (owner.m_9236_().f_46443_) {
            return;
        }
        float output = ChantHandler.getOutput(owner, this);
        ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        WorldSlashProjectile slash = new WorldSlashProjectile(owner, output *= cap.getOutput(), (owner.m_6144_() ? 90.0f : 0.0f) + (HelperMethods.RANDOM.m_188501_() - 0.5f) * 60.0f);
        slash.m_20256_(RotationUtil.getTargetAdjustedLookAngle((Entity)owner).m_82490_(5.0));
        owner.m_9236_().m_7967_((Entity)slash);
        owner.m_9236_().m_6263_(null, owner.m_20185_(), owner.m_20186_(), owner.m_20189_(), SoundEvents.f_11880_, SoundSource.MASTER, 1.0f, 1.0f);
    }

    @Override
    public float getCost(LivingEntity owner) {
        return 750.0f;
    }

    @Override
    public int getCooldown() {
        return 600;
    }

    @Override
    public Ability.Classification getClassification() {
        return Ability.Classification.SLASHING;
    }

    @Override
    public MenuType getMenuType() {
        return MenuType.J2TSU;
    }

    public static boolean hasVisualOn(Level level, LivingEntity viewer, LivingEntity target) {
        double threshold;
        Vec3 look = RotationUtil.getTargetAdjustedLookAngle((Entity)viewer);
        Vec3 start = viewer.m_146892_();
        Vec3 result = target.m_146892_().m_82546_(start);
        double angle = Math.acos(look.m_82541_().m_82526_(result.m_82541_()));
        return angle <= (threshold = 1.0);
    }

    @Mod.EventBusSubscriber(modid="jujutsu_kaisen", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class WorldSlashForgeEvents {
        @SubscribeEvent
        public static void onAbilityTrigger(AbilityTriggerEvent.Post event) {
            Ability ability = event.getAbility();
            if (ability != JJKAbilities.WORLD_SLASH.get()) {
                return;
            }
            LivingEntity owner = event.getEntity();
            for (Entity entity : owner.m_9236_().m_45933_((Entity)owner, AABB.m_165882_((Vec3)owner.m_20182_(), (double)64.0, (double)64.0, (double)64.0))) {
                ISorcererData cap;
                LivingEntity living;
                if (!(entity instanceof LivingEntity) || (living = (LivingEntity)entity) instanceof Player && !WorldSlash.hasVisualOn(owner.m_9236_(), living, owner) || !living.getCapability(SorcererDataHandler.INSTANCE).isPresent() || (cap = (ISorcererData)living.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow()).isUnlocked((Ability)JJKAbilities.WORLD_SLASH.get())) continue;
                living.m_9236_().m_6263_(null, living.m_20185_(), living.m_20186_(), living.m_20189_(), SoundEvents.f_144242_, SoundSource.MASTER, 1.0f, 1.0f);
                cap.unlock((Ability)JJKAbilities.WORLD_SLASH.get());
                if (!(entity instanceof ServerPlayer)) continue;
                ServerPlayer player = (ServerPlayer)entity;
                PacketHandler.sendToClient(new SyncSorcererDataS2CPacket(cap.serializeNBT()), player);
            }
        }
    }
}

