/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.capability.data.ten_shadows;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import radon.jujutsu_kaisen.ability.IAdditionalAdaptation;
import radon.jujutsu_kaisen.ability.JJKAbilities;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.capability.data.sorcerer.CursedTechnique;
import radon.jujutsu_kaisen.capability.data.sorcerer.ISorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.capability.data.ten_shadows.Adaptation;
import radon.jujutsu_kaisen.capability.data.ten_shadows.ITenShadowsData;
import radon.jujutsu_kaisen.capability.data.ten_shadows.TenShadowsMode;
import radon.jujutsu_kaisen.damage.JJKDamageSources;
import radon.jujutsu_kaisen.entity.ten_shadows.WheelEntity;

public class TenShadowsData
implements ITenShadowsData {
    private final Set<ResourceLocation> tamed;
    private final Set<ResourceLocation> dead;
    private final List<ItemStack> shadowInventory;
    private final Map<Adaptation, Integer> adapted;
    private final Map<Adaptation, Integer> adapting;
    private final Map<Adaptation, Integer> adaptationCD = new HashMap<Adaptation, Integer>();
    private TenShadowsMode mode = TenShadowsMode.SUMMON;
    private LivingEntity owner;

    public TenShadowsData() {
        this.tamed = new HashSet<ResourceLocation>();
        this.dead = new HashSet<ResourceLocation>();
        this.adapted = new HashMap<Adaptation, Integer>();
        this.adapting = new HashMap<Adaptation, Integer>();
        this.shadowInventory = new ArrayList<ItemStack>();
    }

    @Override
    public void resetAdaptations() {
        this.adapted.clear();
    }

    private void updateAdaptation() {
        ISorcererData cap = (ISorcererData)this.owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        if (!cap.hasToggled((Ability)JJKAbilities.WHEEL.get()) || cap.hasToggled((Ability)JJKAbilities.DOMAIN_AMPLIFICATION.get())) {
            return;
        }
        Iterator<Map.Entry<Adaptation, Integer>> iter = this.adapting.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<Adaptation, Integer> entry = iter.next();
            int timer = entry.getValue();
            int newtimer = timer + 1;
            entry.setValue(newtimer);
            if (++timer >= 1200) {
                iter.remove();
                this.owner.m_9236_().m_6263_(null, this.owner.m_20185_(), this.owner.m_20186_(), this.owner.m_20189_(), SoundEvents.f_11669_, SoundSource.MASTER, 3.0f, 1.0f);
                this.adapted.put(entry.getKey(), this.adapted.getOrDefault(entry.getKey(), 0) + 1);
                WheelEntity wheel = cap.getSummonByClass(WheelEntity.class);
                if (wheel == null) continue;
                wheel.spin();
                continue;
            }
            entry.setValue(timer);
        }
        Iterator<Map.Entry<Adaptation, Integer>> cdIter = this.adaptationCD.entrySet().iterator();
        while (cdIter.hasNext()) {
            Map.Entry<Adaptation, Integer> cdEntry = cdIter.next();
            int cd = cdEntry.getValue() - 1;
            if (cd <= 0) {
                cdIter.remove();
                continue;
            }
            cdEntry.setValue(cd);
        }
    }

    @Override
    public void tick(LivingEntity owner) {
        if (this.owner == null) {
            this.owner = owner;
        }
        this.updateAdaptation();
    }

    @Override
    public void init(LivingEntity owner) {
        this.owner = owner;
    }

    @Override
    public boolean hasTamed(Registry<EntityType<?>> registry, EntityType<?> entity) {
        return this.tamed.contains(registry.m_7981_(entity));
    }

    @Override
    public void tame(Registry<EntityType<?>> registry, EntityType<?> entity) {
        this.tamed.add(registry.m_7981_(entity));
    }

    @Override
    public void setTamed(Set<ResourceLocation> tamed) {
        this.tamed.clear();
        this.tamed.addAll(tamed);
    }

    @Override
    public Set<ResourceLocation> getTamed() {
        return this.tamed;
    }

    @Override
    public boolean isDead(Registry<EntityType<?>> registry, EntityType<?> entity) {
        return this.dead.contains(registry.m_7981_(entity));
    }

    @Override
    public Set<ResourceLocation> getDead() {
        return this.dead;
    }

    @Override
    public void setDead(Set<ResourceLocation> dead) {
        this.dead.clear();
        this.dead.addAll(dead);
    }

    @Override
    public void kill(Registry<EntityType<?>> registry, EntityType<?> entity) {
        this.dead.add(registry.m_7981_(entity));
    }

    @Override
    public void revive(boolean full) {
        this.dead.clear();
        if (full) {
            this.tamed.clear();
        }
    }

    @Override
    public Map<Adaptation, Integer> getAdapted() {
        return this.adapted;
    }

    @Override
    public void addAdapted(Map<Adaptation, Integer> adaptations) {
        this.adapted.putAll(adaptations);
    }

    @Override
    public Map<Adaptation, Integer> getAdapting() {
        return this.adapting;
    }

    @Override
    public void addAdapting(Map<Adaptation, Integer> adapting) {
        this.adapting.putAll(adapting);
    }

    @Override
    public void addShadowInventory(ItemStack stack) {
        this.shadowInventory.add(stack);
    }

    @Override
    public ItemStack getShadowInventory(int index) {
        return this.shadowInventory.get(index);
    }

    @Override
    public List<ItemStack> getShadowInventory() {
        return this.shadowInventory;
    }

    @Override
    public void removeShadowInventory(int index) {
        this.shadowInventory.remove(index);
    }

    @Override
    public int getAdaptation(Ability ability) {
        for (Map.Entry<Adaptation, Integer> entry : this.adapted.entrySet()) {
            Adaptation adapted = entry.getKey();
            Ability current = adapted.getAbility();
            if (current == null) continue;
            if (current == ability) {
                return entry.getValue();
            }
            Ability.Classification first = current.getClassification();
            Ability.Classification second = ability.getClassification();
            if (first == Ability.Classification.NONE || second == Ability.Classification.NONE || first != second) continue;
            return entry.getValue();
        }
        return 0;
    }

    @Override
    public float getAdaptationProgress(DamageSource source) {
        return this.getAdaptationProgress(this.getAdaptation(source));
    }

    @Override
    public float getAdaptationProgress(Adaptation adaptation) {
        return this.adapted.containsKey(adaptation) ? 1.0f : (float)this.adapting.getOrDefault(adaptation, 0).intValue() / 1200.0f;
    }

    @Override
    public Adaptation.Type getAdaptationType(DamageSource source) {
        Adaptation adaptation = this.getAdaptation(source);
        return this.getAdaptationType(adaptation);
    }

    @Override
    public Adaptation.Type getAdaptationType(Adaptation adaptation) {
        RegistryAccess registry = this.owner.m_9236_().m_9598_();
        Registry types = registry.m_175515_(Registries.f_268580_);
        DamageType type = (DamageType)types.m_7745_(adaptation.getKey());
        if (type == types.m_6246_(DamageTypes.f_268566_) || type == types.m_6246_(DamageTypes.f_268464_)) {
            return Adaptation.Type.COUNTER;
        }
        return Adaptation.Type.DAMAGE;
    }

    private Adaptation getAdaptation(DamageSource source) {
        Ability ability;
        RegistryAccess registry = this.owner.m_9236_().m_9598_();
        Registry types = registry.m_175515_(Registries.f_268580_);
        ResourceLocation resourceLocation = types.m_7981_((Object)source.m_269415_());
        if (source instanceof JJKDamageSources.JujutsuDamageSource) {
            JJKDamageSources.JujutsuDamageSource cap = (JJKDamageSources.JujutsuDamageSource)source;
            ability = cap.getAbility();
        } else {
            ability = null;
        }
        return new Adaptation(resourceLocation, ability);
    }

    @Override
    public boolean isAdaptedTo(DamageSource source) {
        JJKDamageSources.JujutsuDamageSource jujutsu;
        Ability ability;
        if (source instanceof JJKDamageSources.JujutsuDamageSource && (ability = (jujutsu = (JJKDamageSources.JujutsuDamageSource)source).getAbility()) != null) {
            return this.isAdaptedTo(ability);
        }
        Adaptation adaptation = this.getAdaptation(source);
        return this.adapted.containsKey(adaptation);
    }

    @Override
    public boolean isAdaptedTo(Ability ability) {
        for (Adaptation adapted : this.adapted.keySet()) {
            Ability current = adapted.getAbility();
            if (current == null) continue;
            if (current == ability) {
                return true;
            }
            Ability.Classification first = current.getClassification();
            Ability.Classification second = ability.getClassification();
            if (first == Ability.Classification.NONE || second == Ability.Classification.NONE || first != second) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isAdaptedTo(CursedTechnique technique) {
        for (Ability ability : technique.getAbilities()) {
            if (!this.isAdaptedTo(ability)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void tryAdapt(DamageSource source) {
        Ability ability;
        RegistryAccess registry = this.owner.m_9236_().m_9598_();
        Registry types = registry.m_175515_(Registries.f_268580_);
        ISorcererData cap = (ISorcererData)this.owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        if (cap.hasToggled((Ability)JJKAbilities.DOMAIN_AMPLIFICATION.get())) {
            return;
        }
        ResourceLocation resourceLocation = types.m_7981_((Object)source.m_269415_());
        if (source instanceof JJKDamageSources.JujutsuDamageSource) {
            JJKDamageSources.JujutsuDamageSource jujutsu = (JJKDamageSources.JujutsuDamageSource)source;
            ability = jujutsu.getAbility();
        } else {
            ability = null;
        }
        Adaptation adaptation = new Adaptation(resourceLocation, ability);
        if (this.adaptationCD.containsKey(adaptation)) {
            return;
        }
        if (!this.adapting.containsKey(adaptation)) {
            this.adapting.put(adaptation, 0);
        } else {
            int timer = this.adapting.get(adaptation);
            this.adapting.put(adaptation, timer += 100);
        }
        this.adaptationCD.put(adaptation, 60);
    }

    @Override
    public void tryAdapt(Ability ability) {
        Adaptation adaptation;
        block7: {
            block8: {
                adaptation = new Adaptation(JJKDamageSources.JUJUTSU.m_135782_(), ability);
                ISorcererData cap = (ISorcererData)this.owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
                if (cap.hasToggled((Ability)JJKAbilities.DOMAIN_AMPLIFICATION.get())) {
                    return;
                }
                if (!this.isAdaptedTo(ability)) break block7;
                if (!(ability instanceof IAdditionalAdaptation)) break block8;
                IAdditionalAdaptation additional = (IAdditionalAdaptation)((Object)ability);
                if (this.adapted == null || this.adapted.get(adaptation) == null || this.adapted.get(adaptation) < additional.getAdditional() + 1) break block7;
            }
            return;
        }
        if (this.adaptationCD.containsKey(adaptation)) {
            return;
        }
        if (!this.adapting.containsKey(adaptation)) {
            this.adapting.put(adaptation, 0);
        } else {
            int timer = this.adapting.get(adaptation);
            this.adapting.put(adaptation, timer += 100);
        }
        this.adaptationCD.put(adaptation, 60);
    }

    @Override
    public TenShadowsMode getMode() {
        return this.mode;
    }

    @Override
    public void setMode(TenShadowsMode mode) {
        this.mode = mode;
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128405_("mode", this.mode.ordinal());
        ListTag tamedTag = new ListTag();
        for (ResourceLocation resourceLocation : this.tamed) {
            tamedTag.add((Object)StringTag.m_129297_((String)resourceLocation.toString()));
        }
        nbt.m_128365_("tamed", (Tag)tamedTag);
        ListTag deadTag = new ListTag();
        for (ResourceLocation resourceLocation : this.dead) {
            deadTag.add((Object)StringTag.m_129297_((String)resourceLocation.toString()));
        }
        nbt.m_128365_("dead", (Tag)deadTag);
        ListTag listTag = new ListTag();
        for (Map.Entry<Adaptation, Integer> entry : this.adapted.entrySet()) {
            CompoundTag data = new CompoundTag();
            data.m_128365_("adaptation", (Tag)entry.getKey().serializeNBT());
            data.m_128405_("stage", entry.getValue().intValue());
            listTag.add((Object)data);
        }
        nbt.m_128365_("adapted", (Tag)listTag);
        ListTag listTag2 = new ListTag();
        for (ItemStack stack : this.shadowInventory) {
            listTag2.add((Object)stack.m_41739_(new CompoundTag()));
        }
        nbt.m_128365_("shadow_inventory", (Tag)listTag2);
        return nbt;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt) {
        this.mode = TenShadowsMode.values()[nbt.m_128451_("mode")];
        this.tamed.clear();
        for (Tag key : nbt.m_128437_("tamed", 8)) {
            this.tamed.add(new ResourceLocation(key.m_7916_()));
        }
        this.dead.clear();
        for (Tag key : nbt.m_128437_("dead", 8)) {
            this.dead.add(new ResourceLocation(key.m_7916_()));
        }
        this.adapted.clear();
        for (Tag key : nbt.m_128437_("adapted", 10)) {
            CompoundTag DATA = (CompoundTag)key;
            this.adapted.put(new Adaptation(DATA.m_128469_("adaptation")), DATA.m_128451_("stage"));
        }
        this.shadowInventory.clear();
        for (Tag key : nbt.m_128437_("shadow_inventory", 10)) {
            this.shadowInventory.add(ItemStack.m_41712_((CompoundTag)((CompoundTag)key)));
        }
    }
}

