/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.client;

import javax.annotation.Nullable;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="jujutsu_kaisen", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class CameraShakeHandler {
    @Nullable
    private static ShakeEvent current;

    @SubscribeEvent
    public static void onComputeCameraAngles(ViewportEvent.ComputeCameraAngles event) {
        if (current == null) {
            return;
        }
        float time = (float)((double)event.getCamera().m_90592_().f_19797_ + event.getPartialTick());
        float shakeX = Mth.m_14089_((float)(time * CameraShakeHandler.current.speed)) * CameraShakeHandler.current.intensity;
        float shakeY = Mth.m_14031_((float)(time * CameraShakeHandler.current.speed)) * CameraShakeHandler.current.intensity;
        event.setPitch(event.getPitch() + shakeX);
        event.setYaw(event.getYaw() + shakeY);
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.type != TickEvent.Type.CLIENT) {
            return;
        }
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        if (current == null) {
            return;
        }
        --CameraShakeHandler.current.duration;
        if (CameraShakeHandler.current.duration <= 0) {
            current = null;
        }
    }

    public static void shakeCamera(float intensity, float speed, int duration) {
        current = new ShakeEvent(intensity, speed, duration);
    }

    public static class ShakeEvent {
        public float intensity;
        public float speed;
        public int duration;

        public ShakeEvent(float intensity, float speed, int duration) {
            this.intensity = intensity;
            this.speed = speed;
            this.duration = duration;
        }
    }
}

