/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.phys.Vec3;
import radon.jujutsu_kaisen.client.MultiBufferSourceSingleton;

public class FakeEntityRenderer {
    public static boolean isFakeRender;
    public static boolean isCustomWalkAnimation;
    public static float walkAnimationPosition;
    public static float walkAnimationSpeed;
    private final Entity entity;
    private final int tickCount;
    private final boolean sneak;
    public float yBodyRot;
    private float yRot;
    private float xRot;
    private float yHeadRot;
    private float attackAnim;
    private float position = 0.0f;
    private float speed = 0.0f;
    private boolean baby;
    private float alpha = 1.0f;

    public FakeEntityRenderer(Entity entity) {
        this.entity = entity;
        this.tickCount = entity.f_19797_;
        this.yRot = entity.m_146908_();
        this.xRot = entity.m_146909_();
        this.sneak = entity.m_6144_();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            this.yHeadRot = living.f_20885_;
            this.yBodyRot = living.f_20883_;
            this.attackAnim = living.f_20921_;
            this.position = living.f_267362_.m_267756_();
            this.speed = living.f_267362_.m_267731_();
        }
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            this.baby = mob.m_6162_();
        }
    }

    public void setFullRotation(float yaw, float pitch) {
        this.yRot = yaw;
        this.xRot = pitch;
        this.yHeadRot = yaw;
        this.yBodyRot = yaw;
    }

    public void setAlpha(float alpha) {
        this.alpha = alpha;
    }

    public void translate(PoseStack poseStack, float partialTicks) {
        Minecraft mc = Minecraft.m_91087_();
        EntityRenderDispatcher dispatcher = mc.m_91290_();
        EntityRenderer renderer = dispatcher.m_114382_(this.entity);
        Vec3 offset = renderer.m_7860_(this.entity, partialTicks);
        Vec3 cam = mc.f_91063_.m_109153_().m_90583_();
        poseStack.m_85837_(-cam.f_82479_ + offset.f_82479_, -cam.f_82480_ + offset.f_82480_, -cam.f_82481_ + offset.f_82481_);
    }

    public void render(Vec3 pos, float partialTicks) {
        PoseStack poseStack = new PoseStack();
        poseStack.m_85837_(pos.f_82479_, pos.f_82480_, pos.f_82481_);
        this.translate(poseStack, partialTicks);
        this.render(poseStack, partialTicks);
    }

    public void setup(Runnable runnable) {
        Mob mob;
        boolean invisible = this.entity.m_20145_();
        this.entity.m_6842_(false);
        int tickCount = this.entity.f_19797_;
        this.entity.f_19797_ = this.tickCount;
        float yRot = this.entity.m_146908_();
        float yRotO = this.entity.f_19859_;
        float xRot = this.entity.m_146909_();
        float xRotO = this.entity.f_19860_;
        this.entity.m_146922_(this.yRot);
        this.entity.f_19859_ = this.yRot;
        this.entity.m_146926_(this.xRot);
        this.entity.f_19860_ = this.xRot;
        boolean sneak = this.entity.m_6144_();
        this.entity.m_20260_(this.sneak);
        int hurtTime = 0;
        int deathTime = 0;
        float yHeadRot = 0.0f;
        float yHeadRotO = 0.0f;
        float yBodyRot = 0.0f;
        float yBodyRotO = 0.0f;
        float attackAnim = 0.0f;
        float oAttackAnim = 0.0f;
        Entity entity = this.entity;
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            hurtTime = living.f_20916_;
            living.f_20916_ = 0;
            deathTime = living.f_20919_;
            living.f_20919_ = 0;
            yHeadRot = living.f_20885_;
            yHeadRotO = living.f_20886_;
            living.f_20885_ = this.yHeadRot;
            living.f_20886_ = this.yHeadRot;
            yBodyRot = living.f_20883_;
            yBodyRotO = living.f_20884_;
            living.f_20883_ = this.yBodyRot;
            living.f_20884_ = this.yBodyRot;
            attackAnim = living.f_20921_;
            oAttackAnim = living.f_20920_;
            living.f_20921_ = this.attackAnim;
            living.f_20920_ = this.attackAnim;
            isCustomWalkAnimation = true;
            walkAnimationPosition = this.position;
            walkAnimationSpeed = this.speed;
        }
        boolean baby = false;
        Entity entity2 = this.entity;
        if (entity2 instanceof Mob) {
            mob = (Mob)entity2;
            baby = mob.m_6162_();
            mob.m_6863_(this.baby);
        }
        runnable.run();
        entity2 = this.entity;
        if (entity2 instanceof Mob) {
            mob = (Mob)entity2;
            mob.m_6863_(baby);
        }
        if ((entity2 = this.entity) instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity2;
            isCustomWalkAnimation = false;
            living.f_20920_ = oAttackAnim;
            living.f_20921_ = attackAnim;
            living.f_20884_ = yBodyRotO;
            living.f_20883_ = yBodyRot;
            living.f_20886_ = yHeadRotO;
            living.f_20885_ = yHeadRot;
            living.f_20916_ = hurtTime;
            living.f_20919_ = deathTime;
        }
        this.entity.m_20260_(sneak);
        this.entity.f_19860_ = xRotO;
        this.entity.m_146926_(xRot);
        this.entity.f_19859_ = yRotO;
        this.entity.m_146922_(yRot);
        this.entity.f_19797_ = tickCount;
        this.entity.m_6842_(invisible);
    }

    public void render(PoseStack poseStack, float partialTicks) {
        this.setup(() -> MultiBufferSourceSingleton.use(buffer -> {
            Minecraft mc = Minecraft.m_91087_();
            EntityRenderDispatcher dispatcher = mc.m_91290_();
            EntityRenderer renderer = dispatcher.m_114382_(this.entity);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.alpha);
            isFakeRender = true;
            renderer.m_7392_(this.entity, this.entity.m_146908_(), partialTicks, poseStack, (MultiBufferSource)buffer, dispatcher.m_114394_(this.entity, partialTicks));
            isFakeRender = false;
            if (this.alpha < 1.0f) {
                buffer.m_6299_(RenderType.m_110466_());
            }
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }));
    }
}

