/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.client.gui.screen.tab;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.MultiLineTextWidget;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Items;
import radon.jujutsu_kaisen.capability.data.sorcerer.BindingVow;
import radon.jujutsu_kaisen.capability.data.sorcerer.ISorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.client.gui.screen.JujutsuScreen;
import radon.jujutsu_kaisen.client.gui.screen.tab.JJKTab;
import radon.jujutsu_kaisen.client.gui.screen.tab.JJKTabType;
import radon.jujutsu_kaisen.client.gui.screen.widget.BindingVowListWidget;
import radon.jujutsu_kaisen.client.gui.screen.widget.JJKSelectionList;
import radon.jujutsu_kaisen.network.PacketHandler;
import radon.jujutsu_kaisen.network.packet.c2s.AddBindingVowC2SPacket;
import radon.jujutsu_kaisen.network.packet.c2s.RemoveBindingVowC2SPacket;

public class BindingVowTab
extends JJKTab {
    private static final Component TITLE = Component.m_237115_((String)String.format("gui.%s.binding_vow", "jujutsu_kaisen"));
    private static final ResourceLocation BACKGROUND = new ResourceLocation("textures/gui/advancements/backgrounds/stone.png");
    private Button add;
    private Button remove;
    private MultiLineTextWidget description;
    @Nullable
    private BindingVowListWidget.Entry vow;

    public BindingVowTab(Minecraft minecraft, JujutsuScreen screen, JJKTabType type, int index, int page) {
        super(minecraft, screen, type, index, page, Items.f_42437_.m_7968_(), TITLE, BACKGROUND, false);
    }

    public void setSelectedBindingVow(BindingVowListWidget.Entry entry) {
        this.vow = entry;
        this.description.m_93666_(entry.get().getDescription());
    }

    public <T extends ObjectSelectionList.Entry<T>> void buildBindingVowList(Consumer<T> consumer, Function<BindingVow, T> result) {
        for (BindingVow vow : BindingVow.values()) {
            consumer.accept((ObjectSelectionList.Entry)result.apply(vow));
        }
    }

    @Override
    public void drawContents(GuiGraphics pGuiGraphics, int pX, int pY) {
        super.drawContents(pGuiGraphics, pX, pY);
        int i = (this.screen.f_96543_ - 252) / 2;
        int j = (this.screen.f_96544_ - 140) / 2;
        int xOffset = i + 18;
        int yOffset = j + 27;
        pGuiGraphics.m_280614_(this.minecraft.f_91062_, (Component)Component.m_237115_((String)String.format("gui.%s.binding_vow.binding_vows", "jujutsu_kaisen")), xOffset, yOffset, 0xFFFFFF, true);
        if (this.minecraft.f_91074_ == null) {
            return;
        }
        ISorcererData cap = (ISorcererData)this.minecraft.f_91074_.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        if (this.vow != null && !cap.isCooldownDone(this.vow.get())) {
            int seconds = cap.getRemainingCooldown(this.vow.get()) / 20;
            int minutes = seconds / 60;
            int remaining = seconds - minutes * 60;
            if (seconds > 60) {
                Font font = this.minecraft.f_91062_;
                MutableComponent mutableComponent = Component.m_237110_((String)String.format("gui.%s.binding_vow.cooldown.minutes", "jujutsu_kaisen"), (Object[])new Object[]{minutes, remaining});
                Objects.requireNonNull(this.minecraft.f_91062_);
                Objects.requireNonNull(this.minecraft.f_91062_);
                pGuiGraphics.m_280614_(font, (Component)mutableComponent, xOffset + 86, yOffset + 9 + 1 - 9 + 1, 0xFFFFFF, true);
            } else if (seconds % 60 != 0) {
                Font font = this.minecraft.f_91062_;
                MutableComponent mutableComponent = Component.m_237110_((String)String.format("gui.%s.binding_vow.cooldown.seconds", "jujutsu_kaisen"), (Object[])new Object[]{remaining});
                Objects.requireNonNull(this.minecraft.f_91062_);
                Objects.requireNonNull(this.minecraft.f_91062_);
                pGuiGraphics.m_280614_(font, (Component)mutableComponent, xOffset + 86, yOffset + 9 + 1 - 9 + 1, 0xFFFFFF, true);
            }
        }
    }

    @Override
    public void tick() {
        super.tick();
        if (this.minecraft.f_91074_ == null) {
            return;
        }
        ISorcererData cap = (ISorcererData)this.minecraft.f_91074_.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        this.add.f_93623_ = this.vow != null && !cap.hasBindingVow(this.vow.get()) && cap.isCooldownDone(this.vow.get());
        this.remove.f_93623_ = this.vow != null && cap.hasBindingVow(this.vow.get()) && cap.isCooldownDone(this.vow.get());
    }

    @Override
    public void addWidgets() {
        if (this.minecraft == null || this.minecraft.f_91074_ == null) {
            return;
        }
        int i = (this.screen.f_96543_ - 252) / 2;
        int j = (this.screen.f_96544_ - 140) / 2;
        int xOffset = i + 18;
        int yOffset = j + 27;
        JJKSelectionList.IBuilder<BindingVow, BindingVowListWidget.Entry> iBuilder = this::buildBindingVowList;
        JJKSelectionList.ICallback<BindingVowListWidget.Entry> iCallback = this::setSelectedBindingVow;
        Objects.requireNonNull(this.minecraft.f_91062_);
        this.addRenderableWidget(new BindingVowListWidget(iBuilder, iCallback, this.minecraft, 78, 85, xOffset, yOffset + 9 + 1));
        Button.Builder builder = Button.m_253074_((Component)Component.m_237115_((String)String.format("gui.%s.binding_vow.add", "jujutsu_kaisen")), pButton -> {
            if (this.vow == null) {
                return;
            }
            ISorcererData cap = (ISorcererData)this.minecraft.f_91074_.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
            PacketHandler.sendToServer(new AddBindingVowC2SPacket(this.vow.get()));
            cap.addBindingVow(this.vow.get());
            this.add.f_93623_ = !cap.hasBindingVow(this.vow.get());
            this.remove.f_93623_ = cap.hasBindingVow(this.vow.get());
            cap.addBindingVowCooldown(this.vow.get());
        }).m_253046_(61, 20);
        Objects.requireNonNull(this.minecraft.f_91062_);
        this.add = builder.m_252794_(xOffset + 86, yOffset + 9 + 66).m_253136_();
        this.addRenderableWidget(this.add);
        Button.Builder builder2 = Button.m_253074_((Component)Component.m_237115_((String)String.format("gui.%s.binding_vow.remove", "jujutsu_kaisen")), pButton -> {
            if (this.vow == null) {
                return;
            }
            ISorcererData cap = (ISorcererData)this.minecraft.f_91074_.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
            PacketHandler.sendToServer(new RemoveBindingVowC2SPacket(this.vow.get()));
            cap.removeBindingVow(this.vow.get());
            this.add.f_93623_ = !cap.hasBindingVow(this.vow.get());
            this.remove.f_93623_ = cap.hasBindingVow(this.vow.get());
            cap.addBindingVowCooldown(this.vow.get());
        }).m_253046_(61, 20);
        Objects.requireNonNull(this.minecraft.f_91062_);
        this.remove = builder2.m_252794_(xOffset + 155, yOffset + 9 + 66).m_253136_();
        this.addRenderableWidget(this.remove);
        Objects.requireNonNull(this.minecraft.f_91062_);
        this.description = new MultiLineTextWidget(xOffset + 86, yOffset + 9 + 1, (Component)Component.m_237119_(), this.minecraft.f_91062_).m_269098_(129);
        this.addRenderableWidget(this.description);
    }
}

