/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.client.gui.screen.tab;

import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.item.Items;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.gui.widget.ForgeSlider;
import org.joml.Vector3f;
import radon.jujutsu_kaisen.capability.data.sorcerer.ISorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.client.gui.screen.JujutsuScreen;
import radon.jujutsu_kaisen.client.gui.screen.tab.JJKTab;
import radon.jujutsu_kaisen.client.gui.screen.tab.JJKTabType;
import radon.jujutsu_kaisen.network.PacketHandler;
import radon.jujutsu_kaisen.network.packet.c2s.SetCursedEnergyColorC2SPacket;

public class CursedEnergyColorTab
extends JJKTab {
    private static final Component TITLE = Component.m_237115_((String)String.format("gui.%s.cursed_energy_color", "jujutsu_kaisen"));
    private static final ResourceLocation BACKGROUND = new ResourceLocation("textures/gui/advancements/backgrounds/stone.png");
    private ForgeSlider rSlider;
    private ForgeSlider gSlider;
    private ForgeSlider bSlider;
    private float oldR;
    private float oldG;
    private float oldB;

    public CursedEnergyColorTab(Minecraft minecraft, JujutsuScreen screen, JJKTabType type, int index, int page) {
        super(minecraft, screen, type, index, page, Items.f_42497_.m_7968_(), TITLE, BACKGROUND, false);
    }

    @Override
    public void tick() {
        float r = (float)this.rSlider.getValue();
        float g = (float)this.gSlider.getValue();
        float b = (float)this.bSlider.getValue();
        if (r != this.oldR || g != this.oldG || b != this.oldB) {
            if (this.minecraft != null && this.minecraft.f_91074_ != null) {
                int color = FastColor.ARGB32.m_13660_((int)255, (int)Math.round(r), (int)Math.round(g), (int)Math.round(b));
                ISorcererData cap = (ISorcererData)this.minecraft.f_91074_.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
                PacketHandler.sendToServer(new SetCursedEnergyColorC2SPacket(color));
                cap.setCursedEnergyColor(color);
            }
            this.oldR = r;
            this.oldG = g;
            this.oldB = b;
        }
    }

    @Override
    public void drawContents(GuiGraphics pGuiGraphics, int pX, int pY) {
        super.drawContents(pGuiGraphics, pX, pY);
        int i = (this.screen.f_96543_ - 252) / 2;
        int j = (this.screen.f_96544_ - 140) / 2;
        int centerY = j + 70;
        Font font = this.minecraft.f_91062_;
        MutableComponent mutableComponent = Component.m_237115_((String)String.format("gui.%s.cursed_energy_color.red", "jujutsu_kaisen"));
        Objects.requireNonNull(this.minecraft.f_91062_);
        pGuiGraphics.m_280614_(font, (Component)mutableComponent, i + 71, centerY - 32 - 9 - 2, 0xFFFFFF, true);
        Font font2 = this.minecraft.f_91062_;
        MutableComponent mutableComponent2 = Component.m_237115_((String)String.format("gui.%s.cursed_energy_color.green", "jujutsu_kaisen"));
        Objects.requireNonNull(this.minecraft.f_91062_);
        pGuiGraphics.m_280614_(font2, (Component)mutableComponent2, i + 71, centerY - 9 - 2, 0xFFFFFF, true);
        Font font3 = this.minecraft.f_91062_;
        MutableComponent mutableComponent3 = Component.m_237115_((String)String.format("gui.%s.cursed_energy_color.blue", "jujutsu_kaisen"));
        Objects.requireNonNull(this.minecraft.f_91062_);
        pGuiGraphics.m_280614_(font3, (Component)mutableComponent3, i + 71, centerY + 32 - 9 - 2, 0xFFFFFF, true);
    }

    @Override
    public void addWidgets() {
        if (this.minecraft == null || this.minecraft.f_91074_ == null) {
            return;
        }
        ISorcererData cap = (ISorcererData)this.minecraft.f_91074_.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        Vector3f color = Vec3.m_82501_((int)cap.getCursedEnergyColor()).m_252839_();
        int i = (this.screen.f_96543_ - 252) / 2;
        int j = (this.screen.f_96544_ - 140) / 2;
        int centerY = j + 70;
        this.rSlider = new ForgeSlider(i + 71, centerY - 32, 110, 16, (Component)Component.m_237119_(), (Component)Component.m_237119_(), 0.0, 255.0, (double)(color.x * 255.0f), 0.1, 0, true);
        this.addRenderableWidget(this.rSlider);
        this.gSlider = new ForgeSlider(i + 71, centerY, 110, 16, (Component)Component.m_237119_(), (Component)Component.m_237119_(), 0.0, 255.0, (double)(color.y * 255.0f), 0.1, 0, true);
        this.addRenderableWidget(this.gSlider);
        this.bSlider = new ForgeSlider(i + 71, centerY + 32, 110, 16, (Component)Component.m_237119_(), (Component)Component.m_237119_(), 0.0, 255.0, (double)(color.z * 255.0f), 0.1, 0, true);
        this.addRenderableWidget(this.bSlider);
    }
}

