/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.client.model.base;

import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.LayerDefinitions;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.NotNull;

public class SkinModel<T extends LivingEntity>
extends PlayerModel<T> {
    public SkinModel(ModelPart pRoot) {
        super(pRoot, false);
    }

    public static LayerDefinition createBodyLayer() {
        return LayerDefinition.m_171565_((MeshDefinition)PlayerModel.m_170825_((CubeDeformation)CubeDeformation.f_171458_, (boolean)false), (int)64, (int)64);
    }

    public static LayerDefinition createSlimBodyLayer() {
        return LayerDefinition.m_171565_((MeshDefinition)PlayerModel.m_170825_((CubeDeformation)CubeDeformation.f_171458_, (boolean)true), (int)64, (int)64);
    }

    public static LayerDefinition createInnerLayer() {
        return LayerDefinition.m_171565_((MeshDefinition)HumanoidModel.m_170681_((CubeDeformation)LayerDefinitions.f_171107_, (float)0.0f), (int)64, (int)32);
    }

    public static LayerDefinition createOuterLayer() {
        return LayerDefinition.m_171565_((MeshDefinition)HumanoidModel.m_170681_((CubeDeformation)LayerDefinitions.f_171106_, (float)0.0f), (int)64, (int)32);
    }

    private HumanoidModel.ArmPose getArmPose(T pEntity, InteractionHand pHand) {
        HumanoidModel.ArmPose forgePose;
        ItemStack stack = pEntity.m_21120_(pHand);
        if (stack.m_41619_()) {
            return HumanoidModel.ArmPose.EMPTY;
        }
        if (pEntity.m_7655_() == pHand && pEntity.m_21212_() > 0) {
            UseAnim anim = stack.m_41780_();
            if (anim == UseAnim.BLOCK) {
                return HumanoidModel.ArmPose.BLOCK;
            }
            if (anim == UseAnim.BOW) {
                return HumanoidModel.ArmPose.BOW_AND_ARROW;
            }
            if (anim == UseAnim.SPEAR) {
                return HumanoidModel.ArmPose.THROW_SPEAR;
            }
            if (anim == UseAnim.CROSSBOW && pHand == pEntity.m_7655_()) {
                return HumanoidModel.ArmPose.CROSSBOW_CHARGE;
            }
            if (anim == UseAnim.SPYGLASS) {
                return HumanoidModel.ArmPose.SPYGLASS;
            }
            if (anim == UseAnim.TOOT_HORN) {
                return HumanoidModel.ArmPose.TOOT_HORN;
            }
        } else if (!((LivingEntity)pEntity).f_20911_ && stack.m_41720_() instanceof CrossbowItem && CrossbowItem.m_40932_((ItemStack)stack)) {
            return HumanoidModel.ArmPose.CROSSBOW_HOLD;
        }
        if ((forgePose = IClientItemExtensions.of((ItemStack)stack).getArmPose(pEntity, pHand, stack)) != null) {
            return forgePose;
        }
        return HumanoidModel.ArmPose.ITEM;
    }

    public void m_6839_(@NotNull T pEntity, float pLimbSwing, float pLimbSwingAmount, float pPartialTick) {
        this.f_102816_ = this.getArmPose(pEntity, InteractionHand.MAIN_HAND);
        this.f_102815_ = this.getArmPose(pEntity, InteractionHand.OFF_HAND);
        super.m_6839_(pEntity, pLimbSwing, pLimbSwingAmount, pPartialTick);
    }
}

