/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.client.slice;

import net.minecraft.world.phys.Vec3;
import org.joml.AxisAngle4f;
import org.joml.Matrix3f;

public class LegacyMath {
    public static Vec3 normalize(Vec3 vec) {
        double d0 = (float)Math.sqrt(vec.f_82479_ * vec.f_82479_ + vec.f_82480_ * vec.f_82480_ + vec.f_82481_ * vec.f_82481_);
        return d0 < 1.0E-4 ? Vec3.f_82478_ : new Vec3(vec.f_82479_ / d0, vec.f_82480_ / d0, vec.f_82481_ / d0);
    }

    public static void invert(Matrix3f mat) {
        double[] luMatrix = new double[9];
        double[] inverseMatrix = new double[9];
        int[] pivotIndices = new int[3];
        luMatrix[0] = mat.m00;
        luMatrix[1] = mat.m01;
        luMatrix[2] = mat.m02;
        luMatrix[3] = mat.m10;
        luMatrix[4] = mat.m11;
        luMatrix[5] = mat.m12;
        luMatrix[6] = mat.m20;
        luMatrix[7] = mat.m21;
        luMatrix[8] = mat.m22;
        if (!LegacyMath.luDecomposition(luMatrix, pivotIndices)) {
            throw new RuntimeException("Cannot invert matrix!");
        }
        for (int i = 0; i < 9; ++i) {
            inverseMatrix[i] = 0.0;
        }
        inverseMatrix[0] = 1.0;
        inverseMatrix[4] = 1.0;
        inverseMatrix[8] = 1.0;
        LegacyMath.luBacksubstitution(luMatrix, pivotIndices, inverseMatrix);
        mat.m00 = (float)inverseMatrix[0];
        mat.m01 = (float)inverseMatrix[1];
        mat.m02 = (float)inverseMatrix[2];
        mat.m10 = (float)inverseMatrix[3];
        mat.m11 = (float)inverseMatrix[4];
        mat.m12 = (float)inverseMatrix[5];
        mat.m20 = (float)inverseMatrix[6];
        mat.m21 = (float)inverseMatrix[7];
        mat.m22 = (float)inverseMatrix[8];
    }

    private static boolean luDecomposition(double[] matrix, int[] pivotIndices) {
        double[] scalingFactors = new double[3];
        int matrixIndex = 0;
        int scalingIndex = 0;
        int row = 3;
        while (row-- != 0) {
            double largestElement = 0.0;
            int column = 3;
            while (column-- != 0) {
                double element = matrix[matrixIndex++];
                if (!((element = Math.abs(element)) > largestElement)) continue;
                largestElement = element;
            }
            if (largestElement == 0.0) {
                return false;
            }
            scalingFactors[scalingIndex++] = 1.0 / largestElement;
        }
        int matrixBaseIndex = 0;
        for (row = 0; row < 3; ++row) {
            double scalingFactor;
            int rowIndex;
            int columnIndex;
            int subMatrixIndex;
            int iMax;
            double sum;
            for (matrixIndex = 0; matrixIndex < row; ++matrixIndex) {
                int rowIndex2 = matrixBaseIndex + 3 * matrixIndex + row;
                sum = matrix[rowIndex2];
                iMax = matrixIndex;
                subMatrixIndex = matrixBaseIndex + 3 * matrixIndex;
                columnIndex = matrixBaseIndex + row;
                while (iMax-- != 0) {
                    sum -= matrix[subMatrixIndex] * matrix[columnIndex];
                    ++subMatrixIndex;
                    columnIndex += 3;
                }
                matrix[rowIndex2] = sum;
            }
            double largestScalingFactor = 0.0;
            scalingIndex = -1;
            for (matrixIndex = row; matrixIndex < 3; ++matrixIndex) {
                double d;
                rowIndex = matrixBaseIndex + 3 * matrixIndex + row;
                sum = matrix[rowIndex];
                iMax = row;
                subMatrixIndex = matrixBaseIndex + 3 * matrixIndex;
                columnIndex = matrixBaseIndex + row;
                while (iMax-- != 0) {
                    sum -= matrix[subMatrixIndex] * matrix[columnIndex];
                    ++subMatrixIndex;
                    columnIndex += 3;
                }
                matrix[rowIndex] = sum;
                scalingFactor = scalingFactors[matrixIndex] * Math.abs(sum);
                if (!(d >= largestScalingFactor)) continue;
                largestScalingFactor = scalingFactor;
                scalingIndex = matrixIndex;
            }
            if (scalingIndex < 0) {
                throw new RuntimeException("Logic error: imax < 0");
            }
            if (row != scalingIndex) {
                iMax = 3;
                subMatrixIndex = matrixBaseIndex + 3 * scalingIndex;
                columnIndex = matrixBaseIndex + 3 * row;
                while (iMax-- != 0) {
                    scalingFactor = matrix[subMatrixIndex];
                    matrix[subMatrixIndex++] = matrix[columnIndex];
                    matrix[columnIndex++] = scalingFactor;
                }
                scalingFactors[scalingIndex] = scalingFactors[row];
            }
            pivotIndices[row] = scalingIndex;
            if (matrix[matrixBaseIndex + 3 * row + row] == 0.0) {
                return false;
            }
            if (row == 2) continue;
            scalingFactor = 1.0 / matrix[matrixBaseIndex + 3 * row + row];
            rowIndex = matrixBaseIndex + 3 * (row + 1) + row;
            matrixIndex = 2 - row;
            while (matrixIndex-- != 0) {
                int n = rowIndex;
                matrix[n] = matrix[n] * scalingFactor;
                rowIndex += 3;
            }
        }
        return true;
    }

    private static void luBacksubstitution(double[] luMatrix, int[] pivotIndices, double[] inverseMatrix) {
        int matrixBaseIndex = 0;
        for (int row = 0; row < 3; ++row) {
            int i;
            int index = row;
            int backSubRowIndex = -1;
            for (int column = 0; column < 3; ++column) {
                int pivotIndex = pivotIndices[matrixBaseIndex + column];
                double sum = inverseMatrix[index + 3 * pivotIndex];
                inverseMatrix[index + 3 * pivotIndex] = inverseMatrix[index + 3 * column];
                if (backSubRowIndex >= 0) {
                    i = column * 3;
                    for (int backSubColumn = backSubRowIndex; backSubColumn <= column - 1; ++backSubColumn) {
                        sum -= luMatrix[i + backSubColumn] * inverseMatrix[index + 3 * backSubColumn];
                    }
                } else if (sum != 0.0) {
                    backSubRowIndex = column;
                }
                inverseMatrix[index + 3 * column] = sum;
            }
            int luMatrixBaseIndex = 6;
            int n = index + 6;
            inverseMatrix[n] = inverseMatrix[n] / luMatrix[luMatrixBaseIndex + 2];
            i = luMatrixBaseIndex - 3;
            inverseMatrix[index + 3] = (inverseMatrix[index + 3] - luMatrix[i + 2] * inverseMatrix[index + 6]) / luMatrix[i + 1];
            inverseMatrix[index + 0] = (inverseMatrix[index + 0] - luMatrix[(i -= 3) + 1] * inverseMatrix[index + 3] - luMatrix[i + 2] * inverseMatrix[index + 6]) / luMatrix[i + 0];
        }
    }

    public static void set(Matrix3f mat, AxisAngle4f axis) {
        float magnitude = (float)Math.sqrt(axis.x * axis.x + axis.y * axis.y + axis.z * axis.z);
        if ((double)magnitude < 1.0E-8) {
            mat.m00 = 1.0f;
            mat.m01 = 0.0f;
            mat.m02 = 0.0f;
            mat.m10 = 0.0f;
            mat.m11 = 1.0f;
            mat.m12 = 0.0f;
            mat.m20 = 0.0f;
            mat.m21 = 0.0f;
            mat.m22 = 1.0f;
        } else {
            magnitude = 1.0f / magnitude;
            float x = axis.x * magnitude;
            float y = axis.y * magnitude;
            float z = axis.z * magnitude;
            float sinAngle = (float)Math.sin(axis.angle);
            float cosAngle = (float)Math.cos(axis.angle);
            float oneMinusCosAngle = 1.0f - cosAngle;
            float xz = x * z;
            float xy = x * y;
            float yz = y * z;
            mat.m00 = oneMinusCosAngle * x * x + cosAngle;
            mat.m01 = oneMinusCosAngle * xy - sinAngle * z;
            mat.m02 = oneMinusCosAngle * xz + sinAngle * y;
            mat.m10 = oneMinusCosAngle * xy + sinAngle * z;
            mat.m11 = oneMinusCosAngle * y * y + cosAngle;
            mat.m12 = oneMinusCosAngle * yz - sinAngle * x;
            mat.m20 = oneMinusCosAngle * xz - sinAngle * y;
            mat.m21 = oneMinusCosAngle * yz + sinAngle * x;
            mat.m22 = oneMinusCosAngle * z * z + cosAngle;
        }
    }

    public static void mul(Matrix3f a, Matrix3f b) {
        float m00 = a.m00 * b.m00 + a.m01 * b.m10 + a.m02 * b.m20;
        float m01 = a.m00 * b.m01 + a.m01 * b.m11 + a.m02 * b.m21;
        float m02 = a.m00 * b.m02 + a.m01 * b.m12 + a.m02 * b.m22;
        float m10 = a.m10 * b.m00 + a.m11 * b.m10 + a.m12 * b.m20;
        float m11 = a.m10 * b.m01 + a.m11 * b.m11 + a.m12 * b.m21;
        float m12 = a.m10 * b.m02 + a.m11 * b.m12 + a.m12 * b.m22;
        float m20 = a.m20 * b.m00 + a.m21 * b.m10 + a.m22 * b.m20;
        float m21 = a.m20 * b.m01 + a.m21 * b.m11 + a.m22 * b.m21;
        float m22 = a.m20 * b.m02 + a.m21 * b.m12 + a.m22 * b.m22;
        a.m00 = m00;
        a.m01 = m01;
        a.m02 = m02;
        a.m10 = m10;
        a.m11 = m11;
        a.m12 = m12;
        a.m20 = m20;
        a.m21 = m21;
        a.m22 = m22;
    }
}

