/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.entity.projectile;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import radon.jujutsu_kaisen.ExplosionHandler;
import radon.jujutsu_kaisen.ability.JJKAbilities;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.capability.data.sorcerer.ISorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererGrade;
import radon.jujutsu_kaisen.damage.JJKDamageSources;
import radon.jujutsu_kaisen.entity.JJKEntities;
import radon.jujutsu_kaisen.entity.curse.base.CursedSpirit;
import radon.jujutsu_kaisen.entity.projectile.base.JujutsuProjectile;
import radon.jujutsu_kaisen.network.PacketHandler;
import radon.jujutsu_kaisen.network.packet.s2c.SyncSorcererDataS2CPacket;
import radon.jujutsu_kaisen.util.RotationUtil;
import radon.jujutsu_kaisen.util.SorcererUtil;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class MaximumUzumakiProjectile
extends JujutsuProjectile
implements GeoEntity {
    private static final int DELAY = 40;
    private static final double RANGE = 25.0;
    private static final float MAX_POWER = 18.0f;
    private float power;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public MaximumUzumakiProjectile(EntityType<? extends Projectile> pType, Level pLevel) {
        super(pType, pLevel);
    }

    public MaximumUzumakiProjectile(LivingEntity owner, float power) {
        super((EntityType<? extends Projectile>)((EntityType)JJKEntities.MAXIMUM_UZUMAKI.get()), owner.m_9236_(), (Entity)owner, power);
        Vec3 pos = owner.m_20182_().m_82546_(RotationUtil.getTargetAdjustedLookAngle((Entity)owner).m_82542_((double)this.m_20205_(), 0.0, (double)this.m_20205_())).m_82520_(0.0, (double)this.m_20206_(), 0.0);
        this.m_7678_(pos.f_82479_, pos.f_82480_, pos.f_82481_, RotationUtil.getTargetAdjustedYRot((Entity)owner), RotationUtil.getTargetAdjustedXRot((Entity)owner));
        ISorcererData ownerCap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        for (Entity entity : ownerCap.getSummons()) {
            float addPower;
            if (this.power == 18.0f) break;
            if (!(entity instanceof CursedSpirit)) continue;
            ISorcererData curseCap = (ISorcererData)entity.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
            if (SorcererUtil.getGrade(curseCap.getExperience()).ordinal() >= SorcererGrade.SEMI_GRADE_1.ordinal() && curseCap.getTechnique() != null) {
                ownerCap.absorb(curseCap.getTechnique());
                if (owner instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)owner;
                    PacketHandler.sendToClient(new SyncSorcererDataS2CPacket(ownerCap.serializeNBT()), player);
                }
            }
            if ((addPower = SorcererUtil.getPower(curseCap.getExperience())) < 2.9f) {
                addPower /= 3.5f;
            }
            if (addPower > 3.85f) {
                addPower *= 1.9f;
            }
            this.power = Math.min(18.0f, this.power + (addPower /= 1.25f));
            entity.m_146870_();
        }
    }

    @Override
    protected void m_7380_(@NotNull CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128350_("power", this.power);
    }

    @Override
    protected void m_7378_(@NotNull CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.power = pCompound.m_128457_("power");
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        Entity entity = this.m_19749_();
        if (entity instanceof LivingEntity) {
            LivingEntity owner = (LivingEntity)entity;
            if (this.m_9236_().f_46443_) {
                return;
            }
            if (this.getTime() < 40) {
                if (!owner.m_6084_()) {
                    this.m_146870_();
                } else {
                    Vec3 pos = owner.m_20182_().m_82546_(RotationUtil.getTargetAdjustedLookAngle((Entity)owner).m_82542_((double)this.m_20205_(), 0.0, (double)this.m_20205_())).m_82520_(0.0, (double)this.m_20206_(), 0.0);
                    this.m_7678_(pos.f_82479_, pos.f_82480_, pos.f_82481_, RotationUtil.getTargetAdjustedYRot((Entity)owner), RotationUtil.getTargetAdjustedXRot((Entity)owner));
                }
            } else if (this.getTime() - 20 >= 40) {
                this.m_146870_();
            } else if (this.getTime() == 40) {
                Vec3 look;
                Vec3 end;
                Vec3 start = owner.m_146892_();
                HitResult result = RotationUtil.getHitResult((Entity)owner, start, end = start.m_82549_((look = RotationUtil.getTargetAdjustedLookAngle((Entity)owner)).m_82490_(25.0)));
                Vec3 pos = result.m_6662_() == HitResult.Type.MISS ? end : result.m_82450_();
                this.m_146884_(pos);
                Vec3 offset = new Vec3(this.m_20185_(), this.m_20186_() + (double)(this.m_20206_() / 2.0f), this.m_20189_());
                ExplosionHandler.spawn((ResourceKey<Level>)this.m_9236_().m_46472_(), offset, this.power * 1.95f, 20, this.getPower() * 0.5f, owner, JJKDamageSources.indirectJujutsuAttack((Entity)this, owner, (Ability)JJKAbilities.MAXIMUM_UZUMAKI.get()), false);
            }
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

