/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.entity.sorcerer;

import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import radon.jujutsu_kaisen.ability.JJKAbilities;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.capability.data.sorcerer.CursedTechnique;
import radon.jujutsu_kaisen.capability.data.sorcerer.ISorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.JujutsuType;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererGrade;
import radon.jujutsu_kaisen.capability.data.sorcerer.Trait;
import radon.jujutsu_kaisen.entity.sorcerer.base.SorcererEntity;
import radon.jujutsu_kaisen.item.JJKItems;
import radon.jujutsu_kaisen.item.armor.InventoryCurseItem;
import radon.jujutsu_kaisen.menu.BountyMenu;
import radon.jujutsu_kaisen.util.CuriosUtil;
import radon.jujutsu_kaisen.util.HelperMethods;

public class TojiFushiguroEntity
extends SorcererEntity {
    private static final int PLAYFUL_CLOUD = 0;
    private static final int INVERTED_SPEAR_OF_HEAVEN = 1;
    private static final int SPLIT_SOUL_KATANA = 2;
    private static final int TELEPORT_RADIUS = 32;
    @Nullable
    private UUID bountyUUID;
    @Nullable
    private ServerPlayer cachedBounty;
    @Nullable
    private UUID issuerUUID;
    @Nullable
    private ServerPlayer cachedIssuer;
    @Nullable
    private Player currentCustomer;

    public TojiFushiguroEntity(EntityType<? extends PathfinderMob> pType, Level pLevel) {
        super(pType, pLevel);
        Arrays.fill(this.f_21348_, 0.0f);
        Arrays.fill(this.f_21347_, 0.0f);
    }

    @Override
    protected boolean isCustom() {
        return false;
    }

    public void setCurrentCustomer(@Nullable Player pPlayer) {
        this.currentCustomer = pPlayer;
    }

    @Nullable
    public Player getCurrentCustomer() {
        return this.currentCustomer;
    }

    private boolean isTrading() {
        return this.currentCustomer != null;
    }

    public void stopTrading() {
        this.setCurrentCustomer(null);
    }

    public void setBounty(ServerPlayer issuer, ServerPlayer bounty) {
        this.issuerUUID = issuer.m_20148_();
        this.cachedIssuer = issuer;
        this.bountyUUID = bounty.m_20148_();
        this.cachedBounty = bounty;
        issuer.m_213846_((Component)Component.m_237110_((String)String.format("chat.%s.bounty_set", "jujutsu_kaisen"), (Object[])new Object[]{bounty.m_7755_()}));
    }

    private void clearBounty() {
        this.issuerUUID = null;
        this.cachedIssuer = null;
        this.bountyUUID = null;
        this.cachedBounty = null;
    }

    @Nullable
    private ServerPlayer getIssuer() {
        if (this.cachedIssuer != null && !this.cachedIssuer.m_213877_()) {
            return this.cachedIssuer;
        }
        if (this.issuerUUID != null && this.m_9236_() instanceof ServerLevel) {
            this.cachedIssuer = (ServerPlayer)((ServerLevel)this.m_9236_()).m_8791_(this.issuerUUID);
            return this.cachedIssuer;
        }
        return null;
    }

    @Nullable
    private ServerPlayer getBounty() {
        if (this.cachedBounty != null && !this.cachedBounty.m_213877_()) {
            return this.cachedBounty;
        }
        if (this.bountyUUID != null && this.m_9236_() instanceof ServerLevel) {
            this.cachedBounty = (ServerPlayer)((ServerLevel)this.m_9236_()).m_8791_(this.bountyUUID);
            return this.cachedBounty;
        }
        return null;
    }

    @Override
    public List<Ability> getUnlocked() {
        return List.of((Ability)JJKAbilities.QUICKDASH.get());
    }

    public float getStepHeight() {
        return 5.0f;
    }

    public void m_7380_(@NotNull CompoundTag pCompound) {
        super.m_7380_(pCompound);
        if (this.bountyUUID != null) {
            pCompound.m_128362_("bounty", this.bountyUUID);
        }
        if (this.issuerUUID != null) {
            pCompound.m_128362_("issuer", this.issuerUUID);
        }
    }

    public void m_7378_(@NotNull CompoundTag pCompound) {
        super.m_7378_(pCompound);
        if (pCompound.m_128441_("bounty")) {
            this.bountyUUID = pCompound.m_128342_("bounty");
        }
        if (pCompound.m_128441_("issuer")) {
            this.issuerUUID = pCompound.m_128342_("issuer");
        }
    }

    @NotNull
    protected InteractionResult m_6071_(Player pPlayer, @NotNull InteractionHand pHand) {
        ItemStack stack = pPlayer.m_21120_(pHand);
        if (!pPlayer.m_36341_() && stack.m_41619_()) {
            this.setCurrentCustomer(pPlayer);
            pPlayer.m_5893_((MenuProvider)new SimpleMenuProvider((pContainerId, pPlayerInventory, ignored) -> new BountyMenu(pContainerId, pPlayerInventory, ContainerLevelAccess.m_39289_((Level)pPlayer.m_9236_(), (BlockPos)this.m_20183_()), this), (Component)Component.m_237119_()));
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        return super.m_6071_(pPlayer, pHand);
    }

    @Override
    public float getExperience() {
        return SorcererGrade.SPECIAL_GRADE.getRequiredExperience() * 2.0f;
    }

    @Override
    @Nullable
    public CursedTechnique getTechnique() {
        return null;
    }

    @Override
    @NotNull
    public List<Trait> getTraits() {
        return List.of(Trait.HEAVENLY_RESTRICTION);
    }

    @Override
    public JujutsuType getJujutsuType() {
        return JujutsuType.SORCERER;
    }

    @Override
    public void onAddedToWorld() {
        super.onAddedToWorld();
        ItemStack inventory = new ItemStack((ItemLike)JJKItems.INVENTORY_CURSE.get());
        InventoryCurseItem.addItem(inventory, 0, new ItemStack((ItemLike)JJKItems.PLAYFUL_CLOUD.get()));
        InventoryCurseItem.addItem(inventory, 1, new ItemStack((ItemLike)JJKItems.INVERTED_SPEAR_OF_HEAVEN.get()));
        InventoryCurseItem.addItem(inventory, 2, new ItemStack((ItemLike)JJKItems.SPLIT_SOUL_KATANA.get()));
        CuriosUtil.setItemInSlot((LivingEntity)this, "body", inventory);
    }

    private int getSlot(ItemStack stack) {
        if (stack.m_150930_((Item)JJKItems.PLAYFUL_CLOUD.get())) {
            return 0;
        }
        if (stack.m_150930_((Item)JJKItems.INVERTED_SPEAR_OF_HEAVEN.get())) {
            return 1;
        }
        if (stack.m_150930_((Item)JJKItems.SPLIT_SOUL_KATANA.get())) {
            return 2;
        }
        return -1;
    }

    private void pickWeapon(@Nullable LivingEntity target) {
        ItemStack inventory = CuriosUtil.findSlot((LivingEntity)this, "body");
        if (target == null) {
            int slot;
            if (!this.m_21205_().m_41619_() && (slot = this.getSlot(this.m_21205_())) != -1) {
                InventoryCurseItem.addItem(inventory, slot, this.m_21205_());
            }
            this.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
            return;
        }
        int result = 0;
        if (target.getCapability(SorcererDataHandler.INSTANCE).isPresent() || target.m_21207_() > 0.0f) {
            result = 2;
        }
        if (target.getCapability(SorcererDataHandler.INSTANCE).isPresent()) {
            ISorcererData cap = (ISorcererData)target.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
            for (Ability toggled : cap.getToggled()) {
                if (!toggled.isTechnique()) continue;
                result = 1;
                break;
            }
        }
        if (this.getSlot(this.m_21205_()) != result) {
            int slot;
            if (!this.m_21205_().m_41619_() && (slot = this.getSlot(this.m_21205_())) != -1) {
                InventoryCurseItem.addItem(inventory, slot, this.m_21205_());
            }
            ItemStack main = InventoryCurseItem.getItem(inventory, result);
            InventoryCurseItem.removeItem(inventory, result);
            this.m_21008_(InteractionHand.MAIN_HAND, main);
        }
    }

    public boolean m_21525_() {
        return this.isTrading() || super.m_21525_();
    }

    @Override
    protected void m_8024_() {
        super.m_8024_();
        LivingEntity target = this.m_5448_();
        this.pickWeapon(target);
        ServerPlayer bounty = this.getBounty();
        if (bounty != null) {
            if (this.m_5448_() == null) {
                this.m_6710_((LivingEntity)bounty);
            }
            if ((double)this.m_20270_((Entity)bounty) >= this.m_21133_(Attributes.f_22277_)) {
                double d0 = bounty.m_20185_() + (HelperMethods.RANDOM.m_188500_() - HelperMethods.RANDOM.m_188500_() + 0.1) * 32.0 + 0.5;
                double d1 = bounty.m_20186_() + (double)HelperMethods.RANDOM.m_188503_(3) - 1.0;
                double d2 = bounty.m_20189_() + (HelperMethods.RANDOM.m_188500_() - HelperMethods.RANDOM.m_188500_() + 0.1) * 32.0 + 0.5;
                if (this.m_9236_().m_45772_(this.m_6095_().m_20585_(d0, d1, d2))) {
                    this.m_6034_(d0, d1, d2);
                }
            }
        }
    }

    public boolean m_7327_(@NotNull Entity pEntity) {
        LivingEntity living;
        boolean result = super.m_7327_(pEntity);
        if (result && pEntity == this.getBounty() && (living = (LivingEntity)pEntity).m_21224_()) {
            ServerPlayer issuer = this.getIssuer();
            if (issuer != null) {
                issuer.m_213846_((Component)Component.m_237110_((String)String.format("chat.%s.bounty_success", "jujutsu_kaisen"), (Object[])new Object[]{living.m_7755_()}));
            }
            this.clearBounty();
        }
        return result;
    }

    public void m_6667_(@NotNull DamageSource pDamageSource) {
        super.m_6667_(pDamageSource);
        this.stopTrading();
        ServerPlayer issuer = this.getIssuer();
        ServerPlayer bounty = this.getBounty();
        if (issuer != null && bounty != null) {
            issuer.m_213846_((Component)Component.m_237110_((String)String.format("chat.%s.bounty_fail", "jujutsu_kaisen"), (Object[])new Object[]{bounty.m_7755_()}));
        }
    }
}

