/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.network.packet.c2s;

import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraftforge.network.NetworkEvent;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.entity.base.ICommandable;
import radon.jujutsu_kaisen.network.PacketHandler;
import radon.jujutsu_kaisen.network.packet.s2c.SetOverlayMessageS2CPacket;

public class CommandableTargetC2SPacket {
    private final UUID target;

    public CommandableTargetC2SPacket(UUID target) {
        this.target = target;
    }

    public CommandableTargetC2SPacket(FriendlyByteBuf buf) {
        this(buf.m_130259_());
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130077_(this.target);
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            ServerPlayer sender = ctx.getSender();
            assert (sender != null);
            sender.getCapability(SorcererDataHandler.INSTANCE).ifPresent(cap -> {
                ServerLevel level = sender.m_284548_();
                LivingEntity target = (LivingEntity)level.m_8791_(this.target);
                if (target == null) {
                    return;
                }
                for (Entity entity : cap.getSummons()) {
                    TamableAnimal tamable;
                    if (!(entity instanceof ICommandable)) continue;
                    ICommandable commandable = (ICommandable)entity;
                    if (target == entity || target instanceof TamableAnimal && (tamable = (TamableAnimal)target).m_21824_() && tamable.m_269323_() == sender || !commandable.canChangeTarget()) continue;
                    commandable.changeTarget(target);
                    PacketHandler.sendToClient(new SetOverlayMessageS2CPacket((Component)Component.m_237110_((String)String.format("chat.%s.set_target", "jujutsu_kaisen"), (Object[])new Object[]{entity.m_7755_()}), false), sender);
                }
            });
        });
        ctx.setPacketHandled(true);
    }
}

