/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.ability.disaster_flames;

import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import radon.jujutsu_kaisen.ability.JJKAbilities;
import radon.jujutsu_kaisen.ability.MenuType;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.entity.effect.VolcanoEntity;
import radon.jujutsu_kaisen.util.HelperMethods;
import radon.jujutsu_kaisen.util.RotationUtil;

public class Volcano
extends Ability
implements Ability.IChannelened,
Ability.IDurationable {
    private static final double RANGE = 30.0;

    @Override
    public boolean shouldTrigger(PathfinderMob owner, @Nullable LivingEntity target) {
        if (JJKAbilities.isChanneling((LivingEntity)owner, this)) {
            return HelperMethods.RANDOM.m_188503_(5) != 0;
        }
        return HelperMethods.RANDOM.m_188503_(5) == 0 && target != null && owner.m_142582_((Entity)target);
    }

    @Override
    public Ability.ActivationType getActivationType(LivingEntity owner) {
        return Ability.ActivationType.CHANNELED;
    }

    @Override
    public void run(LivingEntity owner) {
        BlockHitResult hitter;
        owner.m_6674_(InteractionHand.MAIN_HAND);
        Vec3 start = owner.m_146892_();
        Vec3 look = RotationUtil.getTargetAdjustedLookAngle((Entity)owner);
        Vec3 end = start.m_82549_(look.m_82490_(30.0));
        HitResult result = RotationUtil.getHitResult((Entity)owner, start, end);
        if (result.m_6662_() == HitResult.Type.BLOCK && (hitter = this.getBlockHit(owner, 10.0)) != null) {
            Direction dir = hitter.m_82434_();
            VolcanoEntity volcano = new VolcanoEntity(owner, this.getPower(owner), hitter.m_82425_(), dir);
            owner.m_9236_().m_7967_((Entity)volcano);
        }
    }

    @Override
    public Ability.Status isTriggerable(LivingEntity owner) {
        return super.isTriggerable(owner);
    }

    @Override
    public float getCost(LivingEntity owner) {
        return 8.0f;
    }

    @Override
    public int getDuration() {
        return 2;
    }

    @Override
    public int getCooldown() {
        return 300;
    }

    @Override
    public MenuType getMenuType() {
        return MenuType.J2TSU;
    }

    @Override
    public Ability.Classification getClassification() {
        return Ability.Classification.FIRE;
    }
}

