/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.ability.disaster_plants;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;
import radon.jujutsu_kaisen.VeilHandler;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.ability.base.DomainExpansion;
import radon.jujutsu_kaisen.block.JJKBlocks;
import radon.jujutsu_kaisen.capability.data.sorcerer.ISorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.entity.ClosedDomainExpansionEntity;
import radon.jujutsu_kaisen.entity.base.DomainExpansionEntity;
import radon.jujutsu_kaisen.util.HelperMethods;

public class ShiningSeaOfFlowers
extends DomainExpansion
implements DomainExpansion.IClosedDomain {
    @Override
    public void onHitEntity(DomainExpansionEntity domain, LivingEntity owner, LivingEntity entity, boolean instant) {
        super.onHitEntity(domain, owner, entity, instant);
        entity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, Math.round(200.0f * ShiningSeaOfFlowers.getStrength(owner, instant)), 4, false, false, false));
        entity.m_7292_(new MobEffectInstance(MobEffects.f_19599_, Math.round(200.0f * ShiningSeaOfFlowers.getStrength(owner, instant)), 4, false, false, false));
        entity.m_7292_(new MobEffectInstance(MobEffects.f_19613_, Math.round(200.0f * ShiningSeaOfFlowers.getStrength(owner, instant)), 4, false, false, false));
    }

    @Override
    public boolean shouldTrigger(PathfinderMob owner, @Nullable LivingEntity target) {
        boolean enemyDomain = false;
        DomainExpansionEntity selfDomain = null;
        for (DomainExpansionEntity domain : VeilHandler.getDomains((ServerLevel)owner.m_9236_(), owner.m_20183_())) {
            if (domain.getOwner() == owner) {
                selfDomain = domain;
                continue;
            }
            if (domain.getOwner() == owner) continue;
            enemyDomain = true;
        }
        if (enemyDomain) {
            ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
            if (!cap.hasToggled(this)) {
                return true;
            }
            if (cap.hasToggled(this)) {
                return false;
            }
        } else if (selfDomain != null && !enemyDomain) {
            if (target != null) {
                return (double)selfDomain.m_20270_((Entity)target) >= 60.0;
            }
            if (target == null) {
                return HelperMethods.RANDOM.m_188503_(15) == 0;
            }
        }
        return target != null && (double)owner.m_20270_((Entity)target) <= 25.0 && owner.m_21223_() / owner.m_21233_() < 0.9f && HelperMethods.RANDOM.m_188503_(4) == 0;
    }

    @Override
    public void onHitBlock(DomainExpansionEntity domain, LivingEntity owner, BlockPos pos) {
    }

    @Override
    public Ability.ActivationType getActivationType(LivingEntity owner) {
        return Ability.ActivationType.DOMAIN;
    }

    @Override
    protected DomainExpansionEntity createBarrier(LivingEntity owner) {
        int radius = Math.round(this.getRadius(owner));
        ClosedDomainExpansionEntity domain = new ClosedDomainExpansionEntity(owner, this, radius);
        owner.m_9236_().m_7967_((Entity)domain);
        return domain;
    }

    @Override
    public List<Block> getBlocks() {
        return List.of((Block)JJKBlocks.FAKE_SKY.get());
    }

    @Override
    public List<Block> getFillBlocks() {
        return List.of((Block)JJKBlocks.SHINING_SEA_OF_FLOWERS_FILL.get());
    }

    @Override
    public List<Block> getFloorBlocks() {
        return List.of((Block)JJKBlocks.SHINING_SEA_OF_FLOWERS_FLOOR.get());
    }

    @Override
    public List<Block> getDecorationBlocks() {
        return List.of((Block)JJKBlocks.SHINING_SEA_OF_FLOWERS_DECORATION_ONE.get(), (Block)JJKBlocks.SHINING_SEA_OF_FLOWERS_DECORATION_TWO.get(), (Block)JJKBlocks.SHINING_SEA_OF_FLOWERS_DECORATION_THREE.get(), (Block)JJKBlocks.SHINING_SEA_OF_FLOWERS_DECORATION_FOUR.get());
    }

    @Override
    public boolean canPlaceFloor(ClosedDomainExpansionEntity domain, BlockPos pos) {
        return !domain.m_9236_().m_8055_(pos).m_60795_() && domain.m_9236_().m_8055_(pos.m_7494_()).m_60795_();
    }

    @Override
    public boolean canPlaceDecoration(ClosedDomainExpansionEntity domain, BlockPos pos) {
        return domain.m_9236_().m_8055_(pos.m_7495_()).m_60713_((Block)JJKBlocks.SHINING_SEA_OF_FLOWERS_FLOOR.get());
    }
}

