/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.ability.misc;

import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec2;
import org.jetbrains.annotations.Nullable;
import radon.jujutsu_kaisen.ability.AbilityHandler;
import radon.jujutsu_kaisen.ability.JJKAbilities;
import radon.jujutsu_kaisen.ability.MenuType;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.ability.base.DomainExpansion;
import radon.jujutsu_kaisen.capability.data.sorcerer.CursedTechnique;
import radon.jujutsu_kaisen.capability.data.sorcerer.ISorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.capability.data.sorcerer.Trait;
import radon.jujutsu_kaisen.config.ConfigHolder;
import radon.jujutsu_kaisen.entity.base.DomainExpansionEntity;
import radon.jujutsu_kaisen.sound.JJKSounds;

public class ZeroPointTwoSecondDomainExpansion
extends Ability {
    @Override
    public boolean isScalable(LivingEntity owner) {
        return false;
    }

    @Override
    public boolean isTechnique() {
        return false;
    }

    @Override
    public boolean shouldTrigger(PathfinderMob owner, @Nullable LivingEntity target) {
        return false;
    }

    @Override
    public Ability.ActivationType getActivationType(LivingEntity owner) {
        return Ability.ActivationType.INSTANT;
    }

    @Override
    public MenuType getMenuType() {
        return MenuType.DOMAIN;
    }

    @Override
    public boolean isDisplayed(LivingEntity owner) {
        ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        CursedTechnique technique = cap.getTechnique();
        return technique != null && technique.getDomain() != null && super.isDisplayed(owner);
    }

    @Override
    public boolean isValid(LivingEntity owner) {
        ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        CursedTechnique technique = cap.getTechnique();
        if (technique == null) {
            return false;
        }
        Ability domain = technique.getDomain();
        if (domain == null || cap.hasToggled(domain)) {
            return false;
        }
        return domain.isValid(owner) && super.isValid(owner);
    }

    @Override
    public Ability.Status isTriggerable(LivingEntity owner) {
        block6: {
            Ability ability;
            ISorcererData cap;
            CursedTechnique technique;
            block5: {
                if (!(owner instanceof Player)) break block5;
                Player player = (Player)owner;
                if (player.m_150110_().f_35937_) break block6;
            }
            if ((technique = (cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow()).getTechnique()) == null || !((ability = technique.getDomain()) instanceof DomainExpansion)) {
                return Ability.Status.FAILURE;
            }
            DomainExpansion ability2 = (DomainExpansion)ability;
            if (ability2.getStatus(owner) != Ability.Status.SUCCESS) {
                return Ability.Status.FAILURE;
            }
        }
        return super.isTriggerable(owner);
    }

    @Override
    public void run(LivingEntity owner) {
        block5: {
            DomainExpansion ability;
            ISorcererData cap;
            block6: {
                Ability ability2;
                if (owner.m_9236_().f_46443_) break block5;
                owner.m_9236_().m_6263_(null, owner.m_20185_(), owner.m_20186_(), owner.m_20189_(), (SoundEvent)JJKSounds.SPARK.get(), SoundSource.MASTER, 2.0f, 1.0f);
                cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
                CursedTechnique technique = cap.getTechnique();
                if (technique == null || !((ability2 = technique.getDomain()) instanceof DomainExpansion)) {
                    return;
                }
                ability = (DomainExpansion)ability2;
                AbilityHandler.trigger(owner, ability);
                DomainExpansionEntity domain = cap.getSummonByClass(DomainExpansionEntity.class);
                if (domain == null) {
                    return;
                }
                domain.setInstant(true);
                cap.delayTickEvent(() -> {
                    for (LivingEntity entity : domain.getAffected()) {
                        if (JJKAbilities.hasTrait(entity, Trait.HEAVENLY_RESTRICTION)) {
                            ability.onHitBlock(domain, owner, entity.m_20183_());
                            continue;
                        }
                        ability.onHitEntity(domain, owner, entity, true);
                    }
                    cap.delayTickEvent(() -> domain.m_146870_(), 10);
                }, 10);
                if (!(owner instanceof Player)) break block6;
                Player player = (Player)owner;
                if (player.m_150110_().f_35937_) break block5;
            }
            cap.addCooldown(ability);
        }
    }

    @Override
    public int getPointsCost() {
        return (Integer)ConfigHolder.SERVER.zeroPointTwoSecondDomainExpansionCost.get();
    }

    @Override
    @Nullable
    public Ability getParent(LivingEntity owner) {
        ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        CursedTechnique technique = cap.getTechnique();
        return technique == null || technique.getDomain() == null ? (Ability)JJKAbilities.SIMPLE_DOMAIN.get() : technique.getDomain();
    }

    @Override
    public Vec2 getDisplayCoordinates() {
        return new Vec2(4.0f, 0.0f);
    }

    @Override
    public float getCost(LivingEntity owner) {
        return 250.0f;
    }
}

