/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.ability.ten_shadows.ability;

import java.util.ArrayList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import radon.jujutsu_kaisen.ability.JJKAbilities;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.capability.data.ten_shadows.ITenShadowsData;
import radon.jujutsu_kaisen.capability.data.ten_shadows.TenShadowsDataHandler;
import radon.jujutsu_kaisen.capability.data.ten_shadows.TenShadowsMode;
import radon.jujutsu_kaisen.client.particle.LightningParticle;
import radon.jujutsu_kaisen.client.particle.ParticleColors;
import radon.jujutsu_kaisen.damage.JJKDamageSources;
import radon.jujutsu_kaisen.effect.JJKEffects;
import radon.jujutsu_kaisen.entity.JJKEntities;
import radon.jujutsu_kaisen.item.JJKItems;
import radon.jujutsu_kaisen.util.CuriosUtil;
import radon.jujutsu_kaisen.util.HelperMethods;

public class NueLightning
extends Ability
implements Ability.IToggled,
Ability.IAttack {
    private static final float DAMAGE = 3.5f;
    private static final int STUN = 7;

    @Override
    public boolean shouldTrigger(PathfinderMob owner, @Nullable LivingEntity target) {
        return target != null && !target.m_21224_() && (double)owner.m_20270_((Entity)target) < 20.0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isValid(LivingEntity owner) {
        if (!super.isValid(owner)) {
            return false;
        }
        ITenShadowsData cap = (ITenShadowsData)owner.getCapability(TenShadowsDataHandler.INSTANCE).resolve().orElseThrow();
        if (!(owner instanceof Player)) return true;
        Player player = (Player)owner;
        if (JJKAbilities.hasToggled(owner, (Ability)JJKAbilities.NUE.get())) return false;
        if (!cap.hasTamed(owner.m_9236_().m_9598_().m_175515_(Registries.f_256939_), (EntityType)JJKEntities.NUE.get())) return false;
        if (cap.getMode() != TenShadowsMode.ABILITY) return false;
        return true;
    }

    @Override
    public Ability.ActivationType getActivationType(LivingEntity owner) {
        return Ability.ActivationType.TOGGLED;
    }

    @Override
    public void run(LivingEntity owner) {
    }

    @Override
    public float getCost(LivingEntity owner) {
        ItemStack stack = owner.m_21120_(InteractionHand.MAIN_HAND);
        ArrayList<Item> stacks = new ArrayList<Item>();
        stacks.add(stack.m_41720_());
        stacks.addAll(CuriosUtil.findSlots(owner, owner.m_5737_() == HumanoidArm.RIGHT ? "right_hand" : "left_hand").stream().map(ItemStack::m_41720_).toList());
        if (stacks.contains(JJKItems.JET_BLACK_SHADOW_SWORD.get())) {
            return 10.0f;
        }
        return 15.0f;
    }

    @Override
    public Ability.Classification getClassification() {
        return Ability.Classification.LIGHTNING;
    }

    @Override
    public void onEnabled(LivingEntity owner) {
    }

    @Override
    public void onDisabled(LivingEntity owner) {
    }

    @Override
    public boolean attack(DamageSource source, LivingEntity owner, LivingEntity target) {
        if (owner.m_9236_().f_46443_) {
            return false;
        }
        if (!HelperMethods.isMelee(source)) {
            return false;
        }
        if (target.m_6469_((DamageSource)JJKDamageSources.jujutsuAttack(owner, (Ability)JJKAbilities.NUE_LIGHTNING.get()), 3.5f * Ability.getPower((Ability)JJKAbilities.NUE_LIGHTNING.get(), owner))) {
            target.m_7292_(new MobEffectInstance((MobEffect)JJKEffects.STUN.get(), 7, 0, false, false, false));
            owner.m_9236_().m_6263_(null, target.m_20185_(), target.m_20186_(), target.m_20189_(), SoundEvents.f_12089_, SoundSource.MASTER, 1.0f, 0.5f + HelperMethods.RANDOM.m_188501_() * 0.2f);
            for (int i = 0; i < 32; ++i) {
                double offsetX = HelperMethods.RANDOM.m_188583_() * 1.5;
                double offsetY = HelperMethods.RANDOM.m_188583_() * 1.5;
                double offsetZ = HelperMethods.RANDOM.m_188583_() * 1.5;
                ((ServerLevel)owner.m_9236_()).m_8767_((ParticleOptions)new LightningParticle.LightningParticleOptions(ParticleColors.PURPLE_LIGHTNING, 0.5f, 1), target.m_20185_() + offsetX, target.m_20186_() + offsetY, target.m_20189_() + offsetZ, 0, 0.0, 0.0, 0.0, 0.0);
            }
            return true;
        }
        return false;
    }
}

