/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.ability.ten_shadows.summon;

import java.util.List;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import org.jetbrains.annotations.Nullable;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.ability.base.Summon;
import radon.jujutsu_kaisen.entity.JJKEntities;
import radon.jujutsu_kaisen.entity.ten_shadows.RabbitEscapeEntity;

public class RabbitEscape
extends Summon<RabbitEscapeEntity> {
    private boolean triggered = false;

    public RabbitEscape() {
        super(RabbitEscapeEntity.class);
    }

    @Override
    public boolean isScalable(LivingEntity owner) {
        return false;
    }

    @Override
    public boolean shouldTrigger(PathfinderMob owner, @Nullable LivingEntity target) {
        return target != null && !target.m_21224_() && owner.f_19797_ - owner.m_21213_() < 20;
    }

    @Override
    public List<EntityType<?>> getTypes() {
        return List.of((EntityType)JJKEntities.RABBIT_ESCAPE.get());
    }

    @Override
    public void run(LivingEntity owner) {
        super.run(owner);
    }

    @Override
    public Ability.ActivationType getActivationType(LivingEntity owner) {
        return this.isTamed(owner) ? Ability.ActivationType.TOGGLED : Ability.ActivationType.INSTANT;
    }

    @Override
    protected RabbitEscapeEntity summon(LivingEntity owner) {
        return new RabbitEscapeEntity(owner, this.isTamed(owner));
    }

    @Override
    public boolean canDie() {
        return true;
    }

    @Override
    public boolean isTenShadows() {
        return true;
    }

    @Override
    protected boolean canTame() {
        return true;
    }

    @Override
    public boolean canDisable() {
        return false;
    }

    @Override
    public int getCooldown() {
        return 600;
    }

    @Override
    public float getCost(LivingEntity owner) {
        float normalcost = 0.2f;
        return this.isTamed(owner) ? normalcost : 10.0f;
    }

    @Override
    public void onEnabled(LivingEntity owner) {
        if (!this.triggered) {
            this.triggered = true;
            owner.m_7292_(new MobEffectInstance(MobEffects.f_19609_, 200, 0, false, false, false));
        }
        super.onEnabled(owner);
    }

    @Override
    public void onDisabled(LivingEntity owner) {
        this.triggered = false;
        super.onDisabled(owner);
    }
}

