/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.block.entity;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import radon.jujutsu_kaisen.VeilHandler;
import radon.jujutsu_kaisen.block.JJKBlocks;
import radon.jujutsu_kaisen.block.VeilBlock;
import radon.jujutsu_kaisen.block.domain.DomainAirBlock;
import radon.jujutsu_kaisen.block.domain.DomainBlock;
import radon.jujutsu_kaisen.block.entity.JJKBlockEntities;
import radon.jujutsu_kaisen.block.entity.VeilBlockEntity;
import radon.jujutsu_kaisen.config.ConfigHolder;
import radon.jujutsu_kaisen.item.veil.modifier.ColorModifier;
import radon.jujutsu_kaisen.item.veil.modifier.Modifier;
import radon.jujutsu_kaisen.item.veil.modifier.ModifierUtils;

public class VeilRodBlockEntity
extends BlockEntity {
    public static final int RANGE = 128;
    public static final int INTERVAL = 2;
    private static final float COST = 0.1f;
    private int blockCursor;
    private int counter;
    private int size;
    private float experience;
    private float storedEnergy;
    public List<Modifier> modifiers;
    @Nullable
    public UUID ownerUUID;

    public VeilRodBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)JJKBlockEntities.VEIL_ROD.get(), pPos, pBlockState);
        this.size = (Integer)ConfigHolder.SERVER.minimumVeilSize.get();
        this.modifiers = new ArrayList<Modifier>();
        this.blockCursor = 0;
        this.storedEnergy = 0.0f;
    }

    public boolean isValid() {
        Level level = this.f_58857_;
        if (!(level instanceof ServerLevel)) {
            return false;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        return this.ownerUUID != null;
    }

    public static void tick(Level level, BlockPos pos, BlockState state, VeilRodBlockEntity rod) {
        if (VeilHandler.checkIntersect(level, rod.m_58899_(), rod.getSize())) {
            return;
        }
        VeilHandler.addVeil(rod);
        if (++rod.counter < 2) {
            return;
        }
        rod.counter = 0;
        if (!rod.isValid()) {
            return;
        }
        if (rod.ownerUUID == null) {
            return;
        }
        BlockState replacement = ((Block)JJKBlocks.VEIL.get()).m_49966_();
        for (Modifier mod : rod.modifiers) {
            if (mod.getType() == Modifier.Type.COLOR) {
                replacement = (BlockState)replacement.m_61124_(VeilBlock.COLOR, (Comparable)((ColorModifier)mod).getColor());
                continue;
            }
            if (mod.getType() != Modifier.Type.TRANSPARENT) continue;
            replacement = (BlockState)replacement.m_61124_((Property)VeilBlock.TRANSPARENT, (Comparable)Boolean.valueOf(true));
        }
        int size = rod.getSize();
        int s = size * 2 + 1;
        int totalBlocks = s * s * s;
        if (rod.blockCursor >= totalBlocks) {
            rod.blockCursor = 0;
        }
        int yLayer = size - rod.blockCursor / (s * s);
        for (int xIndex = 0; xIndex < s; ++xIndex) {
            for (int zIndex = 0; zIndex < s; ++zIndex) {
                BlockState blockState;
                int x = xIndex - size;
                int z = zIndex - size;
                int y = yLayer;
                double distSqr = x * x + y * y + z * z;
                double minSqr = ((double)size - 0.5) * ((double)size - 0.5);
                double maxSqr = ((double)size + 0.5) * ((double)size + 0.5);
                if (distSqr < minSqr || distSqr > maxSqr) continue;
                BlockPos targetPos = pos.m_7918_(x, y, z);
                BlockState targetState = level.m_8055_(targetPos);
                BlockEntity existingBE = level.m_7702_(targetPos);
                if (existingBE instanceof VeilBlockEntity) {
                    VeilBlockEntity ve = (VeilBlockEntity)existingBE;
                    blockState = ve.getOriginal();
                } else {
                    blockState = targetState;
                }
                BlockState currentState = blockState;
                Block b = targetState.m_60734_();
                if (b instanceof DomainBlock || b instanceof DomainAirBlock || b instanceof VeilBlock) continue;
                CompoundTag saved = null;
                if (existingBE != null) {
                    saved = existingBE.m_187480_();
                    if (existingBE instanceof Container) {
                        Container container = (Container)existingBE;
                        container.m_6211_();
                        level.m_46747_(targetPos);
                    }
                }
                level.m_46597_(targetPos, replacement);
                BlockEntity blockEntity = level.m_7702_(targetPos);
                if (!(blockEntity instanceof VeilBlockEntity)) continue;
                VeilBlockEntity be = (VeilBlockEntity)blockEntity;
                be.create(pos, size, currentState, saved);
            }
        }
        rod.blockCursor += s * s;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        if (!this.f_58857_.f_46443_) {
            VeilHandler.removeVeil(this);
        }
        this.size = size;
        this.m_6596_();
    }

    public void setExperience(float experience) {
        this.experience = experience;
        this.m_6596_();
    }

    public float getExperience() {
        return this.experience;
    }

    public void setOwner(UUID ownerUUID) {
        this.ownerUUID = ownerUUID;
        this.m_6596_();
    }

    public void m_7651_() {
        BlockState state;
        if (!this.f_58857_.f_46443_ && !(state = this.f_58857_.m_8055_(this.m_58899_())).m_60734_().equals(JJKBlocks.VEIL_ROD.get())) {
            VeilHandler.removeVeil(this);
        }
        super.m_7651_();
    }

    public void onLoad() {
        Level level;
        super.onLoad();
        if (!this.f_58857_.f_46443_ && (level = this.f_58857_) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_7654_().execute(() -> {
                if (!this.m_58901_() && this.ownerUUID != null) {
                    VeilHandler.addVeil(this);
                }
            });
        }
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @NotNull
    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    protected void m_183515_(@NotNull CompoundTag pTag) {
        super.m_183515_(pTag);
        if (this.ownerUUID != null) {
            pTag.m_128362_("owner", this.ownerUUID);
        }
        pTag.m_128405_("counter", this.counter);
        pTag.m_128405_("size", this.size);
        pTag.m_128350_("experience", this.experience);
        pTag.m_128350_("storedEnergy", this.storedEnergy);
        if (this.modifiers != null) {
            pTag.m_128365_("modifiers", (Tag)ModifierUtils.serialize(this.modifiers));
        }
    }

    public void m_142466_(@NotNull CompoundTag pTag) {
        super.m_142466_(pTag);
        if (pTag.m_128441_("owner")) {
            this.ownerUUID = pTag.m_128342_("owner");
        }
        this.counter = pTag.m_128451_("counter");
        this.size = pTag.m_128451_("size");
        this.experience = pTag.m_128457_("experience");
        this.storedEnergy = pTag.m_128457_("storedEnergy");
        if (pTag.m_128441_("modifiers")) {
            this.modifiers = ModifierUtils.deserialize(pTag.m_128437_("modifiers", 10));
        }
    }
}

