/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.client.gui.screen;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;
import radon.jujutsu_kaisen.ability.AbilityHandler;
import radon.jujutsu_kaisen.ability.JJKAbilities;
import radon.jujutsu_kaisen.ability.MenuType;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.capability.data.sorcerer.AbsorbedCurse;
import radon.jujutsu_kaisen.capability.data.sorcerer.CursedTechnique;
import radon.jujutsu_kaisen.capability.data.sorcerer.ISorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.client.JJKKeys;
import radon.jujutsu_kaisen.client.gui.screen.DisplayItem;
import radon.jujutsu_kaisen.client.gui.screen.base.RadialScreen;
import radon.jujutsu_kaisen.network.PacketHandler;
import radon.jujutsu_kaisen.network.packet.c2s.CurseSummonC2SPacket;
import radon.jujutsu_kaisen.network.packet.c2s.SetAbsorbedC2SPacket;
import radon.jujutsu_kaisen.network.packet.c2s.SetAdditionalC2SPacket;
import radon.jujutsu_kaisen.network.packet.c2s.SetStolenC2SPacket;
import radon.jujutsu_kaisen.network.packet.c2s.TriggerAbilityC2SPacket;
import radon.jujutsu_kaisen.network.packet.c2s.UntriggerAbilityC2SPacket;

public class AbilityScreen
extends RadialScreen {
    @Override
    protected List<DisplayItem> getItems() {
        if (this.f_96541_ == null || this.f_96541_.f_91073_ == null || this.f_96541_.f_91074_ == null) {
            return List.of();
        }
        if (!this.f_96541_.f_91074_.getCapability(SorcererDataHandler.INSTANCE).isPresent()) {
            return List.of();
        }
        ISorcererData cap = (ISorcererData)this.f_96541_.f_91074_.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        List<Ability> abilities = JJKAbilities.getAbilities((LivingEntity)this.f_96541_.f_91074_);
        abilities.removeIf(ability -> ability.getMenuType() != MenuType.RADIAL);
        ArrayList<DisplayItem> items = new ArrayList<DisplayItem>(abilities.stream().map(DisplayItem::new).toList());
        ArrayList<AbsorbedCurse> curses = new ArrayList<AbsorbedCurse>(cap.getCurses());
        curses.sort((o1, o2) -> (int)(JJKAbilities.getCurseExperience(o2) - JJKAbilities.getCurseExperience(o1)));
        items.addAll(curses.stream().map(curse -> new DisplayItem((AbsorbedCurse)curse, curses.indexOf(curse))).toList());
        Set<CursedTechnique> copied = cap.getCopied();
        items.addAll(copied.stream().map(technique -> new DisplayItem(DisplayItem.Type.COPIED, (CursedTechnique)((Object)technique))).toList());
        Set<CursedTechnique> absorbed = cap.getAbsorbed();
        items.addAll(absorbed.stream().map(technique -> new DisplayItem(DisplayItem.Type.ABSORBED, (CursedTechnique)((Object)technique))).toList());
        Set<CursedTechnique> stolen = cap.getStolen();
        items.addAll(stolen.stream().map(technique -> new DisplayItem(DisplayItem.Type.STOLEN, (CursedTechnique)((Object)technique))).toList());
        return items;
    }

    public void m_7379_() {
        super.m_7379_();
        if (this.hovered != -1) {
            if (this.f_96541_ == null || this.f_96541_.f_91073_ == null || this.f_96541_.f_91074_ == null) {
                return;
            }
            ISorcererData cap = (ISorcererData)this.f_96541_.f_91074_.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
            DisplayItem item = this.getCurrent().get(this.hovered);
            switch (item.type) {
                case ABILITY: {
                    Ability ability = item.ability;
                    if (cap.hasToggled(ability) || cap.isChanneling(ability)) {
                        AbilityHandler.untrigger((LivingEntity)this.f_96541_.f_91074_, ability);
                        PacketHandler.sendToServer(new UntriggerAbilityC2SPacket(JJKAbilities.getKey(ability)));
                        break;
                    }
                    PacketHandler.sendToServer(new TriggerAbilityC2SPacket(JJKAbilities.getKey(ability)));
                    break;
                }
                case CURSE: {
                    PacketHandler.sendToServer(new CurseSummonC2SPacket(item.curse.getKey().getUUID()));
                    break;
                }
                case COPIED: {
                    PacketHandler.sendToServer(new SetAdditionalC2SPacket(item.copied));
                    cap.setCurrentCopied(item.copied);
                    break;
                }
                case ABSORBED: {
                    cap.setCurrentAbsorbed(item.absorbed);
                    PacketHandler.sendToServer(new SetAbsorbedC2SPacket(item.absorbed));
                    break;
                }
                case STOLEN: {
                    cap.setCurrentStolen(item.stolen);
                    PacketHandler.sendToServer(new SetStolenC2SPacket(item.stolen));
                }
            }
        }
    }

    @Override
    public void m_88315_(@NotNull GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTicks) {
        super.m_88315_(pGuiGraphics, pMouseX, pMouseY, pPartialTicks);
        if (this.f_96541_ == null || this.f_96541_.f_91074_ == null) {
            return;
        }
        if (!this.f_96541_.f_91074_.getCapability(SorcererDataHandler.INSTANCE).isPresent()) {
            return;
        }
        ISorcererData cap = (ISorcererData)this.f_96541_.f_91074_.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        if (!cap.hasTechnique(CursedTechnique.MIMICRY)) {
            return;
        }
        int centerX = this.f_96543_ / 2;
        int centerY = this.f_96544_ / 2;
        int x = centerX;
        Objects.requireNonNull(this.f_96547_);
        int y = centerY - 100 - 9 * 2;
        pGuiGraphics.m_280653_(this.f_96547_, (Component)Component.m_237115_((String)String.format("gui.%s.ability.right_click", "jujutsu_kaisen")), x, y, 0xFFFFFF);
    }

    public boolean m_7920_(int pKeyCode, int pScanCode, int pModifiers) {
        if (pKeyCode == JJKKeys.SHOW_ABILITY_MENU.getKey().m_84873_()) {
            this.m_7379_();
        }
        return super.m_7920_(pKeyCode, pScanCode, pModifiers);
    }
}

