/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.client.render.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import radon.jujutsu_kaisen.block.entity.DomainSkyBlockEntity;
import radon.jujutsu_kaisen.client.JJKRenderTypes;
import radon.jujutsu_kaisen.client.render.domain.DomainRenderDispatcher;

public class DomainSkyBlockRenderer
implements BlockEntityRenderer<DomainSkyBlockEntity> {
    public void render(@NotNull DomainSkyBlockEntity pBlockEntity, float pPartialTick, @NotNull PoseStack pPoseStack, @NotNull MultiBufferSource pBuffer, int pPackedLight, int pPackedOverlay) {
        ResourceLocation domain = pBlockEntity.getDomain();
        if (domain == null) {
            return;
        }
        Matrix4f matrix4f = pPoseStack.m_85850_().m_252922_();
        DomainSkyBlockRenderer.renderCube(matrix4f, pBuffer.m_6299_(DomainSkyBlockRenderer.renderType(domain)));
    }

    private static void renderCube(Matrix4f pPose, VertexConsumer pConsumer) {
        DomainSkyBlockRenderer.renderFace(pPose, pConsumer, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
        DomainSkyBlockRenderer.renderFace(pPose, pConsumer, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        DomainSkyBlockRenderer.renderFace(pPose, pConsumer, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f);
        DomainSkyBlockRenderer.renderFace(pPose, pConsumer, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f);
        DomainSkyBlockRenderer.renderFace(pPose, pConsumer, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f);
        DomainSkyBlockRenderer.renderFace(pPose, pConsumer, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f);
    }

    private static void renderFace(Matrix4f pPose, VertexConsumer pConsumer, float pX0, float pX1, float pY0, float pY1, float pZ0, float pZ1, float pZ2, float pZ3) {
        pConsumer.m_252986_(pPose, pX0, pY0, pZ0).m_5752_();
        pConsumer.m_252986_(pPose, pX1, pY0, pZ1).m_5752_();
        pConsumer.m_252986_(pPose, pX1, pY1, pZ2).m_5752_();
        pConsumer.m_252986_(pPose, pX0, pY1, pZ3).m_5752_();
    }

    private static RenderType renderType(ResourceLocation domain) {
        return JJKRenderTypes.skybox(DomainRenderDispatcher.get(domain));
    }

    public boolean shouldRender(@NotNull DomainSkyBlockEntity blockEntity, @NotNull Vec3 cameraPos) {
        return Vec3.m_82512_((Vec3i)blockEntity.m_58899_()).m_82509_((Position)cameraPos, (double)this.m_142163_() * 2.0);
    }
}

