/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.client.render.domain;

import com.mojang.blaze3d.pipeline.TextureTarget;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import radon.jujutsu_kaisen.ability.JJKAbilities;
import radon.jujutsu_kaisen.client.render.domain.DefaultDomainRenderer;
import radon.jujutsu_kaisen.client.render.domain.DomainRenderLayer;
import radon.jujutsu_kaisen.client.render.domain.DomainRenderer;
import radon.jujutsu_kaisen.client.render.domain.SelfEmbodimentOfPerfectionDomainRenderer;
import radon.jujutsu_kaisen.client.render.domain.TimeCellMoonPalaceDomainRenderer;
import radon.jujutsu_kaisen.client.render.domain.UnlimitedVoidRenderer;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="jujutsu_kaisen", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class DomainRenderDispatcher {
    private static final Map<ResourceLocation, DomainRenderer> renderers = new HashMap<ResourceLocation, DomainRenderer>();
    private static final Map<ResourceLocation, TextureTarget> cached = new HashMap<ResourceLocation, TextureTarget>();
    private static final DomainRenderer DEFAULT_RENDERER;
    @Nullable
    private static TextureTarget fallback;
    private static int skyWidth;
    private static int skyHeight;

    public static TextureTarget get(ResourceLocation domain) {
        if (!cached.containsKey(domain)) {
            return fallback;
        }
        return cached.get(domain);
    }

    private static TextureTarget update(@Nullable TextureTarget target, DomainRenderer renderer, Matrix4f modelViewMatrix, Matrix4f projectionMatrix, boolean update) {
        Minecraft mc = Minecraft.m_91087_();
        if (target == null || update) {
            if (target != null) {
                target.m_83930_();
            }
            target = new TextureTarget(skyWidth, skyHeight, true, Minecraft.f_91002_);
        }
        target.m_83954_(Minecraft.f_91002_);
        target.m_83947_(true);
        DomainRenderDispatcher.render(renderer, modelViewMatrix, projectionMatrix);
        target.m_83963_();
        target.m_83970_();
        mc.m_91385_().m_83947_(true);
        return target;
    }

    @SubscribeEvent
    public static void onRenderLevelStage(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_LEVEL) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        Window window = mc.m_91268_();
        int ww = window.m_85441_();
        int wh = window.m_85442_();
        if (ww <= 0 || wh <= 0) {
            return;
        }
        boolean update = false;
        if (skyWidth != ww || skyHeight != wh) {
            update = true;
            skyWidth = ww;
            skyHeight = wh;
        }
        Matrix4f modelViewMatrix = new Matrix4f((Matrix3fc)RenderSystem.getInverseViewRotationMatrix()).invert();
        Matrix4f projectionMatrix = event.getProjectionMatrix();
        for (Map.Entry<ResourceLocation, DomainRenderer> entry : renderers.entrySet()) {
            ResourceLocation key = entry.getKey();
            DomainRenderer renderer = entry.getValue();
            TextureTarget target = cached.get(key);
            TextureTarget updated = DomainRenderDispatcher.update(target, renderer, modelViewMatrix, projectionMatrix, update);
            cached.put(key, updated);
        }
        fallback = DomainRenderDispatcher.update(fallback, DEFAULT_RENDERER, modelViewMatrix, projectionMatrix, update);
    }

    public static void render(DomainRenderer renderer, Matrix4f modelViewMatrix, Matrix4f projectionMatrix) {
        RenderSystem.enableBlend();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)renderer.getTexture());
        RenderSystem.setShader(GameRenderer::m_172817_);
        renderer.render(modelViewMatrix, projectionMatrix);
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        for (DomainRenderLayer layer : renderer.getLayers()) {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)layer.getTexture());
            renderer.render(modelViewMatrix, projectionMatrix);
        }
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableBlend();
    }

    static {
        renderers.put(JJKAbilities.UNLIMITED_VOID.getId(), new UnlimitedVoidRenderer());
        renderers.put(JJKAbilities.TIME_CELL_MOON_PALACE.getId(), new TimeCellMoonPalaceDomainRenderer());
        renderers.put(JJKAbilities.SELF_EMBODIMENT_OF_PERFECTION.getId(), new SelfEmbodimentOfPerfectionDomainRenderer());
        DEFAULT_RENDERER = new DefaultDomainRenderer();
    }
}

