/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.client.render.entity.effect;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import radon.jujutsu_kaisen.client.JJKRenderTypes;
import radon.jujutsu_kaisen.client.particle.ParticleColors;
import radon.jujutsu_kaisen.entity.effect.ElectricBeamEntity;

public class ElectricBeamRenderer
extends EntityRenderer<ElectricBeamEntity> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("jujutsu_kaisen", "textures/entity/cursed_energy_bomb.png");
    private static final int TEXTURE_WIDTH = 128;
    private static final int TEXTURE_HEIGHT = 32;
    private static final float START_RADIUS = 1.3f;
    private static final float BEAM_RADIUS = 1.0f;
    private boolean clearerView = false;

    public ElectricBeamRenderer(EntityRendererProvider.Context pContext) {
        super(pContext);
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull ElectricBeamEntity pEntity) {
        return TEXTURE;
    }

    public void render(ElectricBeamEntity pEntity, float pEntityYaw, float pPartialTick, @NotNull PoseStack pPoseStack, @NotNull MultiBufferSource pBuffer, int pPackedLight) {
        Entity entity = pEntity.m_19749_();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity owner = (LivingEntity)entity;
        Vector3f color = ParticleColors.getCursedEnergyColor((Entity)owner);
        this.clearerView = owner instanceof Player && Minecraft.m_91087_().f_91074_ == owner && Minecraft.m_91087_().f_91066_.m_92176_() == CameraType.FIRST_PERSON;
        double collidePosX = pEntity.prevCollidePosX + (pEntity.collidePosX - pEntity.prevCollidePosX) * (double)pPartialTick;
        double collidePosY = pEntity.prevCollidePosY + (pEntity.collidePosY - pEntity.prevCollidePosY) * (double)pPartialTick;
        double collidePosZ = pEntity.prevCollidePosZ + (pEntity.collidePosZ - pEntity.prevCollidePosZ) * (double)pPartialTick;
        double posX = pEntity.f_19854_ + (pEntity.m_20185_() - pEntity.f_19854_) * (double)pPartialTick;
        double posY = pEntity.f_19855_ + (pEntity.m_20186_() - pEntity.f_19855_) * (double)pPartialTick;
        double posZ = pEntity.f_19856_ + (pEntity.m_20189_() - pEntity.f_19856_) * (double)pPartialTick;
        float yaw = pEntity.prevYaw + (pEntity.renderYaw - pEntity.prevYaw) * pPartialTick;
        float pitch = pEntity.prevPitch + (pEntity.renderPitch - pEntity.prevPitch) * pPartialTick;
        float length = (float)Math.sqrt(Math.pow(collidePosX - posX, 2.0) + Math.pow(collidePosY - posY, 2.0) + Math.pow(collidePosZ - posZ, 2.0));
        int frame = Mth.m_14143_((float)(((float)(pEntity.animation - 1) + pPartialTick) * 2.0f));
        if (frame < 0) {
            frame = pEntity.getFrames() * 2;
        }
        pPoseStack.m_85836_();
        pPoseStack.m_85841_(pEntity.getScale(), pEntity.getScale(), pEntity.getScale());
        pPoseStack.m_252880_(0.0f, pEntity.m_20206_() / 2.0f, 0.0f);
        VertexConsumer consumer = pBuffer.m_6299_(JJKRenderTypes.glow(this.getTextureLocation(pEntity)));
        this.renderStart(frame, pPoseStack, consumer, color, pPackedLight);
        if (pEntity.getTime() > pEntity.getCharge()) {
            this.renderBeam(length, 57.295776f * yaw, 57.295776f * pitch, frame, pPoseStack, consumer, color, pPackedLight);
            pPoseStack.m_85836_();
            pPoseStack.m_85837_(collidePosX - posX, collidePosY - posY, collidePosZ - posZ);
            this.renderEnd(frame, pEntity.side, pPoseStack, consumer, color, pPackedLight);
            pPoseStack.m_85849_();
        }
        pPoseStack.m_85849_();
    }

    private void renderFlatQuad(int frame, PoseStack poseStack, VertexConsumer consumer, Vector3f color, int packedLight) {
        float minU = 0.125f * (float)frame;
        float minV = 0.0f;
        float maxU = minU + 0.125f;
        float maxV = minV + 0.5f;
        PoseStack.Pose pose = poseStack.m_85850_();
        Matrix4f matrix4f = pose.m_252922_();
        Matrix3f matrix3f = pose.m_252943_();
        this.drawVertex(matrix4f, matrix3f, consumer, -1.3f, -1.3f, 0.0f, color, minU, minV, 1.0f, packedLight);
        this.drawVertex(matrix4f, matrix3f, consumer, -1.3f, 1.3f, 0.0f, color, minU, maxV, 1.0f, packedLight);
        this.drawVertex(matrix4f, matrix3f, consumer, 1.3f, 1.3f, 0.0f, color, maxU, maxV, 1.0f, packedLight);
        this.drawVertex(matrix4f, matrix3f, consumer, 1.3f, -1.3f, 0.0f, color, maxU, minV, 1.0f, packedLight);
    }

    private void renderStart(int frame, PoseStack poseStack, VertexConsumer consumer, Vector3f color, int packedLight) {
        if (this.clearerView) {
            return;
        }
        poseStack.m_85836_();
        poseStack.m_252781_(this.f_114476_.m_253208_());
        this.renderFlatQuad(frame, poseStack, consumer, color, packedLight);
        poseStack.m_85849_();
    }

    private void renderEnd(int frame, Direction side, PoseStack poseStack, VertexConsumer consumer, Vector3f color, int packedLight) {
        poseStack.m_85836_();
        poseStack.m_252781_(this.f_114476_.m_253208_());
        this.renderFlatQuad(frame, poseStack, consumer, color, packedLight);
        poseStack.m_85849_();
        if (side == null) {
            return;
        }
        poseStack.m_85836_();
        poseStack.m_252781_(side.m_253075_().mul((Quaternionfc)Axis.f_252529_.m_252977_(90.0f)));
        poseStack.m_252880_(0.0f, 0.0f, -0.01f);
        this.renderFlatQuad(frame, poseStack, consumer, color, packedLight);
        poseStack.m_85849_();
    }

    private void drawBeam(float length, int frame, PoseStack poseStack, VertexConsumer consumer, Vector3f color, int packedLight) {
        float minU = 0.0f;
        float minV = 0.5f + 0.03125f * (float)frame;
        float maxU = minU + 0.15625f;
        float maxV = minV + 0.03125f;
        PoseStack.Pose pose = poseStack.m_85850_();
        Matrix4f matrix4f = pose.m_252922_();
        Matrix3f matrix3f = pose.m_252943_();
        float offset = this.clearerView ? -1.0f : 0.0f;
        this.drawVertex(matrix4f, matrix3f, consumer, -1.0f, offset, 0.0f, color, minU, minV, 1.0f, packedLight);
        this.drawVertex(matrix4f, matrix3f, consumer, -1.0f, length, 0.0f, color, minU, maxV, 1.0f, packedLight);
        this.drawVertex(matrix4f, matrix3f, consumer, 1.0f, length, 0.0f, color, maxU, maxV, 1.0f, packedLight);
        this.drawVertex(matrix4f, matrix3f, consumer, 1.0f, offset, 0.0f, color, maxU, minV, 1.0f, packedLight);
    }

    private void renderBeam(float length, float yaw, float pitch, int frame, PoseStack poseStack, VertexConsumer consumer, Vector3f color, int packedLight) {
        poseStack.m_85836_();
        poseStack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
        poseStack.m_252781_(Axis.f_252403_.m_252977_(yaw - 90.0f));
        poseStack.m_252781_(Axis.f_252495_.m_252977_(pitch));
        poseStack.m_85836_();
        poseStack.m_252781_(Axis.f_252436_.m_252977_(Minecraft.m_91087_().f_91063_.m_109153_().m_90589_() + 90.0f));
        this.drawBeam(length, frame, poseStack, consumer, color, packedLight);
        poseStack.m_85849_();
        poseStack.m_85836_();
        poseStack.m_252781_(Axis.f_252392_.m_252977_(Minecraft.m_91087_().f_91063_.m_109153_().m_90589_() - 90.0f));
        this.drawBeam(length, frame, poseStack, consumer, color, packedLight);
        poseStack.m_85849_();
        poseStack.m_85849_();
    }

    public void drawVertex(Matrix4f matrix4f, Matrix3f matrix3f, VertexConsumer consumer, float x, float y, float z, Vector3f color, float u, float v, float alpha, int packedLight) {
        consumer.m_252986_(matrix4f, x, y, z).m_85950_(color.x, color.y, color.z, alpha).m_7421_(u, v).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
    }
}

