/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.server.command.EnumArgument;
import radon.jujutsu_kaisen.capability.data.sorcerer.ISorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.Pact;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.network.PacketHandler;
import radon.jujutsu_kaisen.network.packet.s2c.SyncSorcererDataS2CPacket;

public class PactRemovalAcceptCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralCommandNode node = dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"pactremovalaccept").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91449_()).then(Commands.m_82129_((String)"pact", (ArgumentType)EnumArgument.enumArgument(Pact.class)).executes(ctx -> PactRemovalAcceptCommand.accept((CommandSourceStack)ctx.getSource(), EntityArgument.m_91474_((CommandContext)ctx, (String)"player"), (Pact)((Object)((Object)ctx.getArgument("pact", Pact.class))))))));
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"pactremovalaccept").redirect((CommandNode)node));
    }

    public static int accept(CommandSourceStack stack, ServerPlayer dst, Pact pact) {
        ServerPlayer src = stack.m_230896_();
        if (src == null) {
            return 0;
        }
        ISorcererData dstCap = (ISorcererData)dst.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        ISorcererData srcCap = (ISorcererData)src.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        if (!dstCap.hasRequestedPactRemoval(src.m_20148_(), pact)) {
            src.m_213846_((Component)Component.m_237110_((String)String.format("chat.%s.pact_failure_remove", "jujutsu_kaisen"), (Object[])new Object[]{dst.m_7755_(), pact.getName().getString().toLowerCase()}));
            return 0;
        }
        dstCap.removePact(src.m_20148_(), pact);
        srcCap.removePact(dst.m_20148_(), pact);
        dstCap.removePactRemovalRequest(src.m_20148_(), pact);
        PacketHandler.sendToClient(new SyncSorcererDataS2CPacket(dstCap.serializeNBT()), dst);
        PacketHandler.sendToClient(new SyncSorcererDataS2CPacket(srcCap.serializeNBT()), src);
        src.m_213846_((Component)Component.m_237110_((String)String.format("chat.%s.pact_accept_remove", "jujutsu_kaisen"), (Object[])new Object[]{pact.getName().getString().toLowerCase(), dst.m_7755_()}));
        dst.m_213846_((Component)Component.m_237110_((String)String.format("chat.%s.pact_accept_remove", "jujutsu_kaisen"), (Object[])new Object[]{pact.getName().getString().toLowerCase(), src.m_7755_()}));
        return 1;
    }
}

