/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.entity;

import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import radon.jujutsu_kaisen.ExplosionHandler;
import radon.jujutsu_kaisen.ability.JJKAbilities;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.damage.JJKDamageSources;
import radon.jujutsu_kaisen.entity.JJKEntities;
import radon.jujutsu_kaisen.entity.projectile.base.JujutsuProjectile;
import radon.jujutsu_kaisen.sound.JJKSounds;

public class HollowPurpleExplosion
extends JujutsuProjectile {
    public static final int DURATION = 60;
    private static final float RADIUS = 8.0f;
    private static final float MAX_EXPLOSION = 30.0f;
    private boolean exploded;

    public HollowPurpleExplosion(EntityType<? extends Projectile> pType, Level pLevel) {
        super(pType, pLevel);
        this.f_19811_ = true;
    }

    public HollowPurpleExplosion(LivingEntity owner, float power, Vec3 pos) {
        this((EntityType<? extends Projectile>)((EntityType)JJKEntities.HOLLOW_PURPLE_EXPLOSION.get()), owner.m_9236_());
        this.m_5602_((Entity)owner);
        this.setPower(power);
        float radius = 8.0f * this.getPower();
        this.m_146884_(pos);
    }

    @NotNull
    public Vec3 m_20184_() {
        return Vec3.f_82478_;
    }

    @NotNull
    public EntityDimensions m_6972_(@NotNull Pose pPose) {
        float radius = 8.0f * this.getPower();
        return EntityDimensions.m_20398_((float)0.1f, (float)0.1f);
    }

    public boolean m_6087_() {
        return false;
    }

    public boolean m_6094_() {
        return false;
    }

    public boolean m_5829_() {
        return false;
    }

    public void m_7334_(Entity entity) {
    }

    @Override
    public boolean canDeflect() {
        return false;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.f_19797_ == 1) {
            this.m_6210_();
        }
        if (this.m_9236_().f_46443_) {
            return;
        }
        if (this.getTime() >= 60) {
            this.m_146870_();
            return;
        }
        if (this.getTime() - 1 == 0) {
            Entity entity = this.m_19749_();
            if (!(entity instanceof LivingEntity)) {
                return;
            }
            LivingEntity owner = (LivingEntity)entity;
            this.m_5496_((SoundEvent)JJKSounds.HOLLOW_PURPLE_EXPLOSION.get(), 3.0f, 1.0f);
            float radius = Math.min(30.0f, 8.0f * this.getPower());
            int duration = (int)(radius / 5.0f * 20.0f);
            ExplosionHandler.spawn((ResourceKey<Level>)this.m_9236_().m_46472_(), this.m_20182_().m_82520_(0.0, (double)(this.m_20206_() / 2.0f), 0.0), radius, 60, this.getPower() * 0.4f, owner, JJKDamageSources.indirectJujutsuAttack((Entity)this, owner, (Ability)JJKAbilities.HOLLOW_PURPLE.get()), false);
        }
    }
}

