/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.entity;

import com.mojang.authlib.GameProfile;
import java.util.Arrays;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import radon.jujutsu_kaisen.capability.data.sorcerer.CursedTechnique;
import radon.jujutsu_kaisen.capability.data.sorcerer.ISorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.JujutsuType;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererGrade;
import radon.jujutsu_kaisen.entity.JJKEntities;
import radon.jujutsu_kaisen.entity.JJKEntityDataSerializers;
import radon.jujutsu_kaisen.entity.ai.goal.NearestAttackableCurseGoal;
import radon.jujutsu_kaisen.entity.ai.goal.NearestAttackableSorcererGoal;
import radon.jujutsu_kaisen.entity.ai.goal.SorcererGoal;
import radon.jujutsu_kaisen.entity.ai.goal.WaterWalkingFloatGoal;
import radon.jujutsu_kaisen.entity.base.ISorcerer;
import radon.jujutsu_kaisen.util.HelperMethods;

public class LimboCloneEntity
extends PathfinderMob
implements ISorcerer {
    private static final int TELEPORT_RADIUS = 32;
    private static final EntityDataAccessor<Optional<CompoundTag>> DATA_PLAYER = SynchedEntityData.m_135353_(LimboCloneEntity.class, (EntityDataSerializer)((EntityDataSerializer)JJKEntityDataSerializers.OPTIONAL_COMPOUND_TAG.get()));
    @Nullable
    private UUID ownerUUID;
    @Nullable
    private LivingEntity cachedOwner;
    private ResourceLocation original;

    protected LimboCloneEntity(EntityType<? extends PathfinderMob> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        Arrays.fill(this.f_21348_, 0.0f);
        Arrays.fill(this.f_21347_, 0.0f);
    }

    public LimboCloneEntity(LivingEntity owner, ResourceLocation original) {
        super((EntityType)JJKEntities.LIMBO_CLONE.get(), owner.m_9236_());
        this.m_7678_(owner.m_20185_(), owner.m_20186_(), owner.m_20189_(), owner.m_146908_(), owner.m_146909_());
        this.setOwner(owner);
        this.original = original;
    }

    public void setPlayer(GameProfile profile) {
        this.f_19804_.m_135381_(DATA_PLAYER, Optional.of(NbtUtils.m_129230_((CompoundTag)new CompoundTag(), (GameProfile)profile)));
    }

    @Nullable
    public GameProfile getPlayer() {
        CompoundTag a = ((Optional)this.f_19804_.m_135370_(DATA_PLAYER)).orElse(null);
        if (a == null) {
            return null;
        }
        return NbtUtils.m_129228_((CompoundTag)a);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_PLAYER, Optional.empty());
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        LivingEntity owner = this.getOwner();
        if (owner != null) {
            ISorcererData ownerCap = this.getOwner().getCapability(SorcererDataHandler.INSTANCE).resolve().orElse(null);
            ISorcererData thisCap = this.getCapability(SorcererDataHandler.INSTANCE).resolve().orElse(null);
            if (ownerCap != null && thisCap != null) {
                thisCap.deserializeNBT(ownerCap.serializeNBT());
            }
        }
    }

    @Override
    public float getExperience() {
        LivingEntity owner = this.getOwner();
        if (owner != null) {
            ISorcererData ownerCap = (ISorcererData)this.getOwner().getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
            return ownerCap.getExperience();
        }
        return 0.0f;
    }

    @Override
    public boolean canChant() {
        return false;
    }

    @Override
    public boolean hasMeleeAttack() {
        return true;
    }

    @Override
    public boolean hasArms() {
        return true;
    }

    @Override
    public boolean canJump() {
        return false;
    }

    public void m_8119_() {
        LivingEntity owner = this.getOwner();
        if (!(this.m_9236_().f_46443_ || owner != null && !owner.m_213877_() && owner.m_6084_())) {
            this.m_146870_();
        } else {
            super.m_8119_();
        }
    }

    protected void m_8024_() {
        LivingEntity owner = this.getOwner();
        if (owner != null) {
            if (!this.m_21205_().m_150930_(owner.m_21205_().m_41720_())) {
                this.m_21008_(InteractionHand.MAIN_HAND, owner.m_21205_().m_41777_());
            }
            if (!this.m_21206_().m_150930_(owner.m_21206_().m_41720_())) {
                this.m_21008_(InteractionHand.OFF_HAND, owner.m_21206_().m_41777_());
            }
            this.m_8061_(EquipmentSlot.HEAD, owner.m_6844_(EquipmentSlot.HEAD));
            this.m_8061_(EquipmentSlot.CHEST, owner.m_6844_(EquipmentSlot.CHEST));
            this.m_8061_(EquipmentSlot.LEGS, owner.m_6844_(EquipmentSlot.LEGS));
            this.m_8061_(EquipmentSlot.FEET, owner.m_6844_(EquipmentSlot.FEET));
            if ((double)this.m_20270_((Entity)owner) >= this.m_21133_(Attributes.f_22277_)) {
                double d0 = owner.m_20185_() + (HelperMethods.RANDOM.m_188500_() - HelperMethods.RANDOM.m_188500_() + 0.1) * 32.0 + 0.5;
                double d1 = owner.m_20186_() + (double)HelperMethods.RANDOM.m_188503_(3) - 1.0;
                double d2 = owner.m_20189_() + (HelperMethods.RANDOM.m_188500_() - HelperMethods.RANDOM.m_188500_() + 0.1) * 32.0 + 0.5;
                if (this.m_9236_().m_45772_(this.m_6095_().m_20585_(d0, d1, d2))) {
                    this.m_6034_(d0, d1, d2);
                }
            }
        }
    }

    public void m_6667_(@NotNull DamageSource pDamageSource) {
        super.m_6667_(pDamageSource);
        LivingEntity owner = this.getOwner();
        if (owner == null) {
            return;
        }
        MinecraftServer server = this.m_9236_().m_7654_();
        if (server == null) {
            return;
        }
        ServerLevel dimension = server.m_129880_(ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)this.original));
        if (dimension == null) {
            return;
        }
        if (owner.m_9236_() != this.m_9236_()) {
            return;
        }
        BlockPos pos = HelperMethods.findSafePos(dimension, owner);
        owner.m_264318_(dimension, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), Set.of(), owner.m_146908_(), owner.m_146909_());
    }

    public void m_7380_(@NotNull CompoundTag pCompound) {
        super.m_7380_(pCompound);
        if (this.ownerUUID != null) {
            pCompound.m_128362_("owner", this.ownerUUID);
        }
        ((Optional)this.f_19804_.m_135370_(DATA_PLAYER)).ifPresent(player -> pCompound.m_128365_("player", (Tag)player));
        pCompound.m_128359_("original", this.original.toString());
    }

    public void m_7378_(@NotNull CompoundTag pCompound) {
        super.m_7378_(pCompound);
        if (pCompound.m_128403_("owner")) {
            this.ownerUUID = pCompound.m_128342_("owner");
        }
        if (pCompound.m_128441_("player")) {
            this.f_19804_.m_135381_(DATA_PLAYER, Optional.of(pCompound.m_128469_("player")));
        }
        this.original = new ResourceLocation(pCompound.m_128461_("original"));
    }

    protected void m_8099_() {
        int goal = 1;
        int target = 1;
        this.f_21345_.m_25352_(goal++, (Goal)new WaterWalkingFloatGoal(this));
        if (this.hasMeleeAttack()) {
            this.f_21345_.m_25352_(goal++, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        }
        this.f_21345_.m_25352_(goal++, (Goal)new SorcererGoal(this));
        this.f_21345_.m_25352_(goal++, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(target++, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        if (this.targetsSorcerers()) {
            this.f_21346_.m_25352_(target++, (Goal)new NearestAttackableSorcererGoal((Mob)this, true));
        }
        if (this.targetsCurses()) {
            this.f_21346_.m_25352_(target++, (Goal)new NearestAttackableCurseGoal((Mob)this, true));
        }
    }

    protected boolean canFly() {
        return true;
    }

    protected boolean targetsCurses() {
        return true;
    }

    protected boolean targetsSorcerers() {
        return true;
    }

    public void setOwner(@Nullable LivingEntity pOwner) {
        if (pOwner != null) {
            this.ownerUUID = pOwner.m_20148_();
            this.cachedOwner = pOwner;
        }
    }

    @Nullable
    public LivingEntity getOwner() {
        if (this.cachedOwner != null && !this.cachedOwner.m_213877_()) {
            return this.cachedOwner;
        }
        if (this.ownerUUID != null && this.m_9236_() instanceof ServerLevel) {
            this.cachedOwner = (LivingEntity)((ServerLevel)this.m_9236_()).m_8791_(this.ownerUUID);
            return this.cachedOwner;
        }
        return null;
    }

    @NotNull
    public Component m_7755_() {
        LivingEntity owner = this.getOwner();
        return owner == null ? super.m_7755_() : owner.m_7755_();
    }

    public boolean m_21532_() {
        return true;
    }

    @Override
    public SorcererGrade getGrade() {
        return null;
    }

    @Override
    @Nullable
    public CursedTechnique getTechnique() {
        return null;
    }

    @Override
    public JujutsuType getJujutsuType() {
        return null;
    }
}

