/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.entity.effect;

import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import radon.jujutsu_kaisen.client.particle.JJKParticles;
import radon.jujutsu_kaisen.entity.JJKEntities;

public class BlackFlashEntity
extends Entity {
    private static final EntityDataAccessor<Integer> DATA_TIME = SynchedEntityData.m_135353_(BlackFlashEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Vector3f> DATA_START = SynchedEntityData.m_135353_(BlackFlashEntity.class, (EntityDataSerializer)EntityDataSerializers.f_268676_);
    private static final int DURATION = 10;
    @Nullable
    private UUID victimUUID;
    @Nullable
    private LivingEntity cachedVictim;
    @Nullable
    private UUID ownerUUID;
    @Nullable
    private LivingEntity cachedOwner;

    public BlackFlashEntity(EntityType<?> pType, Level pLevel) {
        super(pType, pLevel);
        this.f_19811_ = true;
    }

    public BlackFlashEntity(LivingEntity owner, LivingEntity target) {
        this((EntityType)JJKEntities.BLACk_FLASH.get(), target.m_9236_());
        this.setOwner(owner);
        this.setVictim(target);
        this.f_19804_.m_135381_(DATA_START, (Object)owner.m_20182_().m_82520_(0.0, (double)(owner.m_20192_() - this.m_20206_() / 2.0f), 0.0).m_252839_());
        this.m_146884_(target.m_20182_().m_82520_(0.0, (double)(target.m_20206_() / 2.0f), 0.0).m_82520_(0.0, (double)(this.m_20206_() / 2.0f), 0.0));
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DATA_TIME, (Object)0);
        this.f_19804_.m_135372_(DATA_START, (Object)Vec3.f_82478_.m_252839_());
    }

    public int getTime() {
        return (Integer)this.f_19804_.m_135370_(DATA_TIME);
    }

    public void setTime(int time) {
        this.f_19804_.m_135381_(DATA_TIME, (Object)time);
    }

    public void m_7380_(@NotNull CompoundTag pCompound) {
        if (this.victimUUID != null) {
            pCompound.m_128362_("victim", this.victimUUID);
        }
        if (this.ownerUUID != null) {
            pCompound.m_128362_("owner", this.ownerUUID);
        }
        pCompound.m_128405_("time", this.getTime());
        Vector3f start = (Vector3f)this.f_19804_.m_135370_(DATA_START);
        pCompound.m_128350_("start_x", start.x);
        pCompound.m_128350_("start_y", start.y);
        pCompound.m_128350_("start_z", start.z);
    }

    public void m_7378_(@NotNull CompoundTag pCompound) {
        if (pCompound.m_128403_("victim")) {
            this.victimUUID = pCompound.m_128342_("victim");
        }
        if (pCompound.m_128403_("owner")) {
            this.ownerUUID = pCompound.m_128342_("owner");
        }
        this.setTime(pCompound.m_128451_("time"));
        this.f_19804_.m_135381_(DATA_START, (Object)new Vector3f(pCompound.m_128457_("start_x"), pCompound.m_128457_("start_y"), pCompound.m_128457_("start_z")));
    }

    public Vec3 getStart() {
        return new Vec3((Vector3f)this.f_19804_.m_135370_(DATA_START));
    }

    public boolean m_6783_(double pDistance) {
        double d0 = this.m_20191_().m_82309_() * 10.0;
        if (Double.isNaN(d0)) {
            d0 = 1.0;
        }
        return pDistance < (d0 *= 64.0 * BlackFlashEntity.m_20150_()) * d0;
    }

    public void m_8119_() {
        super.m_8119_();
        this.setTime(this.getTime() + 1);
        LivingEntity victim = this.getVictim();
        for (int i = 0; i < 32; ++i) {
            double offsetX = this.f_19796_.m_188583_() * 3.0;
            double offsetY = this.f_19796_.m_188583_() * 3.0;
            double offsetZ = this.f_19796_.m_188583_() * 3.0;
            this.m_9236_().m_7106_((ParticleOptions)JJKParticles.BLACK_FLASH.get(), this.m_20185_() + offsetX, this.m_20186_() + offsetY, this.m_20189_() + offsetZ, 0.0, 0.0, 0.0);
        }
        if (this.getTime() >= 10) {
            this.m_146870_();
        } else if (victim != null) {
            this.m_146884_(victim.m_20182_().m_82520_(0.0, (double)(victim.m_20206_() / 2.0f), 0.0).m_82520_(0.0, (double)(this.m_20206_() / 2.0f), 0.0));
        }
    }

    public void setVictim(@Nullable LivingEntity victim) {
        if (victim != null) {
            this.victimUUID = victim.m_20148_();
            this.cachedVictim = victim;
        }
    }

    @Nullable
    public LivingEntity getVictim() {
        if (this.cachedVictim != null && !this.cachedVictim.m_213877_()) {
            return this.cachedVictim;
        }
        if (this.victimUUID != null && this.m_9236_() instanceof ServerLevel) {
            this.cachedVictim = (LivingEntity)((ServerLevel)this.m_9236_()).m_8791_(this.victimUUID);
            return this.cachedVictim;
        }
        return null;
    }

    public void setOwner(@Nullable LivingEntity pOwner) {
        if (pOwner != null) {
            this.ownerUUID = pOwner.m_20148_();
            this.cachedOwner = pOwner;
        }
    }

    @Nullable
    public LivingEntity getOwner() {
        if (this.cachedOwner != null && !this.cachedOwner.m_213877_()) {
            return this.cachedOwner;
        }
        if (this.ownerUUID != null && this.m_9236_() instanceof ServerLevel) {
            this.cachedOwner = (LivingEntity)((ServerLevel)this.m_9236_()).m_8791_(this.ownerUUID);
            return this.cachedOwner;
        }
        return null;
    }
}

