/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.entity.effect;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import radon.jujutsu_kaisen.ability.JJKAbilities;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.entity.JJKEntities;
import radon.jujutsu_kaisen.entity.curse.RikaEntity;
import radon.jujutsu_kaisen.entity.effect.base.BeamEntity;
import radon.jujutsu_kaisen.util.RotationUtil;

public class PureLoveBeamEntity
extends BeamEntity {
    public static final int FRAMES = 3;
    public static final float SCALE = 2.0f;
    private static final float DAMAGE = 7.0f;
    public static final int CHARGE = 50;
    public static final int DURATION = 100;

    public PureLoveBeamEntity(EntityType<? extends Projectile> pType, Level pLevel) {
        super(pType, pLevel);
    }

    public PureLoveBeamEntity(LivingEntity owner, float power) {
        super((EntityType<? extends Projectile>)((EntityType)JJKEntities.PURE_LOVE.get()), owner, power);
    }

    @Override
    protected boolean shouldSwing() {
        return false;
    }

    @Override
    public boolean canDeflect() {
        return false;
    }

    @Override
    public int getFrames() {
        return 3;
    }

    @Override
    public float getScale() {
        Entity entity = this.m_19749_();
        if (!(entity instanceof RikaEntity)) {
            return 2.0f;
        }
        RikaEntity rika = (RikaEntity)entity;
        return 2.0f * (rika.isOpen() ? 1.0f : 0.5f);
    }

    @Override
    protected double getRange() {
        return 40.0;
    }

    @Override
    protected float getDamage() {
        Entity entity = this.m_19749_();
        if (!(entity instanceof RikaEntity)) {
            return 7.0f;
        }
        RikaEntity rika = (RikaEntity)entity;
        return 7.0f * (rika.isOpen() ? 1.5f : 0.5f);
    }

    @Override
    public int getDuration() {
        Entity entity = this.m_19749_();
        if (!(entity instanceof RikaEntity)) {
            return 100;
        }
        RikaEntity rika = (RikaEntity)entity;
        return (int)(100.0f * (rika.isOpen() ? 1.0f : 0.5f));
    }

    @Override
    public int getCharge() {
        return 50;
    }

    @Override
    @Nullable
    protected Ability getSource() {
        return (Ability)JJKAbilities.SHOOT_PURE_LOVE.get();
    }

    @Override
    protected Vec3 calculateSpawnPos(LivingEntity owner) {
        return new Vec3(owner.m_20185_(), owner.m_20188_() - 0.2 - (double)(this.m_20206_() / 2.0f), owner.m_20189_()).m_82549_(RotationUtil.getTargetAdjustedLookAngle((Entity)owner));
    }
}

