/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.entity.effect;

import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;
import radon.jujutsu_kaisen.entity.JJKEntities;

public class WoodSegmentEntity
extends Entity {
    private static final EntityDataAccessor<Integer> DATA_TIME = SynchedEntityData.m_135353_(WoodSegmentEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DATA_PARENT = SynchedEntityData.m_135353_(WoodSegmentEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Vector3f> DATA_OFFSET = SynchedEntityData.m_135353_(WoodSegmentEntity.class, (EntityDataSerializer)EntityDataSerializers.f_268676_);
    private static final EntityDataAccessor<Float> DATA_YAW = SynchedEntityData.m_135353_(WoodSegmentEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> DATA_PITCH = SynchedEntityData.m_135353_(WoodSegmentEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Integer> DATA_INDEX = SynchedEntityData.m_135353_(WoodSegmentEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public WoodSegmentEntity(EntityType<?> pType, Level pLevel) {
        super(pType, pLevel);
    }

    public WoodSegmentEntity(WoodSegmentEntity segment, float yawOffset, float pitchOffset) {
        this(segment, 0.0, 0.75 * (double)segment.m_20206_(), 0.0, yawOffset, pitchOffset);
    }

    public WoodSegmentEntity(WoodSegmentEntity segment, double offsetX, double offsetY, double offsetZ, float yawOffset, float pitchOffset) {
        this((EntityType)JJKEntities.WOOD_SEGMENT.get(), segment.m_9236_());
        Vec2 rot = segment.getRotationOffset();
        Vec3 offset = new Vec3(offsetX, offsetY, offsetZ).m_82496_(-rot.f_82470_ * ((float)Math.PI / 180)).m_82524_(-rot.f_82471_ * ((float)Math.PI / 180)).m_82549_(segment.getPositionOffset());
        this.setOffset(offset.f_82479_, offset.f_82480_, offset.f_82481_, rot.f_82471_ + yawOffset, rot.f_82470_ + pitchOffset);
        this.setParent(segment.getParent());
        this.setPositionAndRotationFromParent();
        this.setIndex(segment.getIndex() + 1);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DATA_TIME, (Object)0);
        this.f_19804_.m_135372_(DATA_PARENT, (Object)-1);
        this.f_19804_.m_135372_(DATA_OFFSET, (Object)Vec3.f_82478_.m_252839_());
        this.f_19804_.m_135372_(DATA_YAW, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(DATA_PITCH, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(DATA_INDEX, (Object)0);
    }

    public int getTime() {
        return (Integer)this.f_19804_.m_135370_(DATA_TIME);
    }

    public void setTime(int time) {
        this.f_19804_.m_135381_(DATA_TIME, (Object)time);
    }

    public void m_8119_() {
        super.m_8119_();
        this.setTime(this.getTime() + 1);
    }

    protected void setOffset(double x, double y, double z, float yaw, float pitch) {
        this.f_19804_.m_135381_(DATA_OFFSET, (Object)new Vec3(x, y, z).m_252839_());
        this.f_19804_.m_135381_(DATA_YAW, (Object)Float.valueOf(yaw));
        this.f_19804_.m_135381_(DATA_PITCH, (Object)Float.valueOf(pitch));
    }

    protected Vec3 getPositionOffset() {
        return new Vec3((Vector3f)this.f_19804_.m_135370_(DATA_OFFSET));
    }

    protected Vec2 getRotationOffset() {
        return new Vec2(((Float)this.f_19804_.m_135370_(DATA_PITCH)).floatValue(), ((Float)this.f_19804_.m_135370_(DATA_YAW)).floatValue());
    }

    protected void setParent(@Nullable Entity entity) {
        this.f_19804_.m_135381_(DATA_PARENT, (Object)(entity == null ? -1 : entity.m_19879_()));
    }

    @Nullable
    protected Entity getParent() {
        return this.m_9236_().m_6815_(((Integer)this.f_19804_.m_135370_(DATA_PARENT)).intValue());
    }

    protected void setIndex(int i) {
        this.f_19804_.m_135381_(DATA_INDEX, (Object)i);
    }

    public int getIndex() {
        return (Integer)this.f_19804_.m_135370_(DATA_INDEX);
    }

    protected void setPositionAndRotationFromParent() {
        Entity parent = this.getParent();
        if (parent != null) {
            float yaw = parent.f_19859_ + Mth.m_14177_((float)(parent.m_146908_() - parent.f_19859_));
            double x = parent.f_19790_ + (parent.m_20185_() - parent.f_19790_);
            double y = parent.f_19791_ + (parent.m_20186_() - parent.f_19791_);
            double z = parent.f_19792_ + (parent.m_20189_() - parent.f_19792_);
            Vec3 pos = this.getPositionOffset().m_82524_(-yaw * ((float)Math.PI / 180)).m_82520_(x, y, z);
            Vec2 rot = this.getRotationOffset();
            this.m_146922_(yaw + rot.f_82471_);
            this.m_146926_(rot.f_82470_);
            this.m_146884_(pos);
        }
    }

    protected void m_7380_(@NotNull CompoundTag pCompound) {
        pCompound.m_128405_("time", this.getTime());
    }

    protected void m_7378_(@NotNull CompoundTag pCompound) {
        this.setTime(pCompound.m_128451_("time"));
    }
}

