/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.entity.idle_transfiguration.base;

import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import radon.jujutsu_kaisen.ability.JJKAbilities;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.ability.idle_transfiguration.IdleTransfiguration;
import radon.jujutsu_kaisen.capability.data.sorcerer.CursedTechnique;
import radon.jujutsu_kaisen.capability.data.sorcerer.ISorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.JujutsuType;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.entity.ai.goal.BetterFollowOwnerGoal;
import radon.jujutsu_kaisen.entity.ai.goal.SorcererGoal;
import radon.jujutsu_kaisen.entity.ai.goal.WaterWalkingFloatGoal;
import radon.jujutsu_kaisen.entity.base.ICommandable;
import radon.jujutsu_kaisen.entity.base.ISorcerer;
import radon.jujutsu_kaisen.entity.base.SummonEntity;
import radon.jujutsu_kaisen.util.HelperMethods;
import radon.jujutsu_kaisen.util.RotationUtil;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public abstract class TransfiguredSoulEntity
extends SummonEntity
implements ISorcerer,
ICommandable {
    private static final RawAnimation WALK = RawAnimation.begin().thenLoop("move.walk");
    private static final RawAnimation RUN = RawAnimation.begin().thenLoop("move.run");
    private static final RawAnimation SWING = RawAnimation.begin().thenPlay("attack.swing");

    protected TransfiguredSoulEntity(EntityType<? extends TamableAnimal> pType, Level pLevel) {
        super(pType, pLevel);
    }

    public TransfiguredSoulEntity(EntityType<? extends TamableAnimal> pType, LivingEntity owner) {
        super(pType, owner.m_9236_());
        this.m_7105_(true);
        this.setOwner(owner);
        Vec3 pos = owner.m_20182_().m_82546_(RotationUtil.getTargetAdjustedLookAngle((Entity)owner).m_82542_((double)this.m_20205_(), 0.0, (double)this.m_20205_()));
        this.m_7678_(pos.f_82479_, pos.f_82480_, pos.f_82481_, RotationUtil.getTargetAdjustedYRot((Entity)owner), RotationUtil.getTargetAdjustedXRot((Entity)owner));
        this.f_20886_ = this.f_20885_ = this.m_146908_();
    }

    public boolean m_6469_(@NotNull DamageSource pSource, float pAmount) {
        LivingEntity owner = this.m_269323_();
        if (owner != null && pSource.m_7639_() == owner && JJKAbilities.hasToggled(owner, (Ability)JJKAbilities.IDLE_TRANSFIGURATION.get())) {
            IdleTransfiguration.retrieve(owner, (LivingEntity)this);
        }
        return super.m_6469_(pSource, pAmount);
    }

    protected void m_8099_() {
        int target = 1;
        int goal = 1;
        this.f_21345_.m_25352_(goal++, (Goal)new WaterWalkingFloatGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(goal++, (Goal)new MeleeAttackGoal((PathfinderMob)this, 0.9, true));
        this.f_21345_.m_25352_(goal++, (Goal)new SorcererGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(goal++, (Goal)new BetterFollowOwnerGoal(this, 1.0, 25.0f, 10.0f, false));
        this.f_21345_.m_25352_(goal, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(target++, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(target, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
    }

    @NotNull
    protected PathNavigation m_6037_(@NotNull Level pLevel) {
        LivingEntity target = this.m_5448_();
        GroundPathNavigation navigation = new GroundPathNavigation((Mob)this, pLevel);
        navigation.m_26477_(false);
        navigation.m_7008_(false);
        navigation.m_148214_(true);
        return navigation;
    }

    @Override
    protected void m_8024_() {
        super.m_8024_();
        if (this.m_5448_() != null) {
            this.f_21342_.m_6849_(this.m_5448_().m_20185_(), this.m_5448_().m_20186_(), this.m_5448_().m_20189_(), (double)1.1f);
        }
        if (this.m_5448_() != null && HelperMethods.RANDOM.m_188503_(5) == 0) {
            this.f_21342_.m_6849_(this.m_5448_().m_20185_() * -1.5, this.m_5448_().m_20186_() * (double)-1.1f, this.m_5448_().m_20189_() * (double)-1.1f, (double)1.4f);
        }
    }

    private PlayState walkRunPredicate(AnimationState<TransfiguredSoulEntity> animationState) {
        if (animationState.isMoving()) {
            return animationState.setAndContinue(this.m_20142_() ? RUN : WALK);
        }
        return PlayState.STOP;
    }

    private PlayState swingPredicate(AnimationState<TransfiguredSoulEntity> animationState) {
        if (this.f_20911_) {
            return animationState.setAndContinue(SWING);
        }
        animationState.getController().forceAnimationReset();
        return PlayState.STOP;
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "Walk/Run", this::walkRunPredicate)});
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "Swing", this::swingPredicate)});
    }

    @Override
    public boolean canChangeTarget() {
        return true;
    }

    @Override
    public void changeTarget(LivingEntity target) {
        this.m_6710_(target);
    }

    @Override
    public boolean hasMeleeAttack() {
        return true;
    }

    @Override
    public boolean hasArms() {
        return true;
    }

    @Override
    public boolean canJump() {
        return true;
    }

    @Override
    public boolean canChant() {
        return false;
    }

    @Override
    public float getExperience() {
        if (this.m_269323_() == null) {
            return 0.0f;
        }
        ISorcererData ownerCap = (ISorcererData)this.m_269323_().getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        float exp = ownerCap.getExperience();
        return exp * 0.4f;
    }

    @Override
    @Nullable
    public CursedTechnique getTechnique() {
        return null;
    }

    @Override
    public JujutsuType getJujutsuType() {
        return JujutsuType.SORCERER;
    }

    public static enum Variant {
        ONE,
        TWO,
        THREE;

    }
}

