/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.entity.projectile;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import radon.jujutsu_kaisen.ability.JJKAbilities;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.capability.data.ten_shadows.ITenShadowsData;
import radon.jujutsu_kaisen.capability.data.ten_shadows.TenShadowsDataHandler;
import radon.jujutsu_kaisen.client.particle.ParticleColors;
import radon.jujutsu_kaisen.client.particle.TravelParticle;
import radon.jujutsu_kaisen.damage.JJKDamageSources;
import radon.jujutsu_kaisen.entity.JJKEntities;
import radon.jujutsu_kaisen.entity.projectile.base.JujutsuProjectile;
import radon.jujutsu_kaisen.entity.ten_shadows.MahoragaEntity;
import radon.jujutsu_kaisen.util.EntityUtil;
import radon.jujutsu_kaisen.util.HelperMethods;
import radon.jujutsu_kaisen.util.RotationUtil;

public class BlueProjectile
extends JujutsuProjectile {
    private static final EntityDataAccessor<Boolean> DATA_MOTION = SynchedEntityData.m_135353_(BlueProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final double RANGE = 15.0;
    private static final int DELAY = 20;
    private static final float DAMAGE = 6.0f;
    private static final int DURATION = 100;
    private static final float RADIUS = 4.0f;
    private static final float MAX_RADIUS = 8.0f;
    private static final double OFFSET = 12.0;

    public BlueProjectile(EntityType<? extends BlueProjectile> pType, Level level) {
        super(pType, level);
    }

    public BlueProjectile(EntityType<? extends BlueProjectile> pType, Level level, LivingEntity owner, float power) {
        super(pType, level, (Entity)owner, power);
    }

    public BlueProjectile(LivingEntity owner, float power, boolean motion) {
        this((EntityType<? extends BlueProjectile>)((EntityType)JJKEntities.BLUE.get()), owner.m_9236_(), owner, power);
        this.f_19804_.m_135381_(DATA_MOTION, (Object)motion);
        Vec3 look = RotationUtil.getTargetAdjustedLookAngle((Entity)owner);
        EntityUtil.offset((Entity)this, look, new Vec3(owner.m_20185_(), owner.m_20188_() - (double)(this.m_20206_() / 2.0f), owner.m_20189_()).m_82549_(look));
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_MOTION, (Object)false);
    }

    @Override
    public boolean canDeflect() {
        return false;
    }

    private void pullEntities() {
        float radius = this.getRadius();
        AABB bounds = new AABB(this.m_20185_() - (double)radius, this.m_20186_() - (double)radius, this.m_20189_() - (double)radius, this.m_20185_() + (double)radius, this.m_20186_() + (double)radius, this.m_20189_() + (double)radius);
        Vec3 center = new Vec3(this.m_20185_(), this.m_20186_() + (double)(this.m_20206_() / 2.0f), this.m_20189_());
        Entity entity = this.m_19749_();
        if (entity instanceof LivingEntity) {
            LivingEntity owner = (LivingEntity)entity;
            for (Entity entity2 : this.m_9236_().m_45933_((Entity)owner, bounds)) {
                MahoragaEntity maho;
                ITenShadowsData cap;
                LivingEntity living;
                if (entity2 instanceof LivingEntity && !owner.m_6779_(living = (LivingEntity)entity2)) continue;
                if (entity2 instanceof MahoragaEntity && (cap = (ITenShadowsData)(maho = (MahoragaEntity)entity2).getCapability(TenShadowsDataHandler.INSTANCE).resolve().orElseThrow()).isAdaptedTo((Ability)JJKAbilities.BLUE_STILL.get())) {
                    return;
                }
                Vec3 direction = center.m_82492_(entity2.m_20185_(), entity2.m_20186_() + (double)entity2.m_20206_() / 2.0, entity2.m_20189_()).m_82541_();
                entity2.m_20256_(direction);
                entity2.f_19864_ = true;
            }
        }
    }

    private float getRadius() {
        return Math.max(4.0f, Math.min(8.0f, 4.0f * this.getPower()));
    }

    private void breakBlocks() {
        Entity entity = this.m_19749_();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity owner = (LivingEntity)entity;
        AABB bounds = this.m_20191_();
        double centerX = bounds.m_82399_().f_82479_;
        double centerY = bounds.m_82399_().f_82480_;
        double centerZ = bounds.m_82399_().f_82481_;
        int x = (int)bounds.f_82288_;
        while ((double)x <= bounds.f_82291_) {
            int y = (int)bounds.f_82289_;
            while ((double)y <= bounds.f_82292_) {
                int z = (int)bounds.f_82290_;
                while ((double)z <= bounds.f_82293_) {
                    BlockPos pos = new BlockPos(x, y, z);
                    BlockState state = this.m_9236_().m_8055_(pos);
                    double distance = Math.sqrt(Math.pow((double)x - centerX, 2.0) + Math.pow((double)y - centerY, 2.0) + Math.pow((double)z - centerZ, 2.0));
                    if (distance <= (double)this.getRadius() && HelperMethods.isDestroyable((BlockGetter)this.m_9236_(), owner, pos)) {
                        if (state.m_60819_().m_76178_()) {
                            owner.m_9236_().m_7731_(pos, Blocks.f_50016_.m_49966_(), 18);
                        } else {
                            this.m_9236_().m_46597_(pos, Blocks.f_50016_.m_49966_());
                        }
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
    }

    private void hurtEntities() {
        AABB bounds = this.m_20191_();
        Entity entity = this.m_19749_();
        if (entity instanceof LivingEntity) {
            LivingEntity owner = (LivingEntity)entity;
            for (Entity entity2 : this.m_9236_().m_45933_((Entity)owner, bounds)) {
                Projectile projectile;
                if (entity2 instanceof Projectile && (projectile = (Projectile)entity2).m_19749_() == owner) continue;
                if (entity2 instanceof LivingEntity) {
                    entity2.m_6469_((DamageSource)JJKDamageSources.indirectJujutsuAttack((Entity)this, owner, (Boolean)this.f_19804_.m_135370_(DATA_MOTION) != false ? (Ability)JJKAbilities.BLUE_MOTION.get() : (Ability)JJKAbilities.BLUE_STILL.get()), 6.0f * this.getPower());
                    continue;
                }
                if (!(entity2 instanceof AbstractArrow) && !(entity2 instanceof FallingBlockEntity)) continue;
                entity2.m_146870_();
            }
        }
    }

    private void pullBlocks() {
        Entity entity = this.m_19749_();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity owner = (LivingEntity)entity;
        float radius = this.getRadius() * 2.0f;
        AABB bounds = new AABB(this.m_20185_() - (double)radius, this.m_20186_() - (double)radius, this.m_20189_() - (double)radius, this.m_20185_() + (double)radius, this.m_20186_() + (double)radius, this.m_20189_() + (double)radius);
        double centerX = bounds.m_82399_().f_82479_;
        double centerY = bounds.m_82399_().f_82480_;
        double centerZ = bounds.m_82399_().f_82481_;
        int x = (int)bounds.f_82288_;
        while ((double)x <= bounds.f_82291_) {
            int y = (int)bounds.f_82289_;
            while ((double)y <= bounds.f_82292_) {
                int z = (int)bounds.f_82290_;
                while ((double)z <= bounds.f_82293_) {
                    if (this.f_19796_.m_188503_(Math.round(radius * 2.0f * 20.0f)) == 0) {
                        BlockPos pos = new BlockPos(x, y, z);
                        BlockState state = this.m_9236_().m_8055_(pos);
                        double distance = Math.sqrt(Math.pow((double)x - centerX, 2.0) + Math.pow((double)y - centerY, 2.0) + Math.pow((double)z - centerZ, 2.0));
                        if (distance <= (double)radius && HelperMethods.isDestroyable((BlockGetter)this.m_9236_(), owner, pos) && this.m_9236_().m_46961_(pos, false)) {
                            FallingBlockEntity entity2 = FallingBlockEntity.m_201971_((Level)this.m_9236_(), (BlockPos)pos, (BlockState)state);
                            entity2.f_19794_ = true;
                            if (((ServerLevel)this.m_9236_()).m_8791_(entity2.m_20148_()) == null) {
                                this.m_9236_().m_7967_((Entity)entity2);
                            }
                        }
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
    }

    private void spawnParticles() {
        double z;
        double y;
        double x;
        double zOffset;
        double yOffset;
        double xOffset;
        double phi;
        double theta;
        int i;
        Vec3 center = new Vec3(this.m_20185_(), this.m_20186_() + (double)(this.m_20206_() / 2.0f), this.m_20189_());
        float radius = this.getRadius() * (this.getTime() < 20 ? 0.25f : 1.0f);
        int count = (int)((double)radius * Math.PI * 2.0) * 2;
        for (i = 0; i < count; ++i) {
            theta = this.f_19796_.m_188500_() * Math.PI * 2.0;
            phi = this.f_19796_.m_188500_() * Math.PI;
            xOffset = (double)radius * Math.sin(phi) * Math.cos(theta);
            yOffset = (double)radius * Math.sin(phi) * Math.sin(theta);
            zOffset = (double)radius * Math.cos(phi);
            x = center.f_82479_ + xOffset * (double)(radius * 0.1f);
            y = center.f_82480_ + yOffset * (double)(radius * 0.1f);
            z = center.f_82481_ + zOffset * (double)(radius * 0.1f);
            this.m_9236_().m_7106_((ParticleOptions)new TravelParticle.TravelParticleOptions(center.m_252839_(), ParticleColors.DARK_BLUE, radius * 0.075f, 1.0f, true, 5), x, y, z, 0.0, 0.0, 0.0);
        }
        for (i = 0; i < count; ++i) {
            theta = this.f_19796_.m_188500_() * Math.PI * 2.0;
            phi = this.f_19796_.m_188500_() * Math.PI;
            xOffset = (double)(radius * 0.5f) * Math.sin(phi) * Math.cos(theta);
            yOffset = (double)(radius * 0.5f) * Math.sin(phi) * Math.sin(theta);
            zOffset = (double)(radius * 0.5f) * Math.cos(phi);
            x = center.f_82479_ + xOffset * (double)(radius * 0.5f * 0.1f);
            y = center.f_82480_ + yOffset * (double)(radius * 0.5f * 0.1f);
            z = center.f_82481_ + zOffset * (double)(radius * 0.5f * 0.1f);
            this.m_9236_().m_7106_((ParticleOptions)new TravelParticle.TravelParticleOptions(center.m_252839_(), ParticleColors.LIGHT_BLUE, radius * 0.05f, 1.0f, true, 5), x, y, z, 0.0, 0.0, 0.0);
        }
    }

    @NotNull
    public EntityDimensions m_6972_(@NotNull Pose pPose) {
        float radius = this.getRadius();
        return EntityDimensions.m_20398_((float)radius, (float)radius);
    }

    @Override
    protected void m_7378_(@NotNull CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.f_19804_.m_135381_(DATA_MOTION, (Object)pCompound.m_128471_("motion"));
    }

    @Override
    protected void m_7380_(@NotNull CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128379_("motion", ((Boolean)this.f_19804_.m_135370_(DATA_MOTION)).booleanValue());
    }

    private void spin() {
        Entity entity = this.m_19749_();
        if (entity instanceof LivingEntity) {
            LivingEntity owner = (LivingEntity)entity;
            if (this.getTime() % 5 == 0) {
                owner.m_6674_(InteractionHand.MAIN_HAND);
            }
            Vec3 look = RotationUtil.getTargetAdjustedLookAngle((Entity)owner);
            EntityUtil.offset((Entity)this, look, new Vec3(owner.m_20185_(), owner.m_20188_() - (double)(this.m_20206_() / 2.0f), owner.m_20189_()).m_82549_(look.m_82490_(12.0)));
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.m_6210_();
        int blueTime = this.getTime();
        if (((Boolean)this.f_19804_.m_135370_(DATA_MOTION)).booleanValue()) {
            if (this.getTime() >= 20) {
                this.spin();
            }
        } else {
            blueTime += 20;
        }
        if (blueTime >= 100) {
            this.m_146870_();
        } else {
            this.spawnParticles();
            Entity entity = this.m_19749_();
            if (entity instanceof LivingEntity) {
                LivingEntity owner = (LivingEntity)entity;
                if (this.getTime() < 20) {
                    if (!owner.m_6084_()) {
                        this.m_146870_();
                    } else {
                        if (this.getTime() % 5 == 0) {
                            owner.m_6674_(InteractionHand.MAIN_HAND);
                        }
                        Vec3 look = RotationUtil.getTargetAdjustedLookAngle((Entity)owner);
                        EntityUtil.offset((Entity)this, look, new Vec3(owner.m_20185_(), owner.m_20188_() - (double)(this.m_20206_() / 2.0f), owner.m_20189_()).m_82549_(look));
                    }
                } else {
                    if (this.getTime() == 20) {
                        Vec3 look;
                        Vec3 end;
                        Vec3 start = owner.m_146892_();
                        HitResult result = RotationUtil.getHitResult((Entity)owner, start, end = start.m_82549_((look = RotationUtil.getTargetAdjustedLookAngle((Entity)owner)).m_82490_(15.0)));
                        Vec3 pos = result.m_6662_() == HitResult.Type.MISS ? end : result.m_82450_();
                        this.m_146884_(pos.m_82492_(0.0, (double)(this.m_20206_() / 2.0f), 0.0));
                    }
                    if (this.getTime() >= 20) {
                        this.pullEntities();
                    }
                    this.hurtEntities();
                    if (!this.m_9236_().f_46443_) {
                        this.pullBlocks();
                        this.breakBlocks();
                    }
                }
            }
        }
    }
}

