/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.entity.projectile;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import radon.jujutsu_kaisen.ability.JJKAbilities;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.capability.data.sorcerer.ISorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.client.particle.EmittingLightningParticle;
import radon.jujutsu_kaisen.client.particle.ParticleColors;
import radon.jujutsu_kaisen.client.particle.TravelParticle;
import radon.jujutsu_kaisen.damage.JJKDamageSources;
import radon.jujutsu_kaisen.entity.JJKEntities;
import radon.jujutsu_kaisen.entity.projectile.base.JujutsuProjectile;
import radon.jujutsu_kaisen.sound.JJKSounds;
import radon.jujutsu_kaisen.util.EntityUtil;
import radon.jujutsu_kaisen.util.HelperMethods;
import radon.jujutsu_kaisen.util.RotationUtil;

public class HollowPurpleProjectile
extends JujutsuProjectile {
    private static final int DELAY = 40;
    private static final float SPEED = 5.0f;
    private static final int DURATION = 100;
    private static final float DAMAGE = 35.0f;
    private static final float MAX_RADIUS = 15.0f;
    private static final float RADIUS = 1.0f;
    private static final int ANIMATION = 20;

    public HollowPurpleProjectile(EntityType<? extends Projectile> pType, Level pLevel) {
        super(pType, pLevel);
    }

    public HollowPurpleProjectile(LivingEntity owner, float power) {
        super((EntityType<? extends Projectile>)((EntityType)JJKEntities.HOLLOW_PURPLE.get()), owner.m_9236_(), (Entity)owner, power);
        Vec3 look = RotationUtil.getTargetAdjustedLookAngle((Entity)owner);
        EntityUtil.offset((Entity)this, look, new Vec3(owner.m_20185_(), owner.m_20188_() - (double)(this.m_20206_() / 2.0f), owner.m_20189_()).m_82549_(look.m_82490_((double)(this.getRadius() * 0.5f))));
    }

    public float getRadius() {
        return Math.min(15.0f, 1.0f * this.getPower());
    }

    private void hurtEntities() {
        double radius = Math.max(Math.PI, (double)this.getRadius());
        AABB bounds = this.m_20191_().m_82400_(radius * (double)0.71f);
        Entity entity = this.m_19749_();
        if (entity instanceof LivingEntity) {
            LivingEntity owner = (LivingEntity)entity;
            for (Entity entity2 : this.m_9236_().m_45933_((Entity)owner, bounds)) {
                ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
                if (entity2 == this || entity2 == owner && !cap.hasSelfHit()) continue;
                if (entity2 instanceof Projectile) {
                    entity2.m_146870_();
                    continue;
                }
                entity2.m_6469_((DamageSource)JJKDamageSources.indirectJujutsuAttack((Entity)this, owner, (Ability)JJKAbilities.HOLLOW_PURPLE.get()), 35.0f * this.getPower());
            }
        }
    }

    private void breakBlocks() {
        Entity entity = this.m_19749_();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity owner = (LivingEntity)entity;
        int i = 0;
        while ((float)i < 5.0f) {
            double radius = Math.max(Math.PI, (double)this.getRadius());
            AABB bounds = this.m_20191_().m_82400_(radius);
            double centerX = bounds.m_82399_().f_82479_;
            double centerY = bounds.m_82399_().f_82480_;
            double centerZ = bounds.m_82399_().f_82481_;
            int x = (int)bounds.f_82288_;
            while ((double)x <= bounds.f_82291_) {
                int y = (int)bounds.f_82289_;
                while ((double)y <= bounds.f_82292_) {
                    int z = (int)bounds.f_82290_;
                    while ((double)z <= bounds.f_82293_) {
                        BlockPos pos = new BlockPos(x, y, z);
                        BlockState state = this.m_9236_().m_8055_(pos);
                        double distance = Math.sqrt(Math.pow((double)x - centerX, 2.0) + Math.pow((double)y - centerY, 2.0) + Math.pow((double)z - centerZ, 2.0));
                        if (distance <= radius && HelperMethods.isDestroyable((BlockGetter)this.m_9236_(), owner, pos)) {
                            if (state.m_60819_().m_76178_()) {
                                owner.m_9236_().m_7731_(pos, Blocks.f_50016_.m_49966_(), 18);
                            } else {
                                this.m_9236_().m_46597_(pos, Blocks.f_50016_.m_49966_());
                            }
                        }
                        ++z;
                    }
                    ++y;
                }
                ++x;
            }
            ++i;
        }
    }

    @NotNull
    public EntityDimensions m_6972_(@NotNull Pose pPose) {
        return EntityDimensions.m_20398_((float)this.getRadius(), (float)this.getRadius());
    }

    @Override
    public boolean canDeflect() {
        return false;
    }

    private void renderBlue(Vec3 center) {
        double z;
        double y;
        double x;
        double zOffset;
        double yOffset;
        double xOffset;
        double phi;
        double theta;
        int i;
        float radius = (float)Math.max(Math.PI, (double)this.getRadius()) * 0.5f;
        int count = (int)((double)radius * Math.PI * 2.0);
        for (i = 0; i < count; ++i) {
            theta = this.f_19796_.m_188500_() * Math.PI * 2.0;
            phi = this.f_19796_.m_188500_() * Math.PI;
            xOffset = (double)(radius * 0.75f) * Math.sin(phi) * Math.cos(theta);
            yOffset = (double)(radius * 0.75f) * Math.sin(phi) * Math.sin(theta);
            zOffset = (double)(radius * 0.75f) * Math.cos(phi);
            x = center.f_82479_ + xOffset * (double)(radius * 0.1f);
            y = center.f_82480_ + yOffset * (double)(radius * 0.1f);
            z = center.f_82481_ + zOffset * (double)(radius * 0.1f);
            this.m_9236_().m_6493_((ParticleOptions)new TravelParticle.TravelParticleOptions(new Vec3(x, y, z).m_252839_(), ParticleColors.DARK_BLUE, radius * 0.2f, 1.0f, true, 5), true, center.f_82479_, center.f_82480_, center.f_82481_, 0.0, 0.0, 0.0);
        }
        for (i = 0; i < count; ++i) {
            theta = this.f_19796_.m_188500_() * Math.PI * 2.0;
            phi = this.f_19796_.m_188500_() * Math.PI;
            xOffset = (double)(radius * 0.5f) * Math.sin(phi) * Math.cos(theta);
            yOffset = (double)(radius * 0.5f) * Math.sin(phi) * Math.sin(theta);
            zOffset = (double)(radius * 0.5f) * Math.cos(phi);
            x = center.f_82479_ + xOffset * (double)0.1f;
            y = center.f_82480_ + yOffset * (double)0.1f;
            z = center.f_82481_ + zOffset * (double)0.1f;
            this.m_9236_().m_6493_((ParticleOptions)new TravelParticle.TravelParticleOptions(center.m_252839_(), ParticleColors.LIGHT_BLUE, radius * 0.1f, 1.0f, true, 5), true, x, y, z, 0.0, 0.0, 0.0);
        }
    }

    private void renderRed(Vec3 center) {
        double z;
        double y;
        double x;
        double zOffset;
        double yOffset;
        double xOffset;
        double phi;
        double theta;
        int i;
        float radius = (float)Math.max(Math.PI, (double)this.getRadius()) * 0.5f;
        int count = (int)((double)radius * Math.PI * 2.0);
        for (i = 0; i < count; ++i) {
            theta = this.f_19796_.m_188500_() * Math.PI * 2.0;
            phi = this.f_19796_.m_188500_() * Math.PI;
            xOffset = (double)(radius * 0.75f) * Math.sin(phi) * Math.cos(theta);
            yOffset = (double)(radius * 0.75f) * Math.sin(phi) * Math.sin(theta);
            zOffset = (double)(radius * 0.75f) * Math.cos(phi);
            x = center.f_82479_ + xOffset * (double)(radius * 0.1f);
            y = center.f_82480_ + yOffset * (double)(radius * 0.1f);
            z = center.f_82481_ + zOffset * (double)(radius * 0.1f);
            this.m_9236_().m_6493_((ParticleOptions)new TravelParticle.TravelParticleOptions(new Vec3(x, y, z).m_252839_(), ParticleColors.DARK_RED, radius * 0.2f, 1.0f, true, 5), true, center.f_82479_, center.f_82480_, center.f_82481_, 0.0, 0.0, 0.0);
        }
        for (i = 0; i < count; ++i) {
            theta = this.f_19796_.m_188500_() * Math.PI * 2.0;
            phi = this.f_19796_.m_188500_() * Math.PI;
            xOffset = (double)(radius * 0.5f) * Math.sin(phi) * Math.cos(theta);
            yOffset = (double)(radius * 0.5f) * Math.sin(phi) * Math.sin(theta);
            zOffset = (double)(radius * 0.5f) * Math.cos(phi);
            x = center.f_82479_ + xOffset * (double)0.1f;
            y = center.f_82480_ + yOffset * (double)0.1f;
            z = center.f_82481_ + zOffset * (double)0.1f;
            this.m_9236_().m_6493_((ParticleOptions)new TravelParticle.TravelParticleOptions(center.m_252839_(), ParticleColors.LIGHT_RED, radius * 0.1f, 1.0f, true, 5), true, x, y, z, 0.0, 0.0, 0.0);
        }
    }

    private void animate() {
        float size = this.getRadius() / (float)Math.PI;
        float fraction = (float)this.getTime() / 20.0f;
        fraction = fraction < 0.5f ? 2.0f * fraction * fraction : fraction;
        float offset = Mth.m_14179_((float)fraction, (float)(size * 2.0f), (float)0.0f);
        Entity owner = this.m_19749_();
        if (owner == null) {
            return;
        }
        Vec3 look = RotationUtil.getTargetAdjustedLookAngle(owner);
        float yaw = owner.m_146908_();
        Vec3 right = new Vec3(-Math.sin(Math.toRadians(yaw)), 0.0, Math.cos(Math.toRadians(yaw)));
        Vec3 pos = look.m_82537_(right).m_82541_().m_82490_((double)offset);
        Vec3 center = new Vec3(this.m_20185_(), this.m_20186_() + (double)(this.m_20206_() / 2.0f), this.m_20189_());
        this.renderRed(center.m_82549_(pos));
        this.renderBlue(center.m_82546_(pos));
    }

    private void spawnParticles() {
        double z;
        double y;
        double x;
        double zOffset;
        double yOffset;
        double xOffset;
        double phi;
        double theta;
        int i;
        if (this.getTime() <= 20) {
            this.animate();
            return;
        }
        Vec3 center = new Vec3(this.m_20185_(), this.m_20186_() + (double)(this.m_20206_() / 2.0f), this.m_20189_());
        float radius = (float)Math.max(Math.PI, (double)this.getRadius());
        int count = (int)((double)radius * Math.PI * 2.0);
        for (i = 0; i < count; ++i) {
            theta = this.f_19796_.m_188500_() * Math.PI * 2.0;
            phi = this.f_19796_.m_188500_() * Math.PI;
            xOffset = (double)(radius * 0.75f) * Math.sin(phi) * Math.cos(theta);
            yOffset = (double)(radius * 0.75f) * Math.sin(phi) * Math.sin(theta);
            zOffset = (double)(radius * 0.75f) * Math.cos(phi);
            x = center.f_82479_ + xOffset * (double)(radius * 0.1f);
            y = center.f_82480_ + yOffset * (double)(radius * 0.1f);
            z = center.f_82481_ + zOffset * (double)(radius * 0.1f);
            this.m_9236_().m_6493_((ParticleOptions)new TravelParticle.TravelParticleOptions(new Vec3(x, y, z).m_252839_(), ParticleColors.DARK_PURPLE, radius * 0.2f, 1.0f, true, 5), true, center.f_82479_, center.f_82480_, center.f_82481_, 0.0, 0.0, 0.0);
        }
        for (i = 0; i < count; ++i) {
            theta = this.f_19796_.m_188500_() * Math.PI * 2.0;
            phi = this.f_19796_.m_188500_() * Math.PI;
            xOffset = (double)(radius * 0.75f) * Math.sin(phi) * Math.cos(theta);
            yOffset = (double)(radius * 0.75f) * Math.sin(phi) * Math.sin(theta);
            zOffset = (double)(radius * 0.75f) * Math.cos(phi);
            x = center.f_82479_ + xOffset * (double)0.1f;
            y = center.f_82480_ + yOffset * (double)0.1f;
            z = center.f_82481_ + zOffset * (double)0.1f;
            this.m_9236_().m_6493_((ParticleOptions)new TravelParticle.TravelParticleOptions(center.m_252839_(), ParticleColors.LIGHT_PURPLE, radius * 0.2f, 1.0f, true, 5), true, x, y, z, 0.0, 0.0, 0.0);
        }
        for (i = 0; i < 4; ++i) {
            this.m_9236_().m_6493_((ParticleOptions)new EmittingLightningParticle.EmittingLightningParticleOptions(ParticleColors.LIGHT_PURPLE, this.getRadius() * 1.25f, 1), true, this.m_20185_(), this.m_20186_() + (double)(this.m_20206_() / 2.0f), this.m_20189_(), 0.0, 0.0, 0.0);
        }
    }

    @Override
    public void m_8119_() {
        if (this.getTime() == 0) {
            this.m_5496_((SoundEvent)JJKSounds.HOLLOW_PURPLE.get(), 3.0f, 1.0f);
        }
        super.m_8119_();
        this.m_6210_();
        if (this.getTime() >= 100) {
            this.m_146870_();
            return;
        }
        Entity entity = this.m_19749_();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity owner = (LivingEntity)entity;
        this.spawnParticles();
        if (this.getTime() < 40) {
            if (!owner.m_6084_()) {
                this.m_146870_();
            } else {
                if (this.getTime() % 5 == 0) {
                    owner.m_6674_(InteractionHand.MAIN_HAND);
                }
                Vec3 look = RotationUtil.getTargetAdjustedLookAngle((Entity)owner);
                Vec3 spawn = new Vec3(owner.m_20185_(), owner.m_20188_() - (double)(this.m_20206_() / 2.0f), owner.m_20189_()).m_82549_(look.m_82490_((double)(this.getRadius() * 0.5f)));
                this.m_6034_(spawn.f_82479_, spawn.f_82480_, spawn.f_82481_);
                double d0 = look.m_165924_();
                this.m_146922_((float)(Mth.m_14136_((double)look.f_82479_, (double)look.f_82481_) * 57.2957763671875));
                this.m_146926_((float)(Mth.m_14136_((double)look.f_82480_, (double)d0) * 57.2957763671875));
                this.f_19859_ = this.m_146908_();
                this.f_19860_ = this.m_146909_();
            }
        } else {
            if (!this.m_9236_().f_46443_) {
                this.hurtEntities();
                this.breakBlocks();
            }
            if (this.getTime() == 40) {
                this.m_20256_(RotationUtil.getTargetAdjustedLookAngle((Entity)owner).m_82490_(5.0));
                this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11874_, SoundSource.MASTER, 1.0f, 1.0f);
            }
        }
    }
}

