/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.entity.projectile;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;
import radon.jujutsu_kaisen.client.particle.SlicedEntityParticle;
import radon.jujutsu_kaisen.config.ConfigHolder;
import radon.jujutsu_kaisen.damage.JJKDamageSources;
import radon.jujutsu_kaisen.effect.JJKEffects;
import radon.jujutsu_kaisen.entity.JJKEntities;
import radon.jujutsu_kaisen.entity.projectile.base.JujutsuProjectile;
import radon.jujutsu_kaisen.util.EntityUtil;
import radon.jujutsu_kaisen.util.HelperMethods;
import radon.jujutsu_kaisen.util.ParticleUtil;
import radon.jujutsu_kaisen.util.RotationUtil;

public class WorldSlashProjectile
extends JujutsuProjectile {
    public static final int MIN_LENGTH = 3;
    public static final int MAX_LENGTH = 30;
    private static final EntityDataAccessor<Float> DATE_ROLL = SynchedEntityData.m_135353_(WorldSlashProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Integer> DATA_LENGTH = SynchedEntityData.m_135353_(WorldSlashProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final int DURATION = 10;
    private static final float SCALAR = 6.0f;

    public WorldSlashProjectile(EntityType<? extends Projectile> pType, Level pLevel) {
        super(pType, pLevel);
    }

    public WorldSlashProjectile(LivingEntity owner, float power, float roll) {
        super((EntityType<? extends Projectile>)((EntityType)JJKEntities.WORLD_SLASH.get()), owner.m_9236_(), (Entity)owner, power);
        Vec3 look = RotationUtil.getTargetAdjustedLookAngle((Entity)owner);
        EntityUtil.offset((Entity)this, look, new Vec3(owner.m_20185_(), owner.m_20188_() - (double)(this.m_20206_() / 2.0f), owner.m_20189_()).m_82549_(look));
        this.setRoll(roll);
    }

    public WorldSlashProjectile(LivingEntity owner, float power, float roll, Vec3 pos, int length) {
        super((EntityType<? extends Projectile>)((EntityType)JJKEntities.WORLD_SLASH.get()), owner.m_9236_(), (Entity)owner, power);
        Vec3 look = RotationUtil.getTargetAdjustedLookAngle((Entity)owner);
        EntityUtil.offset((Entity)this, look, pos.m_82492_(0.0, (double)(this.m_20206_() / 2.0f), 0.0));
        this.setRoll(roll);
        this.setLength(length);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATE_ROLL, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(DATA_LENGTH, (Object)0);
    }

    public int getLength() {
        int length = (Integer)this.f_19804_.m_135370_(DATA_LENGTH);
        return length > 0 ? length : Math.max(3, Math.min(30, Mth.m_14107_((double)(6.0 * Math.pow(this.getPower(), 2.0)))));
    }

    private void setLength(int length) {
        this.f_19804_.m_135381_(DATA_LENGTH, (Object)length);
    }

    public float getRoll() {
        return ((Float)this.f_19804_.m_135370_(DATE_ROLL)).floatValue();
    }

    private void setRoll(float roll) {
        this.f_19804_.m_135381_(DATE_ROLL, (Object)Float.valueOf(roll));
    }

    @Override
    public boolean canDeflect() {
        return false;
    }

    @Override
    protected void m_7380_(@NotNull CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128350_("roll", this.getRoll());
        pCompound.m_128405_("length", this.getLength());
    }

    @Override
    protected void m_7378_(@NotNull CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.f_19804_.m_135381_(DATE_ROLL, (Object)Float.valueOf(pCompound.m_128457_("roll")));
        this.f_19804_.m_135381_(DATA_LENGTH, (Object)pCompound.m_128451_("length"));
    }

    protected void m_6763_(@NotNull BlockState pState) {
        if (pState.m_60734_().m_155943_() <= -1.0f) {
            this.m_146870_();
        }
    }

    private Vec3[] getWideSlicePositions(Vec3 center, Vec3 forward, Vec3 up, double radius, int samples) {
        Vec3 side = forward.m_82537_(up).m_82541_();
        Vec3 trueUp = side.m_82537_(forward).m_82541_();
        Vec3[] positions = new Vec3[samples * samples];
        int index = 0;
        for (int i = 0; i < samples; ++i) {
            double offsetSide = ((double)i / (double)(samples - 1) - 0.5) * 2.0 * radius;
            for (int j = 0; j < samples; ++j) {
                double offsetUp = ((double)j / (double)(samples - 1) - 0.5) * 2.0 * radius;
                positions[index++] = center.m_82549_(side.m_82490_(offsetSide)).m_82549_(trueUp.m_82490_(offsetUp));
            }
        }
        return positions;
    }

    public Set<Entity> getHits() {
        if (!(this.m_19749_() instanceof LivingEntity)) {
            return Set.of();
        }
        LivingEntity owner = (LivingEntity)this.m_19749_();
        Vec3 center = this.m_20182_().m_82520_(0.0, (double)(this.m_20206_() / 2.0f), 0.0);
        float yaw = this.m_146908_();
        float pitch = this.m_146909_();
        float roll = this.getRoll();
        Vec3 forward = this.m_20171_(pitch, 180.0f - yaw);
        Vec3 up = this.m_20171_(pitch - 90.0f, 180.0f - yaw);
        Quaternionf quaternion = new Quaternionf().rotateAxis((float)Math.toRadians(-roll), (float)forward.f_82479_, (float)forward.f_82480_, (float)forward.f_82481_);
        Vec3 side = new Vec3(quaternion.transform(forward.m_82537_(up).m_252839_()));
        int length = this.getLength();
        Vec3 start = center.m_82549_(side.m_82490_((double)length / 2.0));
        Vec3 end = center.m_82549_(forward.m_82546_(side.m_82490_((double)length / 2.0)));
        HashSet<Entity> hits = new HashSet<Entity>();
        double depth = Math.max(1L, Math.round(this.m_20184_().m_82553_()));
        int z = 0;
        while ((double)z < depth) {
            for (int x = 0; x < length; ++x) {
                Vec3[] slicePositions;
                double radius = 0.25 * Math.pow(this.getPower(), 2.0);
                int samples = 3;
                for (Vec3 pos : slicePositions = this.getWideSlicePositions(start.m_82549_(forward.m_82490_((double)z)).m_82549_(end.m_82546_(start).m_82490_((double)x / (double)length)), forward, up, radius, samples)) {
                    BlockPos current = BlockPos.m_274446_((Position)pos);
                    AABB bounds = AABB.m_165882_((Vec3)current.m_252807_(), (double)1.0, (double)1.0, (double)1.0);
                    hits.addAll(this.m_9236_().m_45933_((Entity)this, bounds));
                    BlockState state = this.m_9236_().m_8055_(current);
                    if (((Boolean)ConfigHolder.SERVER.wcsCutAnything.get()).booleanValue() || HelperMethods.isDestroyable((BlockGetter)owner.m_9236_(), owner, current)) {
                        this.m_9236_().m_46597_(current, Blocks.f_50016_.m_49966_());
                    }
                    if (state.m_60795_()) continue;
                    ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123813_, current.m_252807_().f_82479_, current.m_252807_().f_82480_, current.m_252807_().f_82481_, 0, 1.0, 0.0, 0.0, 1.0);
                }
            }
            ++z;
        }
        return hits;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            for (Entity entity : this.getHits()) {
                LivingEntity owner;
                if (!(entity instanceof LivingEntity)) {
                    entity.m_146870_();
                    continue;
                }
                LivingEntity living = (LivingEntity)entity;
                Entity entity2 = this.m_19749_();
                if (!(entity2 instanceof LivingEntity) || living == (owner = (LivingEntity)entity2)) continue;
                float distance = (float)Math.abs(living.m_20186_() + (double)(living.m_20206_() / 2.0f) - (this.m_20186_() + (double)(this.m_20206_() / 2.0f)));
                if (distance < this.m_20206_()) {
                    distance = 0.0f;
                }
                float strength = 1.0f - Math.min(living.m_20206_(), distance) / living.m_20206_();
                if (!living.m_6469_(JJKDamageSources.worldSlash((Entity)this, owner), living.m_21233_() * strength * this.getPower())) continue;
                if (!((Boolean)ConfigHolder.SERVER.entitySlicing.get()).booleanValue() || !living.m_21224_()) {
                    return;
                }
                Vec3 center = this.m_20182_().m_82520_(0.0, (double)(this.m_20206_() / 2.0f), 0.0);
                float yaw = this.m_146908_();
                float pitch = this.m_146909_();
                float roll = this.getRoll();
                Vec3 forward = this.m_20171_(pitch, yaw);
                Vec3 up = this.m_20171_(pitch - 90.0f, yaw);
                Quaternionf quaternion = new Quaternionf().rotateAxis((float)Math.toRadians(-roll), (float)forward.f_82479_, (float)forward.f_82480_, (float)forward.f_82481_);
                Vec3 side = new Vec3(quaternion.transform(forward.m_82537_(up).m_252839_()));
                int length = this.getLength();
                Vec3 start = side.m_82490_((double)length / 2.0);
                Vec3 end = forward.m_82546_(start);
                Vec3 plane = end.m_82537_(start).m_82541_();
                float dist = (float)plane.m_82526_(center.m_82546_(living.m_20182_()));
                ParticleUtil.sendParticles((ServerLevel)this.m_9236_(), new SlicedEntityParticle.SliceParticleOptions(living.m_19879_(), plane.m_252839_(), dist), true, living.m_20185_(), living.m_20186_(), living.m_20189_(), 0.0, 0.0, 0.0);
                living.m_6842_(true);
                living.m_7292_(new MobEffectInstance((MobEffect)JJKEffects.INVISIBILITY.get(), 60, 0, false, false, false));
                living.m_7292_(new MobEffectInstance(MobEffects.f_19609_, 60, 0, false, false, false));
            }
        }
        if (this.getTime() >= 10) {
            this.m_146870_();
        }
    }
}

