/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.entity.projectile.base;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.FluidType;
import org.jetbrains.annotations.NotNull;

public class JujutsuProjectile
extends Projectile {
    private static final EntityDataAccessor<Integer> DATA_TIME = SynchedEntityData.m_135353_(JujutsuProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> DATA_POWER = SynchedEntityData.m_135353_(JujutsuProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Boolean> DATA_DOMAIN = SynchedEntityData.m_135353_(JujutsuProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public JujutsuProjectile(EntityType<? extends Projectile> pType, Level pLevel) {
        super(pType, pLevel);
    }

    public JujutsuProjectile(EntityType<? extends Projectile> pType, Level pLevel, Entity pShooter) {
        super(pType, pLevel);
        this.m_5602_(pShooter);
    }

    public JujutsuProjectile(EntityType<? extends Projectile> pType, Level pLevel, Entity pShooter, float power) {
        this(pType, pLevel, pShooter);
        this.setPower(power);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DATA_TIME, (Object)0);
        this.f_19804_.m_135372_(DATA_POWER, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(DATA_DOMAIN, (Object)false);
    }

    public int getTime() {
        return (Integer)this.f_19804_.m_135370_(DATA_TIME);
    }

    public void setTime(int time) {
        this.f_19804_.m_135381_(DATA_TIME, (Object)time);
    }

    protected void setPower(float power) {
        this.f_19804_.m_135381_(DATA_POWER, (Object)Float.valueOf(power));
    }

    public float getPower() {
        return ((Float)this.f_19804_.m_135370_(DATA_POWER)).floatValue();
    }

    public boolean isDomain() {
        return (Boolean)this.f_19804_.m_135370_(DATA_DOMAIN);
    }

    public void setDomain(boolean domain) {
        this.f_19804_.m_135381_(DATA_DOMAIN, (Object)domain);
    }

    protected void m_7380_(@NotNull CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128405_("time", this.getTime());
        pCompound.m_128350_("power", this.getPower());
        pCompound.m_128379_("domain", this.isDomain());
    }

    protected void m_7378_(@NotNull CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.setTime(pCompound.m_128451_("time"));
        this.setPower(pCompound.m_128457_("power"));
        this.setDomain(pCompound.m_128471_("domain"));
    }

    public boolean m_6128_() {
        return true;
    }

    public boolean isPushedByFluid(FluidType type) {
        return false;
    }

    protected boolean isProjectile() {
        return true;
    }

    public boolean canDeflect() {
        return true;
    }

    public void m_8119_() {
        this.setTime(this.getTime() + 1);
        Entity owner = this.m_19749_();
        if (!(this.m_9236_().f_46443_ || owner != null && !owner.m_213877_() && owner.m_6084_())) {
            this.m_146870_();
        } else {
            super.m_8119_();
            if (this.isProjectile()) {
                HitResult hit = ProjectileUtil.m_278158_((Entity)this, x$0 -> this.m_5603_((Entity)x$0));
                if (hit.m_6662_() != HitResult.Type.MISS && !ForgeEventFactory.onProjectileImpact((Projectile)this, (HitResult)hit)) {
                    this.m_6532_(hit);
                }
                this.m_20101_();
                Vec3 movement = this.m_20184_();
                double d0 = this.m_20185_() + movement.f_82479_;
                double d1 = this.m_20186_() + movement.f_82480_;
                double d2 = this.m_20189_() + movement.f_82481_;
                this.m_6034_(d0, d1, d2);
            }
        }
    }

    public boolean m_5825_() {
        return true;
    }

    public boolean m_6783_(double pDistance) {
        double d0 = this.m_20191_().m_82309_() * 10.0;
        if (Double.isNaN(d0)) {
            d0 = 1.0;
        }
        return pDistance < (d0 *= 302.0 * JujutsuProjectile.m_20150_()) * d0;
    }

    @NotNull
    public Packet<ClientGamePacketListener> m_5654_() {
        Entity entity = this.m_19749_();
        int i = entity == null ? 0 : entity.m_19879_();
        return new ClientboundAddEntityPacket(this.m_19879_(), this.m_20148_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_146909_(), this.m_146908_(), this.m_6095_(), i, this.m_20184_(), 0.0);
    }

    public void m_141965_(@NotNull ClientboundAddEntityPacket pPacket) {
        super.m_141965_(pPacket);
        this.m_7678_(pPacket.m_131500_(), pPacket.m_131501_(), pPacket.m_131502_(), pPacket.m_237567_(), pPacket.m_237566_());
        this.m_20334_(pPacket.m_131503_(), pPacket.m_131504_(), pPacket.m_131505_());
    }
}

