/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.event;

import java.util.HashSet;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import radon.jujutsu_kaisen.ability.JJKAbilities;
import radon.jujutsu_kaisen.ability.LivingHitByDomainEvent;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.ability.base.DomainExpansion;
import radon.jujutsu_kaisen.capability.data.sorcerer.ISorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.capability.data.ten_shadows.ITenShadowsData;
import radon.jujutsu_kaisen.capability.data.ten_shadows.TenShadowsDataHandler;
import radon.jujutsu_kaisen.entity.ten_shadows.MahoragaEntity;
import radon.jujutsu_kaisen.network.PacketHandler;
import radon.jujutsu_kaisen.network.packet.s2c.SyncSorcererDataS2CPacket;
import radon.jujutsu_kaisen.util.HelperMethods;

public class AdaptationEventHandler {
    private static final int DISRUPTION_DURATION = 20;

    @Mod.EventBusSubscriber(modid="jujutsu_kaisen", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class AdaptationEventHandlerForgeEvents {
        @SubscribeEvent
        public static void onLivingHitByDomain(LivingHitByDomainEvent event) {
            LivingEntity victim = event.getEntity();
            if (!JJKAbilities.hasToggled(victim, (Ability)JJKAbilities.WHEEL.get())) {
                return;
            }
            ITenShadowsData cap = (ITenShadowsData)victim.getCapability(TenShadowsDataHandler.INSTANCE).resolve().orElseThrow();
            if (!cap.isAdaptedTo(event.getAbility())) {
                cap.tryAdapt(event.getAbility());
            }
        }

        @SubscribeEvent
        public static void onLivingHurt(LivingHurtEvent event) {
            LivingEntity victim = event.getEntity();
            if (victim.m_9236_().f_46443_) {
                return;
            }
            if (!victim.getCapability(SorcererDataHandler.INSTANCE).isPresent()) {
                return;
            }
            DamageSource source = event.getSource();
            ISorcererData victimCap = (ISorcererData)victim.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
            if (victimCap.hasToggled((Ability)JJKAbilities.DOMAIN_AMPLIFICATION.get()) || !victimCap.hasToggled((Ability)JJKAbilities.WHEEL.get())) {
                return;
            }
            if (!victim.getCapability(TenShadowsDataHandler.INSTANCE).isPresent()) {
                return;
            }
            ITenShadowsData shadowCap = (ITenShadowsData)victim.getCapability(TenShadowsDataHandler.INSTANCE).resolve().orElseThrow();
            if (!shadowCap.isAdaptedTo(source)) {
                shadowCap.tryAdapt(source);
            }
            if (victim instanceof MahoragaEntity) {
                float process = 1.0f - shadowCap.getAdaptationProgress(source);
                switch (shadowCap.getAdaptationType(source)) {
                    case DAMAGE: {
                        if (shadowCap.isAdaptedTo(source)) {
                            victim.m_9236_().m_6263_(null, victim.m_20185_(), victim.m_20186_(), victim.m_20189_(), SoundEvents.f_12346_, SoundSource.MASTER, 1.0f, 1.0f);
                        }
                        event.setAmount(event.getAmount() * process);
                        break;
                    }
                    case COUNTER: {
                        Entity attacker;
                        event.setAmount(event.getAmount() * process);
                        if (HelperMethods.RANDOM.m_188503_(Math.max(1, Math.round(20.0f * process))) != 0 || (attacker = source.m_7639_()) == null) break;
                        victim.m_7618_(EntityAnchorArgument.Anchor.EYES, attacker.m_20182_());
                        victim.m_6674_(InteractionHand.MAIN_HAND);
                        victim.m_9236_().m_6263_(null, victim.m_20185_(), victim.m_20186_(), victim.m_20189_(), SoundEvents.f_12346_, SoundSource.MASTER, 1.0f, 1.0f);
                        if (!victim.m_7327_(attacker)) break;
                        victim.f_19802_ = 0;
                    }
                }
            }
        }

        @SubscribeEvent
        public static void onLivingAttack(LivingAttackEvent event) {
            LivingEntity victim = event.getEntity();
            if (victim.m_9236_().f_46443_) {
                return;
            }
            if (!victim.getCapability(SorcererDataHandler.INSTANCE).isPresent()) {
                return;
            }
            ISorcererData victimCap = (ISorcererData)victim.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
            DamageSource source = event.getSource();
            Entity entity = source.m_7639_();
            if (!(entity instanceof LivingEntity)) {
                return;
            }
            LivingEntity attacker = (LivingEntity)entity;
            if (!attacker.getCapability(SorcererDataHandler.INSTANCE).isPresent()) {
                return;
            }
            ISorcererData attackerCap = (ISorcererData)attacker.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
            if (victim instanceof MahoragaEntity) {
                ITenShadowsData shadowerCap = (ITenShadowsData)victim.getCapability(TenShadowsDataHandler.INSTANCE).resolve().orElseThrow();
                switch (shadowerCap.getAdaptationType(source)) {
                    case DAMAGE: {
                        if (!shadowerCap.isAdaptedTo(source)) break;
                        victim.m_9236_().m_6263_(null, victim.m_20185_(), victim.m_20186_(), victim.m_20189_(), SoundEvents.f_12346_, SoundSource.MASTER, 1.0f, 1.0f);
                        event.setCanceled(true);
                        break;
                    }
                }
            }
            if (attackerCap.hasToggled((Ability)JJKAbilities.DOMAIN_AMPLIFICATION.get()) || !attackerCap.hasToggled((Ability)JJKAbilities.WHEEL.get())) {
                return;
            }
            if (!attacker.getCapability(TenShadowsDataHandler.INSTANCE).isPresent()) {
                return;
            }
            ITenShadowsData shadowCap = (ITenShadowsData)attacker.getCapability(TenShadowsDataHandler.INSTANCE).resolve().orElseThrow();
            if (JJKAbilities.hasToggled(attacker, (Ability)JJKAbilities.WHEEL.get())) {
                if (victimCap.hasToggled((Ability)JJKAbilities.INFINITY.get())) {
                    shadowCap.tryAdapt((Ability)JJKAbilities.INFINITY.get());
                }
                if (victimCap.hasToggled((Ability)JJKAbilities.SOUL_REINFORCEMENT.get())) {
                    shadowCap.tryAdapt((Ability)JJKAbilities.SOUL_REINFORCEMENT.get());
                }
            }
            if (attacker instanceof MahoragaEntity) {
                HashSet<Ability> toggled = new HashSet<Ability>(victimCap.getToggled());
                for (Ability ability : toggled) {
                    if (ability instanceof DomainExpansion.IOpenDomain || !shadowCap.isAdaptedTo(ability)) continue;
                    victimCap.disrupt(ability, 20 * shadowCap.getAdaptation(ability));
                    victim.m_9236_().m_6263_(null, victim.m_20185_(), victim.m_20186_(), victim.m_20189_(), SoundEvents.f_11705_, SoundSource.MASTER, 1.0f, 1.0f);
                }
                Ability channeled = victimCap.getChanneled();
                if (channeled != null && shadowCap.isAdaptedTo(channeled)) {
                    victimCap.disrupt(channeled, 20 * shadowCap.getAdaptation(channeled));
                }
                if (victim instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)victim;
                    PacketHandler.sendToClient(new SyncSorcererDataS2CPacket(victimCap.serializeNBT()), player);
                }
            }
        }
    }
}

