/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.event;

import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDestroyBlockEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.level.ExplosionEvent;
import net.minecraftforge.event.level.SleepFinishedTimeEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import radon.jujutsu_kaisen.VeilHandler;
import radon.jujutsu_kaisen.ability.AbilityStopEvent;
import radon.jujutsu_kaisen.ability.AbilityTriggerEvent;
import radon.jujutsu_kaisen.ability.JJKAbilities;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.block.VeilBlock;
import radon.jujutsu_kaisen.block.VeilRodBlock;
import radon.jujutsu_kaisen.capability.data.sorcerer.CursedTechnique;
import radon.jujutsu_kaisen.capability.data.sorcerer.ISorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.JujutsuType;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.capability.data.sorcerer.Trait;
import radon.jujutsu_kaisen.capability.data.ten_shadows.ITenShadowsData;
import radon.jujutsu_kaisen.capability.data.ten_shadows.TenShadowsDataHandler;
import radon.jujutsu_kaisen.config.ConfigHolder;
import radon.jujutsu_kaisen.damage.JJKDamageSources;
import radon.jujutsu_kaisen.entity.base.JJKPartEntity;
import radon.jujutsu_kaisen.entity.base.SummonEntity;
import radon.jujutsu_kaisen.entity.curse.base.CursedSpirit;
import radon.jujutsu_kaisen.entity.projectile.ThrownChainProjectile;
import radon.jujutsu_kaisen.entity.sorcerer.HeianSukunaEntity;
import radon.jujutsu_kaisen.entity.sorcerer.SukunaEntity;
import radon.jujutsu_kaisen.entity.sorcerer.base.SorcererEntity;
import radon.jujutsu_kaisen.item.CursedEnergyFleshItem;
import radon.jujutsu_kaisen.item.JJKItems;
import radon.jujutsu_kaisen.item.base.CursedToolItem;
import radon.jujutsu_kaisen.network.PacketHandler;
import radon.jujutsu_kaisen.network.packet.s2c.SyncSorcererDataS2CPacket;
import radon.jujutsu_kaisen.util.CuriosUtil;
import radon.jujutsu_kaisen.util.HelperMethods;
import radon.jujutsu_kaisen.util.PlayerUtil;
import radon.jujutsu_kaisen.util.SorcererUtil;
import virtuoel.pehkui.api.ScaleData;
import virtuoel.pehkui.api.ScaleTypes;

public class JJKEventHandler {

    @Mod.EventBusSubscriber(modid="jujutsu_kaisen", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class JJKEventHandlerForgeEvents {
        @SubscribeEvent
        public static void onExplosion(ExplosionEvent.Detonate event) {
            Explosion explosion = event.getExplosion();
            LivingEntity instigator = explosion.m_252906_();
            Iterator iter = explosion.m_46081_().iterator();
            while (iter.hasNext()) {
                BlockPos pos = (BlockPos)iter.next();
                Vec3 center = pos.m_252807_();
                if (VeilHandler.canDestroy(instigator, event.getLevel(), center.f_82479_, center.f_82480_, center.f_82481_)) continue;
                iter.remove();
            }
        }

        @SubscribeEvent
        public static void onEntityTeleport(EntityTeleportEvent event) {
            Level level = event.getEntity().m_9236_();
            if (level.f_46443_) {
                return;
            }
            BlockPos from = BlockPos.m_274561_((double)event.getPrevX(), (double)event.getPrevY(), (double)event.getPrevZ());
            BlockPos to = BlockPos.m_274561_((double)event.getTargetX(), (double)event.getTargetY(), (double)event.getTargetZ());
            if (!VeilHandler.isTeleportValid(level, from) || !VeilHandler.isTeleportValid(level, to)) {
                event.setCanceled(true);
            } else {
                ServerLevel serverLevel = (ServerLevel)level;
                if (!VeilHandler.getDomains(serverLevel, from).isEmpty() || !VeilHandler.getDomains(serverLevel, to).isEmpty()) {
                    event.setCanceled(true);
                }
            }
        }

        @SubscribeEvent
        public static void onLivingDestroyBlock(LivingDestroyBlockEvent event) {
            LivingEntity entity = event.getEntity();
            Vec3 center = event.getPos().m_252807_();
            if (!VeilHandler.canDestroy(event.getEntity(), entity.m_9236_(), center.f_82479_, center.f_82480_, center.f_82481_)) {
                event.setCanceled(true);
            }
        }

        @SubscribeEvent
        public static void onBlockBreak(BlockEvent.BreakEvent event) {
            Player player = event.getPlayer();
            BlockPos pos = event.getPos();
            Level level = (Level)event.getLevel();
            BlockState state = level.m_8055_(pos);
            Block block = state.m_60734_();
            if (block instanceof VeilRodBlock || block instanceof VeilBlock) {
                return;
            }
            Vec3 center = pos.m_252807_();
            if (!VeilHandler.canDestroy((LivingEntity)player, level, center.f_82479_, center.f_82480_, center.f_82481_)) {
                event.setCanceled(true);
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    serverLevel.m_7260_(pos, level.m_8055_(pos), level.m_8055_(pos), 3);
                }
            }
        }

        @SubscribeEvent
        public static void onBlockPlace(BlockEvent.EntityPlaceEvent event) {
            BlockPos pos;
            Entity entity = event.getEntity();
            ServerLevel level = (ServerLevel)event.getLevel();
            if (!VeilHandler.getDomains(level, pos = event.getPos()).isEmpty()) {
                event.setCanceled(true);
            }
        }

        @SubscribeEvent
        public static void onSleepFinished(SleepFinishedTimeEvent event) {
            LevelAccessor levelAccessor = event.getLevel();
            if (!(levelAccessor instanceof ServerLevel)) {
                return;
            }
            ServerLevel level = (ServerLevel)levelAccessor;
            for (ServerPlayer player : level.m_6907_()) {
                if (!player.m_36317_() || !player.getCapability(SorcererDataHandler.INSTANCE).isPresent()) continue;
                ISorcererData cap = (ISorcererData)player.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
                cap.setEnergy(cap.getMaxEnergy());
                PacketHandler.sendToClient(new SyncSorcererDataS2CPacket(cap.serializeNBT()), player);
            }
        }

        @SubscribeEvent
        public static void onAttackEntity(AttackEntityEvent event) {
            if (event.getTarget() instanceof JJKPartEntity) {
                Entity parent = ((JJKPartEntity)event.getTarget()).getParent();
                if (parent != null) {
                    event.getEntity().m_5706_(parent);
                }
                event.setCanceled(true);
            }
        }

        @SubscribeEvent
        public static void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
            Player player = event.getEntity();
            if (!(player instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer player2 = (ServerPlayer)player;
            for (SukunaEntity sukuna : player2.m_9236_().m_45976_(SukunaEntity.class, AABB.m_165882_((Vec3)player2.m_20182_(), (double)8.0, (double)8.0, (double)8.0))) {
                if (sukuna.getOwner() != player2) continue;
                player2.m_143403_(sukuna.getOriginal(player2));
            }
        }

        @SubscribeEvent
        public static void onPlayerClone(PlayerEvent.Clone event) {
            Player original = event.getOriginal();
            Player player = event.getEntity();
            original.reviveCaps();
            ISorcererData oldCap = (ISorcererData)original.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
            ISorcererData newCap = (ISorcererData)player.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
            newCap.deserializeNBT(oldCap.serializeNBT());
            if (event.isWasDeath()) {
                newCap.setEnergy(newCap.getMaxEnergy());
                newCap.resetCooldowns();
                newCap.resetBurnout();
                newCap.resetDisable();
                newCap.clearToggled();
                newCap.setCurrentCopied(null);
                newCap.setCurrentStolen(null);
                newCap.resetCopy();
                newCap.resetBlackFlash();
                newCap.resetExtraEnergy();
                newCap.resetSpeedStacks();
                newCap.resetDash();
                if (player.getCapability(TenShadowsDataHandler.INSTANCE).isPresent()) {
                    ITenShadowsData shadowCap = (ITenShadowsData)player.getCapability(TenShadowsDataHandler.INSTANCE).resolve().orElseThrow();
                    shadowCap.resetAdaptations();
                }
                if (!player.m_9236_().f_46443_) {
                    PacketHandler.sendToClient(new SyncSorcererDataS2CPacket(newCap.serializeNBT()), (ServerPlayer)player);
                }
            }
            original.invalidateCaps();
        }

        @SubscribeEvent
        public static void onLivingDamage(LivingDamageEvent event) {
            LivingEntity victim = event.getEntity();
            Entity entity = event.getSource().m_7639_();
            if (!(entity instanceof LivingEntity)) {
                return;
            }
            LivingEntity owner = (LivingEntity)entity;
            if (!owner.getCapability(SorcererDataHandler.INSTANCE).isPresent()) {
                return;
            }
            ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
            if (cap.hasTrait(Trait.DEATH_PAINTING) && owner.m_21223_() < owner.m_21233_() * 0.3f && HelperMethods.isMelee(event.getSource())) {
                victim.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 200, 4));
                victim.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 200, 0));
            }
            if (victim.m_21223_() - event.getAmount() <= 0.0f) {
                return;
            }
            cap.attack(event.getSource(), victim);
            if (victim.m_21224_()) {
                event.setCanceled(true);
            }
        }

        @SubscribeEvent
        public static void onLivingTick(LivingEvent.LivingTickEvent event) {
            LivingEntity owner = event.getEntity();
            if (owner.m_21224_()) {
                return;
            }
            if (!owner.getCapability(SorcererDataHandler.INSTANCE).isPresent()) {
                return;
            }
            ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
            cap.tick(owner);
            if (cap.hasTrait(Trait.SIX_EYES) && !owner.m_6844_(EquipmentSlot.HEAD).m_150930_((Item)JJKItems.BLINDFOLD.get()) && !CuriosUtil.findSlot(owner, "head").m_150930_((Item)JJKItems.BLINDFOLD.get()) || cap.hasTrait(Trait.HEAVENLY_RESTRICTION)) {
                owner.m_7292_(new MobEffectInstance(MobEffects.f_19611_, 220, 0, false, false, false));
            }
            if (cap.hasTrait(Trait.DEATH_PAINTING) && owner.m_21223_() / owner.m_21233_() < 0.3f) {
                double x = owner.m_20185_() + (owner.m_217043_().m_188500_() - 0.5) * (double)owner.m_20205_();
                double y = owner.m_20186_() + (double)owner.m_20206_() * 0.5 + (owner.m_217043_().m_188500_() - 0.5) * 0.5;
                double z = owner.m_20189_() + (owner.m_217043_().m_188500_() - 0.5) * (double)owner.m_20205_();
                owner.m_9236_().m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50330_.m_49966_()), x, y, z, 0.0, 0.05, 0.0);
            }
            if (!owner.m_9236_().f_46443_) {
                if (cap.hasToggled((Ability)JJKAbilities.SHRINK.get())) {
                    ScaleData baseScale = ScaleTypes.BASE.getScaleData((Entity)owner);
                    float targetScale = 0.5f;
                    float currentScale = baseScale.getScale();
                    float newScale = currentScale + (targetScale - currentScale) * 0.1f;
                    baseScale.setScale(newScale);
                    baseScale.markForSync(true);
                } else if (cap.hasTrait(Trait.CURSED_WOMB)) {
                    if (owner instanceof Player && cap != null) {
                        float targetScale = 0.8f;
                        float targetWidth = 1.2f;
                        if (cap.checkWombAwakened()) {
                            targetScale = 1.1f;
                            targetWidth = 1.0f;
                        }
                        ScaleData baseScale = ScaleTypes.BASE.getScaleData((Entity)owner);
                        ScaleData baseWidth = ScaleTypes.WIDTH.getScaleData((Entity)owner);
                        baseScale.setScale(targetScale);
                        baseWidth.setScale(targetWidth);
                    }
                } else {
                    ScaleData baseScale = ScaleTypes.BASE.getScaleData((Entity)owner);
                    ScaleData baseWidth = ScaleTypes.WIDTH.getScaleData((Entity)owner);
                    if (!baseScale.isReset() || !baseWidth.isReset()) {
                        baseWidth.resetScale(true);
                        baseScale.resetScale(true);
                    }
                }
            }
            if (cap.hasTrait(Trait.HEAVENLY_RESTRICTION)) {
                owner.m_7292_(new MobEffectInstance(MobEffects.f_19598_, 2, 1, false, false, false));
            }
            owner.m_7292_(new MobEffectInstance(MobEffects.f_19603_, 2, 2, false, false, false));
            if (owner instanceof Player) {
                Player player = (Player)owner;
                if (cap.getType() == JujutsuType.SORCERER && ((Boolean)ConfigHolder.SERVER.sorcererSaturation.get()).booleanValue() || cap.getType() == JujutsuType.CURSE && ((Boolean)ConfigHolder.SERVER.curseSaturation.get()).booleanValue()) {
                    player.m_36324_().m_38705_(20);
                }
            }
            if (!owner.getCapability(TenShadowsDataHandler.INSTANCE).isPresent()) {
                return;
            }
            ITenShadowsData shadowCap = (ITenShadowsData)owner.getCapability(TenShadowsDataHandler.INSTANCE).resolve().orElseThrow();
            shadowCap.tick(owner);
        }

        @SubscribeEvent
        public static void onLivingFall(LivingFallEvent event) {
            LivingEntity victim = event.getEntity();
            event.getEntity().getCapability(SorcererDataHandler.INSTANCE).ifPresent(cap -> {
                if (cap.hasTrait(Trait.HEAVENLY_RESTRICTION)) {
                    event.setDistance(event.getDistance() * 0.1f);
                } else {
                    event.setDistance(event.getDistance() * 0.33f);
                }
            });
        }

        @SubscribeEvent
        public static void onLivingAttack(LivingAttackEvent event) {
            DamageSource source = event.getSource();
            Entity entity = source.m_7639_();
            if (!(entity instanceof LivingEntity)) {
                return;
            }
            LivingEntity attacker = (LivingEntity)entity;
            LivingEntity victim = event.getEntity();
            if (victim.m_9236_().f_46443_) {
                return;
            }
            if (((Boolean)ConfigHolder.SERVER.realisticCurses.get()).booleanValue()) {
                ItemStack itemStack;
                Entity entity2 = source.m_7640_();
                if (entity2 instanceof ThrownChainProjectile) {
                    ThrownChainProjectile chain = (ThrownChainProjectile)entity2;
                    itemStack = chain.getStack();
                } else {
                    itemStack = attacker.m_21120_(InteractionHand.MAIN_HAND);
                }
                ItemStack stack = itemStack;
                ArrayList<Item> stacks = new ArrayList<Item>();
                stacks.add(stack.m_41720_());
                stacks.addAll(CuriosUtil.findSlots(attacker, attacker.m_5737_() == HumanoidArm.RIGHT ? "right_hand" : "left_hand").stream().map(ItemStack::m_41720_).toList());
                if (!victim.getCapability(SorcererDataHandler.INSTANCE).isPresent()) {
                    return;
                }
                ISorcererData cap = (ISorcererData)victim.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
                if (cap.getType() == JujutsuType.CURSE && !cap.hasTrait(Trait.DEATH_PAINTING)) {
                    boolean cursed = false;
                    if (event.getSource() instanceof JJKDamageSources.JujutsuDamageSource) {
                        cursed = true;
                    } else if (HelperMethods.isMelee(source) && stacks.stream().anyMatch(item -> item instanceof CursedToolItem)) {
                        cursed = true;
                    } else if (attacker.getCapability(SorcererDataHandler.INSTANCE).isPresent()) {
                        cursed = true;
                    }
                    if (!cursed) {
                        event.setCanceled(true);
                    }
                }
            }
        }

        @SubscribeEvent(priority=EventPriority.LOWEST)
        public static void onLivingHurt(LivingHurtEvent event) {
            SummonEntity summon;
            CursedSpirit curse;
            SummonEntity summon2;
            CursedSpirit curse2;
            ISorcererData victimcap;
            CursedSpirit curse3;
            SummonEntity sum;
            SorcererEntity sorc;
            LivingEntity victim = event.getEntity();
            if (victim.m_9236_().f_46443_) {
                return;
            }
            DamageSource source = event.getSource();
            if (source instanceof JJKDamageSources.JujutsuDamageSource) {
                Entity entity = source.m_7639_();
                if (!(entity instanceof LivingEntity)) {
                    return;
                }
                sourceUser = (LivingEntity)entity;
                capSelf = (ISorcererData)sourceUser.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
                if (source.m_7639_() == victim && !capSelf.hasSelfHit()) {
                    event.setAmount(event.getAmount() * 0.1f);
                }
            } else {
                capSelf = source.m_7639_();
                if (capSelf instanceof LivingEntity) {
                    ISorcererData attackerCap;
                    sourceUser = (LivingEntity)capSelf;
                    if (HelperMethods.isMelee(source) && sourceUser.getCapability(SorcererDataHandler.INSTANCE).isPresent() && (attackerCap = (ISorcererData)sourceUser.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow()).getEnergy() <= 0.0f) {
                        ISorcererData victimCap;
                        ItemStack itemStack;
                        Entity entity = source.m_7640_();
                        if (entity instanceof ThrownChainProjectile) {
                            ThrownChainProjectile chain = (ThrownChainProjectile)entity;
                            itemStack = chain.getStack();
                        } else {
                            itemStack = sourceUser.m_21120_(InteractionHand.MAIN_HAND);
                        }
                        ItemStack stack = itemStack;
                        ArrayList<Item> stacks = new ArrayList<Item>();
                        stacks.add(stack.m_41720_());
                        stacks.addAll(CuriosUtil.findSlots(sourceUser, sourceUser.m_5737_() == HumanoidArm.RIGHT ? "right_hand" : "left_hand").stream().map(ItemStack::m_41720_).toList());
                        if (!stacks.stream().anyMatch(item -> item instanceof CursedToolItem) && (victimCap = (ISorcererData)victim.getCapability(SorcererDataHandler.INSTANCE).resolve().orElse(null)) != null && victimCap.getType() == JujutsuType.CURSE && !victimCap.hasTrait(Trait.DEATH_PAINTING)) {
                            event.setAmount(0.0f);
                        }
                    }
                }
            }
            Entity attackerEntity = source.m_7639_();
            if (attackerEntity instanceof Projectile) {
                Projectile projectile = (Projectile)attackerEntity;
                attackerEntity = projectile.m_19749_();
            }
            if (!(attackerEntity instanceof LivingEntity)) {
                return;
            }
            LivingEntity attacker = (LivingEntity)attackerEntity;
            if (!(attackerEntity instanceof Player) && attackerEntity instanceof CursedSpirit) {
                event.setAmount(event.getAmount() * ((Double)ConfigHolder.SERVER.curseDamageMult.get()).floatValue());
            }
            if (!(victim instanceof Player) && victim instanceof CursedSpirit) {
                event.setAmount(event.getAmount() * ((Double)ConfigHolder.SERVER.curseDefenseMult.get()).floatValue());
            }
            if (!(attackerEntity instanceof Player) && attackerEntity instanceof SorcererEntity && (sorc = (SorcererEntity)attackerEntity).getJujutsuType() == JujutsuType.SORCERER) {
                event.setAmount(event.getAmount() * ((Double)ConfigHolder.SERVER.sorcererDamageMult.get()).floatValue());
            }
            if (!(victim instanceof Player) && victim instanceof SorcererEntity && (sorc = (SorcererEntity)victim).getJujutsuType() == JujutsuType.SORCERER) {
                event.setAmount(event.getAmount() * ((Double)ConfigHolder.SERVER.sorcererDefenseMult.get()).floatValue());
            }
            if (attackerEntity instanceof Player || attackerEntity instanceof SummonEntity && (sum = (SummonEntity)attackerEntity).m_21824_() && sum.m_269323_() instanceof Player || attackerEntity instanceof CursedSpirit && (curse3 = (CursedSpirit)attackerEntity).m_21824_() && curse3.m_269323_() instanceof Player) {
                event.setAmount(event.getAmount() * ((Double)ConfigHolder.SERVER.playerDamageMult.get()).floatValue());
            }
            if (JJKAbilities.hasTrait(attacker, Trait.PERFECT_BODY)) {
                attacker.getCapability(SorcererDataHandler.INSTANCE).ifPresent(capSelf -> {
                    if (HelperMethods.isMelee(source) && !capSelf.hasToggled((Ability)JJKAbilities.HOLLOW_WICKER_BASKET.get())) {
                        event.setAmount(event.getAmount() * ((Double)ConfigHolder.SERVER.perfectBodyMult.get()).floatValue());
                    }
                });
            }
            if (victim.getCapability(SorcererDataHandler.INSTANCE).isPresent() && (victimcap = (ISorcererData)victim.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow()) != null && victimcap.hasExtraMeleeTaken() && HelperMethods.isMelee(source)) {
                event.setAmount(event.getAmount() * 1.35f);
            }
            if (source.m_269533_(DamageTypeTags.f_268490_)) {
                return;
            }
            if (!victim.getCapability(SorcererDataHandler.INSTANCE).isPresent()) {
                return;
            }
            ISorcererData cap = (ISorcererData)victim.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
            float armor = SorcererUtil.getDefense(cap.getExperience());
            if (victim instanceof Player) {
                armor *= ((Double)ConfigHolder.SERVER.jujutsuDefenseMult.get()).floatValue();
            }
            if (cap.hasTrait(Trait.HEAVENLY_RESTRICTION)) {
                armor = SorcererUtil.getDefenseHR(cap.getExperience());
                if (victim instanceof Player) {
                    armor *= ((Double)ConfigHolder.SERVER.hrDefenseMult.get()).floatValue();
                }
            }
            if (!(victim instanceof Player || attackerEntity instanceof Player || victim instanceof CursedSpirit && (curse2 = (CursedSpirit)victim).m_21824_() || victim instanceof SummonEntity && (summon2 = (SummonEntity)victim).m_21824_() || attackerEntity instanceof CursedSpirit && (curse = (CursedSpirit)attackerEntity).m_21824_() || attackerEntity instanceof SummonEntity && (summon = (SummonEntity)attackerEntity).m_21824_())) {
                event.setAmount(event.getAmount() * ((Double)ConfigHolder.SERVER.npcvsnpcDamageMult.get()).floatValue());
            }
            float blocked = event.getAmount() / armor;
            event.setAmount(blocked);
        }

        @SubscribeEvent
        public static void onLivingDeath(LivingDeathEvent event) {
            DamageSource source;
            Entity player2;
            Object object;
            LivingEntity victim = event.getEntity();
            if (victim.m_9236_().f_46443_) {
                return;
            }
            if (!victim.getCapability(SorcererDataHandler.INSTANCE).isPresent()) {
                return;
            }
            ISorcererData victimCap = (ISorcererData)victim.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
            switch (victimCap.getType()) {
                case SORCERER: {
                    if (HelperMethods.RANDOM.m_188503_(((Integer)ConfigHolder.SERVER.sorcererFleshRarity.get()).intValue()) != 0) break;
                    ItemStack stack = new ItemStack((ItemLike)JJKItems.SORCERER_FLESH.get());
                    CursedEnergyFleshItem.setGrade(stack, SorcererUtil.getGrade(victimCap.getExperience()));
                    victim.m_19983_(stack);
                    break;
                }
                case CURSE: {
                    if (HelperMethods.RANDOM.m_188503_(((Integer)ConfigHolder.SERVER.curseFleshRarity.get()).intValue()) != 0) break;
                    ItemStack stack = new ItemStack((ItemLike)JJKItems.CURSE_FLESH.get());
                    CursedEnergyFleshItem.setGrade(stack, SorcererUtil.getGrade(victimCap.getExperience()));
                    victim.m_19983_(stack);
                }
            }
            if (victimCap.hasTrait(Trait.DEATH_PAINTING) && (object = victim.m_9236_()) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)object;
                for (Entity player2 : serverLevel.m_6907_()) {
                    ISorcererData cap;
                    if (player2 == victim || !player2.getCapability(SorcererDataHandler.INSTANCE).isPresent() || !(cap = (ISorcererData)player2.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow()).hasTrait(Trait.DEATH_PAINTING)) continue;
                    player2.m_213846_((Component)Component.m_237110_((String)String.format("chat.%s.siblingdeath", "jujutsu_kaisen"), (Object[])new Object[]{victim.m_7755_()}));
                }
            }
            if (!((player2 = (source = event.getSource()).m_7639_()) instanceof LivingEntity)) {
                return;
            }
            LivingEntity attacker = (LivingEntity)player2;
            if (attacker instanceof ServerPlayer) {
                player2 = (ServerPlayer)attacker;
                if (victim instanceof HeianSukunaEntity && victimCap.getFingers() == 20) {
                    PlayerUtil.giveAdvancement((ServerPlayer)player2, "the_strongest_of_all_time");
                }
            }
        }

        @SubscribeEvent
        public static void onAbilityStop(AbilityStopEvent event) {
            Ability ability = event.getAbility();
            CursedTechnique technique = JJKAbilities.getTechnique(ability);
            LivingEntity owner = event.getEntity();
            ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
            if (technique != null && cap.getAbsorbed().contains((Object)technique)) {
                cap.unabsorb(technique);
            }
        }

        @SubscribeEvent
        public static void onAbilityTrigger(AbilityTriggerEvent.Pre event) {
            Ability ability = event.getAbility();
            CursedTechnique technique = JJKAbilities.getTechnique(ability);
            LivingEntity owner = event.getEntity();
            ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
            if (ability.getActivationType(owner) == Ability.ActivationType.INSTANT && technique != null && cap.getAbsorbed().contains((Object)technique)) {
                cap.unabsorb(technique);
            }
        }
    }
}

